/*
=============================================================================
Module Information
------------------
Name:			clmenus.cpp
Author:			Rich Whitehouse
Description:	client module menu routine implementations.
				the menu system is terrible. this is all terrible. should be
				rewritten with a better data-driven support system some day.
=============================================================================
*/

#include "clmain.h"

static int g_forgeMode = -1;
#define MAX_LIST_LEN		32768

extern statInfo_t g_statInfo[5];

void LCl_UpdateForgeMenu(void);
void LCl_MenuFillForgeContent(menu_t *menu);

//error sound
void LCl_MenuErrorSound(void)
{
	g_sharedFn->S_PlayWave(g_sharedFn->S_CacheSound("assets/sound/menu/menuerr.wav"), NULL, 1.0f, false, -1, -1);
}

//get rid of forge menu
void LCl_MenuForgeQuit(void)
{
	menu_t *menu = g_sharedFn->Menu_GetMenu("forgetext");
	if (!menu)
	{
		return;
	}
	menu->selectable = false;
	menuPointer_t *mptr = g_sharedFn->Menu_GetMenuPointer();
	if (mptr->selected == menu)
	{ //deselect if this menu was selected
		mptr->selected = NULL;
	}
	menu->textSelLineCount = 0;
	menu->textSelPtr = NULL;
	g_sharedFn->Menu_SetDraw(menu, false);
	menu->x = 680;

	menu = g_sharedFn->Menu_GetMenu("helptext");
	if (!menu)
	{
		return;
	}
	menu->x = 680;
	g_sharedFn->Menu_SetDraw(menu, false);

	g_sharedFn->Menu_StopScript("noabilities");
	menu = g_sharedFn->Menu_GetMenu("noabilbox");
	if (!menu)
	{
		return;
	}
	menu->y = -50;
	g_sharedFn->Menu_SetDraw(menu, false);
}

//get rid of ingame menu
void LCl_MenuInGameQuit(void)
{
	menu_t *menu = g_sharedFn->Menu_GetMenu("ingametext");
	if (!menu)
	{
		return;
	}
	menu->selectable = false;
	menuPointer_t *mptr = g_sharedFn->Menu_GetMenuPointer();
	if (mptr->selected == menu)
	{ //deselect if this menu was selected
		mptr->selected = NULL;
	}
	menu->textSelLineCount = 0;
	menu->textSelPtr = NULL;
	g_sharedFn->Menu_SetDraw(menu, false);
	menu->x = 680;

	menu = g_sharedFn->Menu_GetMenu("ingamestatnumbers");
	if (!menu)
	{
		return;
	}
	menu->x = -130;
	g_sharedFn->Menu_SetDraw(menu, false);

	menu = g_sharedFn->Menu_GetMenu("ingamestats");
	if (!menu)
	{
		return;
	}
	menu->x = -280;
	g_sharedFn->Menu_SetDraw(menu, false);

	menu = g_sharedFn->Menu_GetMenu("helptext");
	if (!menu)
	{
		return;
	}
	menu->x = 680;
	g_sharedFn->Menu_SetDraw(menu, false);

	menu = g_sharedFn->Menu_GetMenu("ingamestatitem");
	if (!menu)
	{
		return;
	}
	menu->x = -265;
	g_sharedFn->Menu_SetDraw(menu, false);

	g_sharedFn->Menu_StopScript("noabilities");
	menu = g_sharedFn->Menu_GetMenu("noabilbox");
	if (!menu)
	{
		return;
	}
	menu->y = -50;
	g_sharedFn->Menu_SetDraw(menu, false);
}

//get mapped index
static int LCl_ValidItemIndex(int index)
{
	int validItemCount = 0;
	int selIndex = -1;
	for (int i = 0; i < MAX_PLAYER_INVENTORY_ITEMS; i++)
	{
		playerInvItem_t *plItem = &g_clientState.localPl->inventory[i];
		if (validItemCount == index && plItem->itemQuantity > 0)
		{
			selIndex = i;
			break;
		}
		if (plItem->itemQuantity > 0)
		{
			validItemCount++;
		}
	}
	return selIndex;
}

//update stat menu
void LCl_UpdateStatMenu(void)
{
	LCl_UpdateForgeMenu();
	menu_t *menu = g_sharedFn->Menu_GetActiveMenu("descbox");
	if (menu && menu->draw)
	{
		menu_t *equipMenu = g_sharedFn->Menu_GetActiveMenu("equiplist");
		if (equipMenu)
		{
			int validItemCount = 0;
			int selIndex = LCl_ValidItemIndex(equipMenu->textSelLineCount);
			if (selIndex != -1)
			{
				playerInvItem_t *plItem = &g_clientState.localPl->inventory[selIndex];
				const invItemDef_t *item = &g_invItems[plItem->itemIndex];
				if (menu->text)
				{
					g_sharedFn->Common_RCFree(menu->text);
				}
				char str[4096];
				if (item->desc && item->desc[0])
				{
					sprintf(str, "*$%s$%s\n*(1 1 1 1)%s", item->icon, item->name, item->desc);
				}
				else
				{
					str[0] = 0;
				}
				menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(str)+1);
				strcpy(menu->text, str);
			}
		}
		else
		{
			menu_t *abilMenu = g_sharedFn->Menu_GetActiveMenu("abilitylist");
			if (abilMenu)
			{
				int selIndex = -1;
				char abilStr[MAX_LIST_LEN];
				abilStr[0] = 0;
				int numAbilities = 0;
				for (int i = 0; i < NUM_PLAYER_ABILITIES; i++)
				{
					if (g_clientState.localPl->abilities & (1<<i))
					{
						if (numAbilities == abilMenu->textSelLineCount)
						{
							selIndex = i;
							break;
						}
						numAbilities++;
					}
				}
				if (selIndex != -1)
				{
					const playerAbility_t *abil = &g_plAbilities[selIndex];
					if (menu->text)
					{
						g_sharedFn->Common_RCFree(menu->text);
					}
					char str[4096];
					sprintf(str, "%s\n*(1 1 1 1)%s", abil->name, abil->desc);
					menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(str)+1);
					strcpy(menu->text, str);
				}
			}
		}
	}

	menu = g_sharedFn->Menu_GetActiveMenu("ingamestatnumbers");
	if (!menu || !menu->draw)
	{
		return;
	}
	if (menu->text)
	{
		g_sharedFn->Common_RCFree(menu->text);
	}
	char str[256];
	float fontColorVal = -1.0f;
	if (g_hudState.lastHealth < g_hudState.lastMaxHealth/4)
	{
		fontColorVal = 1.0f;
		float pulse = sinf((float)g_curTime*0.007f);
		fontColorVal *= (0.65f + (pulse*0.35f));
	}
	sprintf(str, "*(%f 0 0 1)%03i*(-1 0 0 1)/%03i\n%i/%i\n\n%i\n%i\n%i\n%i\n", fontColorVal,
		g_hudState.lastHealth, g_hudState.lastMaxHealth, g_hudState.lastMakoChargeCount, g_hudState.lastMakoChargeCountMax,
		g_clientState.localPl->statStr, g_clientState.localPl->statDef, g_clientState.localPl->statDex, g_clientState.localPl->statLuck);
	menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(str)+1);
	strcpy(menu->text, str);

	menu = g_sharedFn->Menu_GetActiveMenu("ingamestatitem");
	if (!menu || !menu->draw)
	{
		return;
	}
	const invItemDef_t *drawItem = NULL;
	if (g_hudState.lastEquippedItem)
	{
		playerInvItem_t *plItem = &g_clientState.localPl->inventory[g_hudState.lastEquippedItem];
		if (plItem->itemQuantity > 0)
		{
			const invItemDef_t *item = &g_invItems[plItem->itemIndex];
			if (item->icon && item->icon[0])
			{
				drawItem = item;
			}
		}
	}

	if (drawItem)
	{
		if (menu->text)
		{
			g_sharedFn->Common_RCFree(menu->text);
		}
		menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(drawItem->name)+1);
		strcpy(menu->text, drawItem->name);
		g_sharedFn->Img_TextureLoad(drawItem->icon, &menu->texture);
	}
	else
	{
		drawItem = &g_invItems[0];
		if (menu->text)
		{
			g_sharedFn->Common_RCFree(menu->text);
		}
		menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(drawItem->name)+1);
		strcpy(menu->text, drawItem->name);
		menu->texture.inuse = false;
	}
}

//get selected string
char *LCl_MenuGetStringSel(menu_t *menu)
{
	static char buf[2048];
	if (!menu->textSelPtr)
	{
		return NULL;
	}
	buf[0] = 0;
	int j = 0;
	for (int i = 0; menu->textSelPtr[i] && menu->textSelPtr[i] != '\n' && menu->textSelPtr[i] != '\r'; i++)
	{
		if (menu->textSelPtr[i] == '*' &&
			menu->textSelPtr[i+1] == '(')
		{ //skip over color codes
			while (menu->textSelPtr[i] && menu->textSelPtr[i] != ')')
			{
				i++;
			}
			if (menu->textSelPtr[i] != ')')
			{
				break;
			}
			i++;
			if (!menu->textSelPtr[i] || menu->textSelPtr[i] == '\n' || menu->textSelPtr[i] == '\r')
			{
				break;
			}
		}
		buf[j] = menu->textSelPtr[i];
		j++;
	}
	buf[j] = 0;
	return buf;
}

//set text selector
void LCl_SetTextSelector(menu_t *menu, int line)
{
	int i;
	int l = 0;
	menu->textSelLineCount = line;
	for (i = 0; menu->text[i]; i++)
	{
		if (l == menu->textSelLineCount)
		{
			break;
		}
		if (menu->text[i] == '\n' && menu->text[i+1] != '\n')
		{
			l++;
		}
	}
	if (menu->text[i])
	{
		menu->textSelPtr = &menu->text[i];
	}
}

//get ability
const playerAbility_t *LCl_GetForgeAbility(void)
{
	if (g_forgeMode != 0)
	{
		return NULL;
	}
	menu_t *menu = g_sharedFn->Menu_GetActiveMenu("forgecontent");
	if (!menu)
	{
		return NULL;
	}
	int i = menu->textSelLineCount;
	if (i < 0 || i >= NUM_PLAYER_ABILITIES)
	{
		return NULL;
	}
	return &g_plAbilities[i];
}

//get item
const invItemDef_t *LCl_GetForgeItem(bool &canSee, int &amount)
{
	amount = 0;
	canSee = false;
	if (g_forgeMode != 2)
	{
		return NULL;
	}
	menu_t *menu = g_sharedFn->Menu_GetActiveMenu("forgecontent");
	if (!menu)
	{
		return NULL;
	}

	int validItems = 0;
	int lineIndex = menu->textSelLineCount;
	for (int i = 0; i < NUM_INVENTORY_ITEM_DEFS; i++)
	{
		const invItemDef_t *item = &g_invItems[i];
		if (item->cost <= 0)
		{ //not for sale
			continue;
		}
		if (validItems == lineIndex)
		{
			amount = Shared_HasItem(g_clientState.localPl, i);
			if (item->secret && !amount)
			{
				canSee = false;
			}
			else
			{
				canSee = true;
			}
			return item;
		}
		validItems++;
	}

	return NULL;
}

//set noabilities box
void LCl_SetNoAbilBox(const char *str)
{
	menu_t *menu = g_sharedFn->Menu_GetMenu("noabilbox");
	if (!menu)
	{
		return;
	}
	if (menu->text)
	{
		g_sharedFn->Common_RCFree(menu->text);
	}
	menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(str)+1);
	strcpy(menu->text, str);
}

//set desc
void LCl_SetForgeDesc(menu_t *menu, const char *str)
{
	if (menu->text)
	{
		g_sharedFn->Common_RCFree(menu->text);
	}
	menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(str)+1);
	strcpy(menu->text, str);
}

//used content menu
void LCl_MenuForgeContentUsed(void)
{
	if (g_forgeMode == 0)
	{ //abilities
		const playerAbility_t *ab = LCl_GetForgeAbility();
		if (ab)
		{
			int abIndex = (int)(ab-g_plAbilities);
			if (g_clientState.localPl->abilities & (1<<abIndex))
			{
				LCl_MenuErrorSound();
				LCl_SetNoAbilBox("*(1.0 1.0 1.0 1.0)You already have this ability.");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
			else if (ab->needsOther && (g_clientState.localPl->abilities & ab->needsOther) != ab->needsOther)
			{
				LCl_MenuErrorSound();
				LCl_SetNoAbilBox("*(1.0 0.5 0.0 1.0)You do not yet have access to this ability.");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
			else if (ab->cost > g_clientState.makoStash)
			{
				LCl_MenuErrorSound();
				LCl_SetNoAbilBox("*(1.0 0.5 0.0 1.0)You do not have enough mako\nto obtain this ability.");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
			else
			{
				Shared_ForgeAbility(g_clientState.localPl, abIndex, g_clientState.makoStash);
				menu_t *menu = g_sharedFn->Menu_GetMenu("forgecontent");
				if (menu)
				{
					LCl_MenuFillForgeContent(menu);
					LCl_SetTextSelector(menu, menu->textSelLineCount);
				}
				g_sharedFn->Net_SendSvEventType(SVEV_FORGEABILITY, &abIndex, sizeof(abIndex));
				LCl_SetNoAbilBox("*(1.0 1.0 1.0 1.0)Ability forged!");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
		}
	}
	else if (g_forgeMode == 1)
	{ //stats
		menu_t *cntMenu = g_sharedFn->Menu_GetActiveMenu("forgecontent");
		if (cntMenu)
		{
			int lineIndex = cntMenu->textSelLineCount;
			if (lineIndex >= 0 && lineIndex < 5)
			{
				int stats[5] = {g_clientState.localPl->maxHealth, g_clientState.localPl->statStr,
					g_clientState.localPl->statDef, g_clientState.localPl->statDex, g_clientState.localPl->statLuck};
				statInfo_t *stat = &g_statInfo[lineIndex];
				int statCost = Shared_StatCost(stats, lineIndex);
				if (stats[lineIndex] >= stat->maxVal)
				{
					LCl_MenuErrorSound();
					LCl_SetNoAbilBox("*(1.0 1.0 1.0 1.0)This stat is maxed out.");
					g_sharedFn->Menu_StopScript("noabilities");
					g_sharedFn->Menu_StartScript("noabilities");
				}
				else if (statCost > g_clientState.makoStash)
				{
					LCl_MenuErrorSound();
					LCl_SetNoAbilBox("*(1.0 0.5 0.0 1.0)You do not have enough mako\nto increase this stat.");
					g_sharedFn->Menu_StopScript("noabilities");
					g_sharedFn->Menu_StartScript("noabilities");
				}
				else
				{
					Shared_ForgeStat(g_clientState.localPl, lineIndex, g_clientState.makoStash);
					menu_t *menu = g_sharedFn->Menu_GetMenu("forgecontent");
					if (menu)
					{
						LCl_MenuFillForgeContent(menu);
						LCl_SetTextSelector(menu, menu->textSelLineCount);
					}
					g_sharedFn->Net_SendSvEventType(SVEV_FORGESTAT, &lineIndex, sizeof(lineIndex));
					LCl_SetNoAbilBox("*(1.0 1.0 1.0 1.0)Stat increased!");
					g_sharedFn->Menu_StopScript("noabilities");
					g_sharedFn->Menu_StartScript("noabilities");
				}
			}
		}
	}
	else if (g_forgeMode == 2)
	{ //items
		bool canSee;
		int amount;
		const invItemDef_t *item = LCl_GetForgeItem(canSee, amount);
		if (item)
		{
			int itemIndex = (int)(item-g_invItems);
			if (amount >= item->maxAmount)
			{
				LCl_MenuErrorSound();
				LCl_SetNoAbilBox("*(1.0 0.5 0.0 1.0)You cannot carry any more\nof this item.");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
			else if (!Shared_CanHaveItem(g_clientState.localPl, itemIndex))
			{
				LCl_MenuErrorSound();
				LCl_SetNoAbilBox("*(1.0 0.5 0.0 1.0)You cannot carry this item.");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
			else if (item->cost > g_clientState.makoStash)
			{
				LCl_MenuErrorSound();
				LCl_SetNoAbilBox("*(1.0 0.5 0.0 1.0)You do not have enough mako\nto forge this item.");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
			else
			{
				int itemIndex = (int)(item-g_invItems);
				Shared_ForgeItem(g_clientState.localPl, itemIndex, g_clientState.makoStash);
				menu_t *menu = g_sharedFn->Menu_GetMenu("forgecontent");
				if (menu)
				{
					LCl_MenuFillForgeContent(menu);
					LCl_SetTextSelector(menu, menu->textSelLineCount);
				}
				g_sharedFn->Net_SendSvEventType(SVEV_FORGEITEM, &itemIndex, sizeof(itemIndex));
				LCl_SetNoAbilBox("*(1.0 1.0 1.0 1.0)Item forged!");
				g_sharedFn->Menu_StopScript("noabilities");
				g_sharedFn->Menu_StartScript("noabilities");
			}
		}
	}
}

//update description box for forge
void LCl_UpdateForgeMenu(void)
{
	menu_t *menu = g_sharedFn->Menu_GetActiveMenu("forgedesc");
	if (menu && menu->draw)
	{
		if (g_forgeMode == 0)
		{ //abilities
			const playerAbility_t *ab = LCl_GetForgeAbility();
			char str[2048];
			str[0] = 0;
			if (ab)
			{
				if (ab->needsOther && (g_clientState.localPl->abilities & ab->needsOther) != ab->needsOther)
				{
					strcpy(str, "*(1 1 1 1)You do not yet have access to this ability.");
				}
				else
				{
					sprintf(str, "%s\n*(1 1 1 1)%s", ab->name, ab->desc);
				}
			}
			LCl_SetForgeDesc(menu, str);
		}
		else if (g_forgeMode == 1)
		{ //stats
			char str[2048];
			str[0] = 0;
			menu_t *cntMenu = g_sharedFn->Menu_GetActiveMenu("forgecontent");
			if (cntMenu)
			{
				int lineIndex = cntMenu->textSelLineCount;
				if (lineIndex >= 0 && lineIndex < 5)
				{
					int stats[5] = {g_clientState.localPl->maxHealth, g_clientState.localPl->statStr,
						g_clientState.localPl->statDef, g_clientState.localPl->statDex, g_clientState.localPl->statLuck};
					sprintf(str, "%s*(1 1 1 1) - *(-1 -1 -1 1)%i*(1 1 1 1)\n*(1 1 1 1)%s\nIncrements by %i with each forging.",
						g_statInfo[lineIndex].name, stats[lineIndex],
						g_statInfo[lineIndex].desc, g_statInfo[lineIndex].incr);
				}
			}
			LCl_SetForgeDesc(menu, str);
		}
		else if (g_forgeMode == 2)
		{ //items
			bool canSee;
			int amount;
			const invItemDef_t *item = LCl_GetForgeItem(canSee, amount);
			char str[2048];
			str[0] = 0;
			if (item)
			{
				if (!canSee)
				{
					strcpy(str, "*(1 1 1 1)In order to reveal this item, it must be forged.");
				}
				else
				{
					sprintf(str, "*$%s$%s *(1 1 1 1)-*(-1 -1 -1 1) %02i*(1 1 1 1)/*(-1 -1 -1 1)%02i\n*(1 1 1 1)%s", item->icon, item->name,
						amount, item->maxAmount, item->desc);
				}
			}
			LCl_SetForgeDesc(menu, str);
		}
	}
}

//fill forge content
void LCl_MenuFillForgeContent(menu_t *menu)
{
	if (g_forgeMode == 0)
	{ //abilities
		if (menu->text)
		{
			g_sharedFn->Common_RCFree(menu->text);
		}
		char menuStr[MAX_LIST_LEN];
		menuStr[0] = 0;
		for (int i = 0; i < NUM_PLAYER_ABILITIES; i++)
		{
			char str[256];
			const playerAbility_t *ab = &g_plAbilities[i];
			if (g_clientState.localPl->abilities & (1<<i))
			{
				sprintf(str, "*(1 1 1 1)%s", ab->name);
			}
			else if (ab->needsOther && (g_clientState.localPl->abilities & ab->needsOther) != ab->needsOther)
			{
				strcpy(str, "*(0.25 0.25 0.25 1)???");
			}
			else
			{
				sprintf(str, "*(-1 -1 -1 1)%s", ab->name);
			}

			strcat(menuStr, str);
			strcat(menuStr, "*!250 185!");
			if (g_clientState.localPl->abilities & (1<<i))
			{
				strcpy(str, "*(-1 -1 -1 1)Forged\n");
			}
			else
			{
				if (ab->cost == 0)
				{
					sprintf(str, "*(1 1 1 1)Free\n");
				}
				else
				{
					sprintf(str, "*(1 1 1 1)%i\n", ab->cost);
				}
			}
			strcat(menuStr, str);
		}
		menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(menuStr)+1);
		strcpy(menu->text, menuStr);
	}
	else if (g_forgeMode == 1)
	{ //stats
		if (menu->text)
		{
			g_sharedFn->Common_RCFree(menu->text);
		}
		char menuStr[MAX_LIST_LEN];
		int stats[5] = {g_clientState.localPl->maxHealth, g_clientState.localPl->statStr,
			g_clientState.localPl->statDef, g_clientState.localPl->statDex, g_clientState.localPl->statLuck};
		menuStr[0] = 0;

		char str[512];
		for (int i = 0; i < 5; i++)
		{
			if (stats[i] < g_statInfo[i].maxVal)
			{
				sprintf(str, "*(-1 -1 -1 1)%s", g_statInfo[i].name);
			}
			else
			{
				sprintf(str, "*(0.5 0.5 0.5 1)%s", g_statInfo[i].name);
			}
			strcat(menuStr, str);
			strcat(menuStr, "*!250 185!");
			int statCost = Shared_StatCost(stats, i);
			sprintf(str, "*(1 1 1 1)%i\n", statCost);
			strcat(menuStr, str);
		}

		menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(menuStr)+1);
		strcpy(menu->text, menuStr);
	}
	else if (g_forgeMode == 2)
	{ //items
		if (menu->text)
		{
			g_sharedFn->Common_RCFree(menu->text);
		}
		char menuStr[MAX_LIST_LEN];
		menuStr[0] = 0;
		for (int i = 0; i < NUM_INVENTORY_ITEM_DEFS; i++)
		{
			const invItemDef_t *item = &g_invItems[i];
			if (item->cost <= 0)
			{ //not for sale
				continue;
			}
			char str[256];
			if (item->secret && !Shared_HasItem(g_clientState.localPl, i))
			{ //mystery
				strcpy(str, "*(-1 -1 -1 1)???");
			}
			else if (!Shared_CanHaveItem(g_clientState.localPl, i))
			{
				sprintf(str, "*$%s$*(0.5 0.5 0.5 1)%s", item->icon, item->name);
			}
			else
			{
				sprintf(str, "*$%s$*(-1 -1 -1 1)%s", item->icon, item->name);
			}

			strcat(menuStr, str);
			strcat(menuStr, "*!250 185!");
			sprintf(str, "*(1 1 1 1)%i\n", item->cost);
			strcat(menuStr, str);
		}
		menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(menuStr)+1);
		strcpy(menu->text, menuStr);
	}
}

//fill equip list
static void LCl_FillEquipList(void)
{
	char invStr[MAX_LIST_LEN];
	invStr[0] = 0;
	int validItemCount = 0;
	int selectedItem = -1;
	for (int i = 0; i < MAX_PLAYER_INVENTORY_ITEMS; i++)
	{
		playerInvItem_t *plItem = &g_clientState.localPl->inventory[i];
		if (plItem->itemQuantity > 0)
		{
			if (g_clientState.desiredItem == i)
			{
				selectedItem = validItemCount;
			}
			validItemCount++;
			const invItemDef_t *item = &g_invItems[plItem->itemIndex];
			char itemStr[512];
			if (i == 0)
			{
				sprintf(itemStr, "*$%s$*(1 1 1 1)%s\n", item->icon, item->name);
			}
			else
			{
				sprintf(itemStr, "*$%s$*(1 1 1 1)%s*!300 158!*(-1 -1 -1 1)%02i\n", item->icon, item->name, plItem->itemQuantity);
			}
			strcat_s(invStr, MAX_LIST_LEN, itemStr);
		}
	}
	menu_t *invMenu = g_sharedFn->Menu_GetMenu("equiplist");
	if (invMenu)
	{
		if (invMenu->text)
		{
			g_sharedFn->Common_RCFree(invMenu->text);
		}
		invMenu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(invStr)+1);
		strcpy(invMenu->text, invStr);
		invMenu->textSelLineCount = 0;
		invMenu->textSelPtr = NULL;
		if (selectedItem != -1)
		{
			LCl_SetTextSelector(invMenu, selectedItem);
		}
	}
}

//custom menu handler
void LCl_UserMenu(const char *callName, mscriptNode_t *node, menuScript_t *mscript)
{
	char *saveNames[3] =
	{
		"assets/saves/save01.rcs",
		"assets/saves/save02.rcs",
		"assets/saves/save03.rcs"
	};
	static int saveSlot = -1;

	if (!stricmp(callName, "statmenu"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("ingametext");
		if (!menu)
		{
			return;
		}
		if (menu->text)
		{
			g_sharedFn->Common_RCFree(menu->text);
		}
		char *menuStr;
		if (!g_clientState.localPl->abilities)
		{
			menuStr = "*(1 1 1 1)Equip item\n*(0.5 0.5 0.5 1)Abilities*(1 1 1 1)\n\n\nQuit\n";
		}
		else
		{
			menuStr = "*(1 1 1 1)Equip item\nAbilities\n\n\nQuit\n";
		}
		menu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(menuStr)+1);
		strcpy(menu->text, menuStr);

		LCl_UpdateStatMenu();
	}
	else if (!stricmp(callName, "ingamemenuselected"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("ingametext");
		if (!menu)
		{
			return;
		}
		char *sel = LCl_MenuGetStringSel(menu);
		if (sel)
		{
			if (!stricmp(sel, "Equip item"))
			{ //bring up the item list
				menu->selectable = false;
				menuPointer_t *mptr = g_sharedFn->Menu_GetMenuPointer();
				if (mptr->selected == menu)
				{ //deselect if this menu was selected
					mptr->selected = NULL;
				}
				LCl_FillEquipList();
				g_sharedFn->Menu_StartScript("moveequiplist");
				g_sharedFn->Menu_StartScript("movedescbox");
			}
			else if (!stricmp(sel, "Abilities"))
			{
				if (!g_clientState.localPl->abilities)
				{
					LCl_MenuErrorSound();
					LCl_SetNoAbilBox("*(1.0 0.5 0.0 1.0)You have not acquired any abilities.");
					g_sharedFn->Menu_StopScript("noabilities");
					g_sharedFn->Menu_StartScript("noabilities");
				}
				else
				{
					menu->selectable = false;
					menuPointer_t *mptr = g_sharedFn->Menu_GetMenuPointer();
					if (mptr->selected == menu)
					{ //deselect if this menu was selected
						mptr->selected = NULL;
					}

					char abilStr[MAX_LIST_LEN];
					abilStr[0] = 0;
					for (int i = 0; i < NUM_PLAYER_ABILITIES; i++)
					{
						if (g_clientState.localPl->abilities & (1<<i))
						{
							const playerAbility_t *abil = &g_plAbilities[i];

							char str[2048];
							sprintf(str, "%s\n", abil->name);
							strcat_s(abilStr, MAX_LIST_LEN, str);
						}
					}

					menu_t *abilMenu = g_sharedFn->Menu_GetMenu("abilitylist");
					if (abilMenu)
					{
						if (abilMenu->text)
						{
							g_sharedFn->Common_RCFree(abilMenu->text);
						}
						abilMenu->text = (char *)g_sharedFn->Common_RCMalloc((int)strlen(abilStr)+1);
						strcpy(abilMenu->text, abilStr);
						abilMenu->textSelLineCount = 0;
						abilMenu->textSelPtr = NULL;
					}
					g_sharedFn->Menu_StartScript("moveabilitylist");
					g_sharedFn->Menu_StartScript("movedescbox");
				}
			}
			else if (!stricmp(sel, "Quit"))
			{
				g_sharedFn->Menu_StartScript("quitconfirm");
			}
		}
	}
	else if (!stricmp(callName, "forgemenuselected"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("forgetext");
		if (!menu)
		{
			return;
		}
		char *sel = LCl_MenuGetStringSel(menu);
		if (sel)
		{
			if (!stricmp(sel, "Forge"))
			{
				menu = g_sharedFn->Menu_GetMenu("forgesel");
				if (menu)
				{
					LCl_SetTextSelector(menu, 0);
					g_sharedFn->Menu_StartScript("doforge");
				}
			}
			else if (!stricmp(sel, "Save"))
			{
				g_sharedFn->Menu_StartScript("savegamescript");
			}
		}
	}
	else if (!stricmp(callName, "ingamemenuquit"))
	{
		LCl_MenuInGameQuit();
	}
	else if (!stricmp(callName, "forgemenuquit"))
	{
		LCl_MenuForgeQuit();
	}
	else if (!stricmp(callName, "setmenusel_item"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("ingametext");
		if (menu)
		{
			LCl_SetTextSelector(menu, 0);
		}
	}
	else if (!stricmp(callName, "setmenusel_ability"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("ingametext");
		if (menu)
		{
			LCl_SetTextSelector(menu, 1);
		}
	}
	else if (!stricmp(callName, "setmenusel_quit"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("ingametext");
		if (menu)
		{
			LCl_SetTextSelector(menu, 3);
		}
	}
	else if (!stricmp(callName, "equiplistused"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("equiplist");
		if (menu)
		{
			int validItemCount = 0;
			int selIndex = -1;
			for (int i = 0; i < MAX_PLAYER_INVENTORY_ITEMS; i++)
			{
				playerInvItem_t *plItem = &g_clientState.localPl->inventory[i];
				if (validItemCount == menu->textSelLineCount && plItem->itemQuantity > 0)
				{
					selIndex = i;
					break;
				}
				if (plItem->itemQuantity > 0)
				{
					validItemCount++;
				}
			}
			if (selIndex != -1)
			{
				g_clientState.desiredItem = selIndex;
			}
			if (menu->onEscape && menu->onEscape[0])
			{
				g_sharedFn->Menu_StartScript(menu->onEscape);
			}
		}
	}
	else if (!strncmp(callName, "savecheck_", strlen("savecheck_")))
	{
		saveSlot = atoi(callName+strlen("savecheck_"));
		if (saveSlot >= 0 && saveSlot < 3)
		{
			int fh = g_sharedFn->FileSys_OpenFile(saveNames[saveSlot], _O_RDONLY|_O_BINARY, _S_IREAD);
			if (fh == -1)
			{
				g_sharedFn->Menu_StartScript("dosave");
			}
			else
			{
				g_sharedFn->FileSys_CloseFile(fh);
				g_sharedFn->Menu_StartScript("saveoverwrite");
			}
		}
	}
	else if (!strncmp(callName, "loadcheck_", strlen("loadcheck_")))
	{
		int loadSlot = atoi(callName+strlen("loadcheck_"));
		if (loadSlot >= 0 && loadSlot < 3)
		{
			int fh = g_sharedFn->FileSys_OpenFile(saveNames[loadSlot], _O_RDONLY|_O_BINARY, _S_IREAD);
			if (fh != -1)
			{
				g_sharedFn->FileSys_CloseFile(fh);
				for (int i = 0; i < 3; i++)
				{
					char str[128];
					sprintf(str, "save%iselect", i+1);
					menu_t *menu = g_sharedFn->Menu_GetMenu(str);
					if (menu)
					{
						menu->selectable = false;
					}
				}
				g_sharedFn->Cl_LocalLoadGame(saveNames[loadSlot]);
			}
		}
	}
	else if (!strncmp(callName, "saveslot", strlen("saveslot")))
	{
		if (saveSlot >= 0 && saveSlot < 3)
		{
			g_sharedFn->Cl_LocalSaveGame(saveNames[saveSlot]);
		}
	}
	else if (!stricmp(callName, "checkoverwrite"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("overwriteyesno");
		if (!menu)
		{
			return;
		}
		char *sel = LCl_MenuGetStringSel(menu);
		if (sel)
		{
			if (!stricmp(sel, "Yes"))
			{
				g_sharedFn->Menu_StartScript("dosave");
			}
			g_sharedFn->Menu_StartScript("nooverwrite");
		}
	}
	else if (!stricmp(callName, "forgeselused"))
	{
		menu_t *menu = g_sharedFn->Menu_GetMenu("forgesel");
		if (!menu)
		{
			return;
		}
		char *sel = LCl_MenuGetStringSel(menu);
		if (sel)
		{
			if (!stricmp(sel, "Abilities"))
			{
				g_forgeMode = 0;
			}
			else if (!stricmp(sel, "Stats"))
			{
				g_forgeMode = 1;
			}
			else if (!stricmp(sel, "Items"))
			{
				g_forgeMode = 2;
			}
			if (g_forgeMode >= 0)
			{
				menu = g_sharedFn->Menu_GetMenu("forgecontent");
				if (menu)
				{
					LCl_MenuFillForgeContent(menu);
					g_sharedFn->Menu_StartScript("forgecntenter");
					LCl_SetTextSelector(menu, 0);
				}
			}
		}
	}
	else if (!stricmp(callName, "forgecntused"))
	{
		LCl_MenuForgeContentUsed();
	}
}

//custom menu sort
bool LCl_UserSort(const char *sortName, menu_t *menu)
{
	if (!stricmp(sortName, "invsort"))
	{
		if (menu->sortLine <= 0 || menu->textSelLineCount <= 0 ||
			menu->sortLine >= MAX_PLAYER_INVENTORY_ITEMS || menu->textSelLineCount >= MAX_PLAYER_INVENTORY_ITEMS)
		{
			return false;
		}

		int dstItem = LCl_ValidItemIndex(menu->textSelLineCount);
		int srcItem = LCl_ValidItemIndex(menu->sortLine);
		if (dstItem >= 0 && srcItem >= 0)
		{
			playerInvItem_t itemDst = g_clientState.localPl->inventory[dstItem];
			g_clientState.localPl->inventory[dstItem] = g_clientState.localPl->inventory[srcItem];
			g_clientState.localPl->inventory[srcItem] = itemDst;
			int sortInfo[2];
			sortInfo[0] = srcItem;
			sortInfo[1] = dstItem;
			g_sharedFn->Net_SendSvEventType(SVEV_INVSORT, sortInfo, sizeof(sortInfo));

			if (g_clientState.desiredItem == srcItem)
			{
				g_clientState.desiredItem = dstItem;
			}
			else if (g_clientState.desiredItem == dstItem)
			{
				g_clientState.desiredItem = srcItem;
			}
		}

		menu_t *invMenu = g_sharedFn->Menu_GetMenu("equiplist");
		assert(invMenu);
		int sel = invMenu->textSelLineCount;
		LCl_FillEquipList();
		LCl_SetTextSelector(invMenu, sel);

		return true;
	}
	return false;
}
