#ifndef _MAIN_H
#define _MAIN_H

#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>
#include <assert.h>
#include <malloc.h>
#include "sharedtypes.h"
#include "sharedfn.h"

#define TIMETYPE_NORMAL		0
#define TIMETYPE_TIMEATTACK	1
#define TIMETYPE_DEATH		2
#define TIMETYPE_ACTION		3
#define TIMETYPE_TONBERRY	4

typedef struct rscript_s rscript_t;

extern float g_timeScale;
extern float g_invTimeScale;
extern int g_timeType;
extern serverTime_t g_actionTime;
extern float g_actionTimeScale;
extern serverTime_t g_tonberryTime;
extern int g_enSpawnBlock;
extern bool g_noDeath;
extern int g_cinema;

extern sharedSVFunctions_t *g_sharedFn;
extern serverTime_t g_curTime;
extern bool g_runningMultiplayer;

extern globalNetData_t g_globalNet;

#define NUM_SOUNDS_FOOTSTEPS 4
extern int g_soundFootsteps[NUM_SOUNDS_FOOTSTEPS];

#define NUM_SOUNDS_HITLIGHT 4
extern int g_soundHitLight[NUM_SOUNDS_HITLIGHT];
#define NUM_SOUNDS_HITHEAVY 3
extern int g_soundHitHeavy[NUM_SOUNDS_HITHEAVY];

#define NUM_SOUNDS_KICK 3
extern int g_soundKick[NUM_SOUNDS_KICK];

#define NUM_SOUNDS_PUNCH 3
extern int g_soundPunch[NUM_SOUNDS_PUNCH];

#define NUM_SOUNDS_DEEPBLOW 3
extern int g_soundDeepBlow[NUM_SOUNDS_DEEPBLOW];

extern float g_fetusPilotZ;
#define DEFAULT_CAM_Z 2560.0f
#define DEFAULT_PLR_Z 512.0f
extern float g_levelScroll[3];

extern bool g_fetusSideMode;
extern float g_fetusSideModeX;

extern viewFrustum_t g_camFrustum;
extern viewFrustum_t g_wideCamFrustum;
extern bool g_camFrustumFresh;
extern char g_camBoneBolt[64];
extern float g_camBoltOffset[3];
extern float g_camAbsOffset[3];
extern float g_camAbsAngOffset[3];
extern float g_camSlack;

extern bool g_musical;
extern int g_musicStrIndex;
extern float g_musicalAmp;
extern float g_musicalRunningAvg;
extern float g_musicalLastFrame;
extern int g_musicalRunningCount;

extern char g_levelMusic[256];
extern serverTime_t g_battleTime;
extern bool g_battleMusicEnabled;

typedef struct endlBattleInfo_s
{
	int			active;
	int			numKills;
} endlBattleInfo_t;

extern int g_magicMode;
extern endlBattleInfo_t g_endlessBattle;
extern int g_mpVersusMode;
extern int g_mpCountDown;
extern serverTime_t g_mpCountTime;

extern serverTime_t g_noConfineTime;

#define DEFAULT_GRAVITY		80

#define MAX_GAME_OBJECTS	8192//1024

//for convenience
#define Math_CalcPlaneEq						g_sharedFn->Math_CalcPlaneEq
#define Math_VecNorm2							g_sharedFn->Math_VecNorm2
#define Math_VecNorm							g_sharedFn->Math_VecNorm
#define Math_PlaneNorm							g_sharedFn->Math_PlaneNorm
#define Math_VecLen								g_sharedFn->Math_VecLen
#define Math_PlaneDist							g_sharedFn->Math_PlaneDist
#define Math_ProjectOntoPlane					g_sharedFn->Math_ProjectOntoPlane
#define Math_VecCopy							g_sharedFn->Math_VecCopy
#define Math_VecSub								g_sharedFn->Math_VecSub
#define Math_VecAdd								g_sharedFn->Math_VecAdd
#define Math_VecScale							g_sharedFn->Math_VecScale
#define Math_Max2								g_sharedFn->Math_Max2
#define Math_Max3								g_sharedFn->Math_Max3
#define Math_TransformPointByMatrix				g_sharedFn->Math_TransformPointByMatrix
#define Math_TransformPointByMatrix3x3			g_sharedFn->Math_TransformPointByMatrix3x3
#define Math_TransformPoint						g_sharedFn->Math_TransformPoint
#define Math_VecMA								g_sharedFn->Math_VecMA
#define Math_VecToAngles						g_sharedFn->Math_VecToAngles
#define Math_TransformPoint2					g_sharedFn->Math_TransformPoint2
#define Math_MatrixInverse						g_sharedFn->Math_MatrixInverse
#define Math_MatrixMultiply						g_sharedFn->Math_MatrixMultiply
#define Math_MatrixMultiply3x3					g_sharedFn->Math_MatrixMultiply3x3
#define Math_MatrixMultiply4x4					g_sharedFn->Math_MatrixMultiply4x4
#define Math_RotateMatrix						g_sharedFn->Math_RotateMatrix
#define Math_AnglesToMat						g_sharedFn->Math_AnglesToMat
#define Math_CrossProduct						g_sharedFn->Math_CrossProduct
#define Math_DotProduct							g_sharedFn->Math_DotProduct
#define Math_AngleMod							g_sharedFn->Math_AngleMod
#define Math_InterpolateVector					g_sharedFn->Math_InterpolateVector
#define Math_BlendAngle							g_sharedFn->Math_BlendAngle
#define Math_BlendAngleLinear					g_sharedFn->Math_BlendAngleLinear
#define Math_AngleVectors						g_sharedFn->Math_AngleVectors
#define Math_AxisForNormal						g_sharedFn->Math_AxisForNormal
#define Math_CreateMatrixFromOrientation		g_sharedFn->Math_CreateMatrixFromOrientation
#define Math_RotationMatrix						g_sharedFn->Math_RotationMatrix
#define Math_BoxesOverlap						g_sharedFn->Math_BoxesOverlap
#define Math_ExpandBounds						g_sharedFn->Math_ExpandBounds
#define Math_CreateFrustum						g_sharedFn->Math_CreateFrustum
#define Math_CreateFrustumForViewAxis			g_sharedFn->Math_CreateFrustumForViewAxis
#define Math_GetFrustumPoints					g_sharedFn->Math_GetFrustumPoints
#define Math_BoundsFromPoints					g_sharedFn->Math_BoundsFromPoints
#define Math_PointRelativeToPlane				g_sharedFn->Math_PointRelativeToPlane
#define Math_GetBoundsPoints					g_sharedFn->Math_GetBoundsPoints
#define Math_PointInFrustum						g_sharedFn->Math_PointInFrustum
#define Math_BoxInFrustum						g_sharedFn->Math_BoxInFrustum
#define Math_MatToAngles						g_sharedFn->Math_MatToAngles
#define Math_MatToAngles2						g_sharedFn->Math_MatToAngles2

#define Common_GetEntryForObject				g_sharedFn->Common_GetEntryForObject
#define Common_GetValForKey						g_sharedFn->Common_GetValForKey
#define Common_SetValForKey						g_sharedFn->Common_SetValForKey

#define Array_Alloc								g_sharedFn->Array_Alloc
#define Array_Free								g_sharedFn->Array_Free
#define Array_SetGrowth							g_sharedFn->Array_SetGrowth
#define Array_GetElement						g_sharedFn->Array_GetElement
#define Array_GetElementGrow					g_sharedFn->Array_GetElementGrow
#define Array_Append							g_sharedFn->Array_Append
#define Array_RemoveLast						g_sharedFn->Array_RemoveLast
#define Array_Insert							g_sharedFn->Array_Insert
#define Array_Remove							g_sharedFn->Array_Remove
#define Array_GetCount							g_sharedFn->Array_GetCount
#define Array_Tighten							g_sharedFn->Array_Tighten
#define Hash_GetKey								g_sharedFn->Hash_GetKey
#define Hash_Alloc								g_sharedFn->Hash_Alloc
#define Hash_Free								g_sharedFn->Hash_Free
#define Hash_AddIndexedKey						g_sharedFn->Hash_AddIndexedKey
#define Hash_RemoveIndexedKey					g_sharedFn->Hash_RemoveIndexedKey
#define Hash_GetKeyList							g_sharedFn->Hash_GetKeyList
#define Stream_Alloc							g_sharedFn->Stream_Alloc
#define Stream_Free								g_sharedFn->Stream_Free
#define Stream_WriteBits						g_sharedFn->Stream_WriteBits
#define Stream_WriteBytes						g_sharedFn->Stream_WriteBytes
#define Stream_ReadBits							g_sharedFn->Stream_ReadBits
#define Stream_ReadBytes						g_sharedFn->Stream_ReadBytes
#define Stream_WriteBool						g_sharedFn->Stream_WriteBool
#define Stream_WriteInt							g_sharedFn->Stream_WriteInt
#define Stream_WriteFloat						g_sharedFn->Stream_WriteFloat
#define Stream_WriteString						g_sharedFn->Stream_WriteString
#define Stream_ReadBool							g_sharedFn->Stream_ReadBool
#define Stream_ReadInt							g_sharedFn->Stream_ReadInt
#define Stream_ReadFloat						g_sharedFn->Stream_ReadFloat
#define Stream_ReadString						g_sharedFn->Stream_ReadString
#define Stream_Buffer							g_sharedFn->Stream_Buffer
#define Stream_Size								g_sharedFn->Stream_Size
#define Stream_SetOffset						g_sharedFn->Stream_SetOffset
#define Stream_GetOffset						g_sharedFn->Stream_GetOffset
#define SHash_Alloc								g_sharedFn->SHash_Alloc
#define SHash_Free								g_sharedFn->SHash_Free
#define SHash_Index								g_sharedFn->SHash_Index
#define SHash_String							g_sharedFn->SHash_String
#define SHash_GetCount							g_sharedFn->SHash_GetCount

#define LFL_NONET	(1<<0)
#define LFL_ENEMY	(1<<1)

//extra vis blocker data
typedef struct gameVisBlocker_s
{
	float		plane[4];
	float		minsS1[3];
	float		maxsS1[3];
	float		minsS2[3];
	float		maxsS2[3];
} gameVisBlocker_t;

typedef struct clientInfo_s
{
	char		infoStr[MAX_CLIENT_INFO_SIZE];
} clientInfo_t;

typedef enum
{
	HUMANIM_IDLE,
	HUMANIM_WALK,
	HUMANIM_RUNSLOW,
	HUMANIM_RUN,
	HUMANIM_JUMP,
	HUMANIM_FALL,
	HUMANIM_LAND,
	HUMANIM_PAIN_HIGH1,
	HUMANIM_PAIN_HIGH2,
	HUMANIM_PAIN_LOW1,
	HUMANIM_PAIN_LOW2,
	HUMANIM_PAIN_AIR,
	HUMANIM_PAIN_POPUP,
	HUMANIM_GETUP_BACK,
	HUMANIM_GETUP_FRONT,
	HUMANIM_FLYBACK,
	HUMANIM_FLYBACK2,
	HUMANIM_HIT_FALLFORWARD,
	HUMANIM_FALL_LAND,
	HUMANIM_POPUP_LAND,
	HUMANIM_DEATH,
	NUM_HUMAN_ANIMS
} humanAnims_e;

typedef struct gameAnim_s
{
	int			startFrame;
	int			endFrame;
	float		duration;
	bool		looping;
} gameAnim_t;

//player combat chain
typedef struct playerChain_s
{
	int					anim;
	int					chainPunch;
	int					chainPunchBack;
	int					chainPunchFwd;
	int					chainKick;
	int					chainKickBack;
	int					chainKickFwd;
	int					chainFrames;
	int					chainSword;
	int					chainSwordBack;
	int					chainSwordFwd;
} playerChain_t;

typedef struct damageBone_s
{
	const char			*boneName;
	const char			*parentName;
	float				offset[3];
	float				radius;
} damageBone_t;

typedef struct dmgBoneLine_s
{
	float				parPos[3];
	float				pos[3];
} dmgBoneLine_t;

typedef enum
{
	DMGBONE_FIST_R,
	DMGBONE_FIST_L,
	DMGBONE_FOOT_R,
	DMGBONE_FOOT_L,
	DMGBONE_FIST_R_BIG,
	DMGBONE_SWORD,
	NUM_DAMAGE_BONES
} damageBone_e;

typedef struct bulletDesc_s
{
	int				dmg;
	char			*impactFxHurt;
	char			*impactSoundHurt;
	char			*impactFxUnhurt;
	char			*impactSoundUnhurt;
} bulletDesc_t;

typedef struct seqDmg_s
{
	int				dmgLastIndex;
	int				dmgLastCount;
	int				dmgLastSeq;
} seqDmg_t;

//player-only structure
#define MAX_BUTTON_BUFFER		32
typedef struct gameObject_s gameObject_t;
typedef struct playerObject_s
{
	BYTE				clButtons[MAX_BUTTONS];
	BYTE				clButtonsBackBuffer[MAX_BUTTON_BUFFER][MAX_BUTTONS];
	int					numButtonsBuffered;
	float				clAngles[3];
	WORD				clAnalog[5];
	bool				hasClAnalog;
	float				lastClAngles[3];
	bool				hasLastClAngles;
	bool				playerSpawnSeq;
	int					chainNum;
	int					nextChain;
	gameObject_t		*targetObj;
	serverTime_t		healthUpdateTime;
	serverTime_t		lungeTime;
	dmgBoneLine_t		lastDmg[NUM_DAMAGE_BONES];
	bool				hasLastDmg;
	bool				noClip;
	bool				invincible;
	bool				noTarget;
	int					makoCharges;
	int					makoStash;
	int					chargeMeter;
	float				chargeDrain;
	serverTime_t		chargeDrainTime;
	serverTime_t		chargeToMakoPower;
	serverTime_t		timeAttackTime;
	serverTime_t		fistOfFlames;
	serverTime_t		explosiveBlows;
	serverTime_t		healingAura;
	serverTime_t		healingTime;
	serverTime_t		magicHealTime;
	int					desiredItem;
	int					equippedItem;
	int					waitOnInput;
	float				moveSpeedScale;
	gameObject_t		*camTarget;
	float				camRange;
	serverTime_t		jumpUseTime;
	serverTime_t		canJumpUse;
	int					jumpUseObj;

	serverTime_t		hasteTime;

	gameObject_t		*gun;
	const invItemDef_t	*gunItem;
	serverTime_t		gunFireTime;
	float				gunFirePose;

	gameObject_t		*sword;
	const invItemDef_t	*swordItem;

	gameObject_t		*flashlight;
	const invItemDef_t	*flashlightItem;

	gameObject_t		*ride;

	gameObject_t		*aerith;

	serverTime_t		noItemTime;

	playerData_t		lastPlData[MAX_NET_CLIENTS];
	playerData_t		plData;
	globalNetData_t		lastGlobal;

	serverTime_t		camSeeTime;
	bool				camTeleWarn;

	bool				clCheater;

	seqDmg_t			plSeqDmg[8];
	int					numPlSeqDmg;
} playerObject_t;

typedef struct animFrameEvent_s
{
	int					frame;
	int					sound;
	int					fx;
	char				*script;
} animFrameEvent_t;
#define MAX_CIN_FRAME_EVENTS	64
typedef struct cinObject_s
{
	gameAnim_t			animStub;
	animFrameEvent_t	frameEvents[MAX_CIN_FRAME_EVENTS];
	int					numFrameEvents;
	bool				hideable;
} cinObject_t;

typedef struct scriptableAnim_s
{
	int					animNum;
	char				*animName;
} scriptableAnim_t;
#define DEF_SCRIPT_ANIM(a) {a, #a}

typedef struct aiObject_s aiObject_t;

typedef enum
{
	ATKTYPE_NORMAL,
	ATKTYPE_POPUP,
	ATKTYPE_POPUP2,
	ATKTYPE_POPUP3,
	ATKTYPE_INAIR,
	ATKTYPE_BULLET,
	ATKTYPE_KNOCKBACK,
	ATKTYPE_KNOCKBACK2,
	ATKTYPE_KNOCKBACK3,
	ATKTYPE_EXPLOSION,
	ATKTYPE_BURNING,
	ATKTYPE_SMACKDOWN
} atkType_e;

typedef struct swordObject_s
{
	int				swingSounds[8];
	int				numSwingSounds;
	int				hitSounds[8];
	int				numHitSounds;
	int				impactSounds[8];
	int				numImpactSounds;
	int				unholsterSounds[8];
	int				numUnholsterSounds;
	int				holsterSounds[8];
	int				numHolsterSounds;

	int				hitFX[8];
	int				numHitFX;
	int				impactFX[8];
	int				numImpactFX;
} swordObject_t;

//main game object structure
typedef struct gameObject_s
{
	//the inuse int and gameObjectNet_t object must always be
	//at the top. this is because the engine makes this
	//assumption when reading the net data from a game object.
	int					inuse;
	gameObjNet_t		net;
	rcColModel_t		*rcColModel;

	//you may modify below here freely
	serverTime_t		noReuseTime;
	void				(*customSpawn)(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
	void				(*postSpawn)(gameObject_t *obj);
	void				(*think)(gameObject_t *obj, float timeMod);
	void				(*touch)(gameObject_t *obj, gameObject_t *other, const collObj_t *col);
	void				(*pain)(gameObject_t *obj, gameObject_t *hurter, int dmg, const collObj_t *col);
	void				(*death)(gameObject_t *obj, gameObject_t *killer, int dmg);
	void				(*activate)(gameObject_t *obj, gameObject_t *activator);
	bool				(*attackblock)(gameObject_t *obj, gameObject_t *hurter, int dmg, collObj_t *col,
							float *impactPos, float *impactAng);
	void				(*animhandler)(gameObject_t *obj, float timeMod);
	void				(*animframetick)(gameObject_t *obj, float timeMod, int oldFrame);
	bool				(*animidleoverride)(gameObject_t *obj, float timeMod);
	void				(*onremove)(gameObject_t *obj);
	void				(*onhurt)(gameObject_t *obj, gameObject_t *victim, int dmg, const collObj_t *col);
	serverTime_t		thinkTime;

	playerObject_t		*plObj;
	aiObject_t			*aiObj;
	cinObject_t			*cinObj;
	rscript_t			*rscript;
	swordObject_t		*swordObj;
	void				*customDynamic;

	float				spawnMins[3];
	float				spawnMaxs[3];

	int					creationCount;

	int					hurtable;
	int					health;

	BYTE				*objData;

	gameVisBlocker_t	*visBlockData;

	gameAnim_t			*animTable;
	int					numAnims;
	scriptableAnim_t	*scriptAnims;
	int					curAnim;
	serverTime_t		animTime;
	serverTime_t		animStartTime;
	bool				animRestart;
	bool				animNeverInterrupt;

	seqDmg_t			seqDmg;
	int					atkLastSeq;
	serverTime_t		atkLastTime;
	int					atkType;
	float				atkRadiusCore;
	float				atkRadiusPos[3];
	int					meteorAttack;
	serverTime_t		isOnFire;
	serverTime_t		fireBurnTime;

	int					makoCount;

	float				localTimeScale;

	bool				alwaysSend;
	serverTime_t		noCullTime;
	serverTime_t		nonSolidTime;
	serverTime_t		preDeathTime;
	serverTime_t		postSpawnTime;
	serverTime_t		noGravTime;
	serverTime_t		knockTime;
	bool				toucher;

	float				radius;
	bool				canPush;
	bool				canBePushed;

	serverTime_t		debounce;
	serverTime_t		debounce2;
	serverTime_t		debounce3;
	serverTime_t		debounce4;
	serverTime_t		debounce5;
	serverTime_t		debounce6;
	serverTime_t		debounce7;
	serverTime_t		swordTime;
	int					generalFlag;
	int					generalFlag2;
	int					generalFlag3;

	int					dualAnimCnt;

	float				spareVec[3];

	serverTime_t		spawnLife;

	int					localFlags;

	//physics
	float				bounceFactor;
	bool				onGround;

	float				camTrackPos[3];

	bool				groundHugger;
	float				preImpactVel[3];

	float				projVelAng[3];
	float				projVelocity[3];
	float				projFriction[3];
	int					projDamage;

	float				safePos[3];

	int					localRecursionTick;

	char				*targetName;
	char				*str1;
	char				*str2;

	gameObject_t		*enemy;
	gameObject_t		*target;
	gameObject_t		*child;
	gameObject_t		*parent;
	gameObject_t		*chain;
	gameObject_t		*chain2;
	gameObject_t		*physicsOwner;

	const objArgs_t		*spawnArgs;
	int					numSpawnArgs;

	bool				localAngles;
} gameObject_t;

extern gameObject_t g_gameObjects[MAX_GAME_OBJECTS];
extern clientInfo_t g_clientInfo[MAX_NET_CLIENTS];
extern int g_gameObjectSlots;
extern int g_creationCount;

extern int g_musicHighScore;

//gvar.cpp
#define MAX_GVAR_LEN		128
void GVar_Init(void);
void GVar_Shutdown(void);
void GVar_ListGVars(void);
void GVar_WriteGVars(cntStream_t *st);
void GVar_ReadGVars(cntStream_t *st);
char *GVar_GetValue(char *varName);
void GVar_SetValue(char *varName, char *value);
int GVar_GetInt(char *varName);
void GVar_SetInt(char *varName, int value);
float GVar_GetFloat(char *varName);
void GVar_SetFloat(char *varName, float value);

//main.cpp
extern void LServ_ShowMPStats(void);
extern void LServ_ChangeMusic(char *music);
extern gameObject_t *LServ_CreateObject(void);
extern void LServ_FreeObject(gameObject_t *obj);
extern void LServ_CacheObj(const char *objName);
gameObject_t *LServ_ObjectFromName(const char *objName, float *pos, float *ang, const objArgs_t *args, int numArgs);
extern void LServ_UpdateRClip(gameObject_t *obj);
extern void LServ_MusicalScoreLog(gameObject_t *client);

//obj_aerith.cpp
extern void ObjAerith_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_barforge.cpp
extern void ObjBarForge_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_barrett.cpp
extern void ObjBarrett_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_beam.cpp
extern void ObjBeam_Resized(gameObject_t *obj);
extern void ObjBeam_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_bomb.cpp
extern void ObjBomb_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_camtrack.cpp
extern void ObjCamMarker_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern void ObjCam_Removal(gameObject_t *obj);
extern void ObjCam_Think(gameObject_t *obj, float timeMod);

//obj_ccon.cpp
extern void ObjCCon_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_choco.cpp
extern void ObjChocoSpot_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern void ObjChoco_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern bool ObjChoco_FeedChocos(gameObject_t *feeder, const invItemDef_t *greens);

//obj_cinemaprop.cpp
extern void ObjCinProp_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_cloud.cpp
extern void ObjCloud_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_general.cpp
extern void ObjGeneral_RemoveThink(gameObject_t *obj, float timeMod);
extern void ObjGeneral_Think(gameObject_t *obj, float timeMod);
extern void ObjGeneral_SpawnNoNet(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern void ObjGeneral_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_grandhorn.cpp
extern void ObjHorn_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_guarddog.cpp
extern void ObjDog_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_e30.cpp
extern void ObjE30_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_eater.cpp
extern void ObjEat_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_forcefield.cpp
extern void ObjForceField_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_gigas.cpp
extern void ObjGig_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_ironman.cpp
extern void ObjIron_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_itemdrop.cpp
extern void ObjItemDrop_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_jenova.cpp
extern void ObjJenova_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_lift.cpp
extern void ObjLift_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_light.cpp
extern void ObjLight_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_madouge.cpp
extern void ObjMad_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern void ObjMadBall_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_mako.cpp
extern void ObjMako_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_player.cpp
extern void ObjPlayer_WriteGameData(gameObject_t *obj, cntStream_t *st);
extern void ObjPlayer_ReadGameData(gameObject_t *obj, cntStream_t *st);
extern void LServ_InitPlayerObj(int clientNum, const char *clientInfo);
extern void ObjPlayer_UpdatePlayerStates(gameObject_t *obj);
extern int ObjPlayer_StrMod(gameObject_t *obj, int dmg);
extern int ObjPlayer_DefMod(gameObject_t *obj, int dmg, gameObject_t *attacker);
extern bool ObjPlayer_IsWeakSauce(gameObject_t *obj);
extern bool ObjPlayer_OkayToAttack(gameObject_t *enemy, gameObject_t *obj);
extern bool ObjPlayer_InSephAnim(gameObject_t *obj);
extern int ObjPlayer_GetSephAnim(int a);
extern int ObjPlayer_GetChocoAnim(int a);
extern bool ObjPlayer_InDodgeableAttack(gameObject_t *obj);
extern bool ObjPlayer_InVulnerableState(gameObject_t *obj);
extern bool ObjPlayer_IsUsingItem(gameObject_t *obj);
extern void ObjPlayer_AdjustTurnAngles(gameObject_t *obj, float timeMod, float *outAng);
extern void ObjPlayer_Touch(gameObject_t *obj, gameObject_t *other, const collObj_t *col);
extern void ObjPlayer_Death(gameObject_t *obj, gameObject_t *killer, int dmg);
extern void ObjPlayer_MountRide(gameObject_t *obj, gameObject_t *ride);
extern bool ObjPlayer_UnmountRide(gameObject_t *obj, bool force);
extern void ObjPlayer_GetMoveVec(gameObject_t *obj, gameObject_t *cam, float timeMod, float *moveVec,
						  float &move, float &rightMove, bool isFlying);
extern void ObjPlayer_TeleportToPlZero(gameObject_t *obj);
extern void ObjPlayer_Think(gameObject_t *obj, float timeMod);
extern void ObjPlayer_CameraConfine(gameObject_t *obj);
extern void ObjPlayer_HealthDisplay(gameObject_t *obj, gameObject_t *other);
extern const invItemDef_t *ObjPlayer_GetEquippedItem(gameObject_t *obj);
extern void ObjPlayer_GiveItem(gameObject_t *obj, int itemIndex);
extern void ObjPlayer_GiveMako(gameObject_t *obj, int makoAmount);
extern void ObjPlayer_ChargeUp(gameObject_t *obj, gameObject_t *other, int dmg);
extern void ObjPlayer_ChargeDown(gameObject_t *obj, gameObject_t *other, int dmg);
extern int ObjPlayer_TargetBit(gameObject_t *obj);

//obj_plbar.cpp
extern void ObjPlBar_Init(gameObject_t *pl);

//obj_plitems.cpp
extern void ObjVortex_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern int ObjSword_RegMedia(BYTE *b, char *prefix, int *medOut, bool isFX);
extern void ObjSword_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern void PlItem_CreateVortex(gameObject_t *pl, float *pos, int duration, float power);
extern void PlItem_DrainEnemies(gameObject_t *pl, float *pos, float radius, int drainAmount);
extern void PlItem_Quake(gameObject_t *pl, float *pos, float radius, int damage);
extern void PlItem_Confuse(gameObject_t *pl, float *pos, float radius, int duration);

//obj_partemit.cpp
extern void ObjPartEmit_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_particles.cpp
extern void ObjParticles_CreateFromIndex(int strIndex, const float *pos, const float *ang, int owner);
extern void ObjParticles_Create(const char *particles, const float *pos, const float *ang, int owner);

//obj_projectiles.cpp
extern void ObjProjectile_Init(void);
extern void ObjProjectile_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern gameObject_t *ObjProjectile_Create(gameObject_t *owner, const char *name, float *pos, float *dir);
extern void ObjProjectile_Think(gameObject_t *obj, float timeMod);

//obj_rscript.cpp
extern void ObjRSRunner_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_sephfin.cpp
extern void ObjSephFin_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
extern void ObjSephHair_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_sound.cpp
extern void ObjSound_CreateFromIndex(float *pos, int index, float volume, int attachIndex);
extern void ObjSound_Create(float *pos, const char *sound, float volume, int attachIndex);

//obj_soundemit.cpp
extern void ObjSoundEmit_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_supernova.cpp
extern void ObjSupernova_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_tonberry.cpp
extern void ObjTon_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_triggerbox.cpp
extern void ObjTriggerBox_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//obj_visblock.cpp
extern void ObjVisBlock_Update(float *pos);
extern bool ObjVisBlock_CheckVis(gameObject_t *obj);
extern void ObjVisBlock_DebugDraw(void);
extern void ObjVisBlock_EstablishVis(void);
extern void ObjVisBlock_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);

//physics.cpp
extern float Phys_InterpolateAngle(float old, float cur, float val, float tresh);
extern void Phys_TranslatePusher(gameObject_t *pusher, float *dest);
extern void Phys_ApplyObjectPhysics(gameObject_t *obj, float timeMod, float objRad, float gravFactor, float bounceFactor);
extern bool Phys_LinearMove(gameObject_t *obj, float *destPos, float moveSpeed);
extern void Phys_DirectVelocity(gameObject_t *obj, float timeMod, float xyFriction, float zFriction, float velMul);
extern void Phys_PutOnGround(gameObject_t *obj);

//util.cpp
extern bool Util_ParseObjSpawn(const char *str, gameObject_t *obj);
extern bool Util_ParseObjType(const char *str, int *out);
extern bool Util_ParseVector(const char *str, float *out);
extern bool Util_ParseInt(const char *str, int *out);
extern float Util_NudgeValue(float cur, float dst, float fact);
extern float Util_RadiusFromBounds(float *mins, float *maxs, float padMul);
extern int Util_RandInt(int low, int high);
extern float Util_RandFloat(float low, float high);
extern void Util_GameObjectCenter(gameObject_t *obj, float *v);
extern bool Util_GameObjectsOverlap(gameObject_t *obja, gameObject_t *objb);
extern void Util_TouchObjects(gameObject_t *obj1, gameObject_t *obj2, const collObj_t *col);
extern void Util_ProjectDecal(gameObject_t *obj, const float *start, const float *end, const char *decal, float decalSize, int decalLife, int decalFade);
extern bool Util_SequenceDamage(gameObject_t *obj, gameObject_t *other);
extern void Util_SetSequenceDamage(gameObject_t *obj, gameObject_t *other);
extern bool Util_ValidEnemies(gameObject_t *obj, gameObject_t *other);
extern bool Util_DamageObject(gameObject_t *damager, gameObject_t *victim, int damage, const collObj_t *col = NULL);
extern void Util_RadiusDamage(gameObject_t *damager, int damage, float radius, float *damageOrigin = NULL, bool friendlyFire = true);
extern void Util_DamageThroughHurter(gameObject_t *obj, int damage, int atkType);
extern void Util_GetSafeOffset(gameObject_t *obj, float *pos, float *outPos);
extern gameObject_t *Util_FireBullet(gameObject_t *obj, float *pos, float *dir, bulletDesc_t *bullet, bool friendlyFire = false);
extern void Util_AnimateObject(gameObject_t *obj, float timeMod);
extern bool Util_GetObjBolt(gameObject_t *obj, char *boneName, modelMatrix_t *matOut, float *ofs = NULL);
extern void Util_HarmlessKnockback(gameObject_t *knocker, gameObject_t *knockee);
extern void Util_SetSafeSpot(gameObject_t *obj);
extern gameObject_t *Util_FindTargetObject(const char *targetName);
extern bool Util_FindHiddenSpawn(gameObject_t *targ, float dist, BYTE *rco, float *outPos, float *outAng);
extern bool Util_TryObjectSpawn(float *pos, BYTE *rco, float *originPos = NULL);
extern bool Util_ScaledResize(gameObject_t *obj, float *baseMins, float *baseMaxs, float baseRadius, float desiredScale, float stepSize);
extern void Util_ClientShake(gameObject_t *cl, float shakeAmount, float shakeDec);
extern void Util_ProximityShake(float *pos, float radius, float shakeAmount, float shakeDec);
extern void Util_RunScript(char *objName, char *scriptName);
extern bool Util_CamProx2D(float *pos, const float d);
extern void Util_DebugBox(float *mins, float *maxs, float *color);
extern void Util_DebugFX(float *pos, float *dir);
extern void Util_DebugLine(float *start, float *end);
extern void Util_StatusMessage(const char *msg, ...);
extern void Util_StatusMessageToClient(int cl, const char *msg, ...);
extern void Util_ErrorMessage(const char *msg, ...);
extern serverTime_t Util_LocalDelay(gameObject_t *obj, serverTime_t del);
extern char *Util_PooledString(const char *str);

#endif //_MAIN_H
