/*
=============================================================================
Module Information
------------------
Name:			obj_barforge.cpp
Author:			Rich Whitehouse
Description:	server logic object: barrett forge
=============================================================================
*/

#include "main.h"
#include "ai.h"

typedef enum
{
	BARFANIM_CIN_IDLE_1 = NUM_HUMAN_ANIMS,
	BARFANIM_CIN_WORKIT,
	BARFANIM_CIN_GETANGRY,
	BARFANIM_CIN_VIBRATE,
	BARFANIM_CIN_GETUNANGRY,
	BARFANIM_CIN_HANDOUT,
	NUM_BARFORGE_ANIMS
} barForgeAnims_e;

static gameAnim_t g_barForgeAnims[NUM_BARFORGE_ANIMS] =
{
	{495, 496, 1568.0f, true},		//HUMANIM_IDLE
	{92, 97, 168.0f, true},			//HUMANIM_WALK
	{92, 97, 118.0f, true},			//HUMANIM_RUNSLOW
	{92, 97, 88.0f, true},			//HUMANIM_RUN
	{0, 2, 68.0f, false},			//HUMANIM_JUMP
	{0, 2, 68.0f, false},			//HUMANIM_FALL
	{0, 2, 68.0f, false},			//HUMANIM_LAND
	{79, 81, 168.0f, false},		//HUMANIM_PAIN_HIGH1
	{79, 81, 168.0f, false},		//HUMANIM_PAIN_HIGH2
	{79, 81, 168.0f, false},		//HUMANIM_PAIN_LOW1
	{79, 81, 168.0f, false},		//HUMANIM_PAIN_LOW2
	{79, 81, 168.0f, false},		//HUMANIM_PAIN_AIR
	{79, 81, 168.0f, false},		//HUMANIM_PAIN_POPUP
	{30, 32, 168.0f, false},		//HUMANIM_GETUP_BACK
	{30, 32, 168.0f, false},		//HUMANIM_GETUP_FRONT
	{196, 196, 68.0f, false},		//HUMANIM_FLYBACK
	{196, 196, 68.0f, false},		//HUMANIM_FLYBACK2
	{19, 22, 168.0f, false},		//HUMANIM_HIT_FALLFORWARD
	{19, 22, 68.0f, false},			//HUMANIM_FALL_LAND
	{19, 22, 68.0f, false},			//HUMANIM_POPUP_LAND
	{0, 19, 1568.0f, false},		//HUMANIM_DEATH
	{483, 484, 1068.0f, true},		//BARFANIM_CIN_IDLE_1 
	{490, 491, 468.0f, true},		//BARFANIM_CIN_WORKIT
	{485, 486, 218.0f, false},		//BARFANIM_CIN_GETANGRY 
	{486, 487, 48.0f, true},		//BARFANIM_CIN_VIBRATE 
	{487, 489, 318.0f, false},		//BARFANIM_CIN_GETUNANGRY 
	{492, 494, 318.0f, false}		//BARFANIM_CIN_HANDOUT
};

static scriptableAnim_t g_barForgeScriptAnims[] =
{
	DEF_SCRIPT_ANIM(HUMANIM_IDLE),
	DEF_SCRIPT_ANIM(BARFANIM_CIN_IDLE_1),
	DEF_SCRIPT_ANIM(BARFANIM_CIN_WORKIT),
	DEF_SCRIPT_ANIM(BARFANIM_CIN_GETANGRY),
	DEF_SCRIPT_ANIM(BARFANIM_CIN_VIBRATE),
	DEF_SCRIPT_ANIM(BARFANIM_CIN_GETUNANGRY),
	DEF_SCRIPT_ANIM(BARFANIM_CIN_HANDOUT),
	{0, NULL}
};

//think
void ObjBarForge_Think(gameObject_t *obj, float timeMod)
{
	if (!AI_ShouldThink(obj))
	{
		return;
	}

	if (obj->curAnim >= BARFANIM_CIN_IDLE_1)
	{
		Util_AnimateObject(obj, timeMod);
		return;
	}

	//Util_AnimateObject(obj, timeMod);
	AI_GenericThink(obj, timeMod);
}

//pick which anim to be in
void ObjBarForge_PickAnim(gameObject_t *obj, float timeMod)
{
	gameAnim_t *curAnim = obj->animTable+obj->curAnim;

	if (obj->curAnim >= BARFANIM_CIN_IDLE_1)
	{ //script will break out
		return;
	}
	else if (obj->net.frame == curAnim->endFrame && !obj->animRestart)
	{
		AI_StartAnim(obj, HUMANIM_IDLE, true);
	}
}

//frame tick
void ObjBarForge_FrameTick(gameObject_t *obj, float timeMod, int oldFrame)
{
	switch (obj->curAnim)
	{
	case HUMANIM_WALK:
	case HUMANIM_RUNSLOW:
	case HUMANIM_RUN:
		if ((obj->net.frame == 92 || obj->net.frame == 95) && obj->onGround)
		{
			int snd = g_soundFootsteps[rand()%NUM_SOUNDS_FOOTSTEPS];
			ObjSound_CreateFromIndex(obj->net.pos, snd, 1.0f, -1);
		}
		break;
	default:
		break;
	}
}

//spawn
void ObjBarForge_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	AI_GenericSpawn(obj, b, args, numArgs);
	obj->death = AI_ImmortalDeath;
	obj->localFlags &= ~LFL_ENEMY;
	obj->canBePushed = false;

	obj->net.aiDescIndex = AIDESC_BARRETT;
	obj->aiObj->maxHealth = obj->health;

	obj->aiObj->moveSpeed = 400.0f;
	obj->animhandler = ObjBarForge_PickAnim;
	obj->animframetick = ObjBarForge_FrameTick;
	obj->animTable = g_barForgeAnims;
	obj->scriptAnims = g_barForgeScriptAnims;
	obj->curAnim = HUMANIM_IDLE;
	obj->think = ObjBarForge_Think;
}
