/*
=============================================================================
Module Information
------------------
Name:			obj_beam.cpp
Author:			Rich Whitehouse
Description:	trigger box

Object Arguments
curveright:		Amount of curve on right axis.
crunchright:	Amount of crunch on right axis curve.
curveup:		Amount of curve on up axis.
crunchup:		Amount of crunch on up axis curve.
width:			Beam width.
length:			Beam length.
texture:		Beam texture.
repeat:			Texture repeat number.
color:			Blend color in the form of (r g b a).
jiggy:			Does some funky stuff.
=============================================================================
*/

#include "main.h"

//can be activated to toggle visibility
void ObjBeam_Activate(gameObject_t *obj, gameObject_t *activator)
{
	obj->net.renderEffects ^= FXFL_HIDDEN;
}

//think
void ObjBeam_Think(gameObject_t *obj, float timeMod)
{
	bool needResize = false;
	if (obj->generalFlag)
	{
		obj->net.modelScale[0] = sinf(g_curTime*0.001f)*600.0f;
		obj->net.modelScale[2] = 4.0f;
		obj->net.modelScale[1] = cosf(g_curTime*0.001f)*600.0f;
		obj->net.maxs[2] = 2.0f;
		needResize = true;
	}
	if (obj->target)
	{
		float d[3];
		Math_VecSub(obj->target->net.pos, obj->net.pos, d);
		obj->net.effectLen = Math_VecNorm(d);
		Math_VecToAngles(d, obj->net.ang);
		needResize = true;
	}

	if (needResize)
	{
		ObjBeam_Resized(obj);
	}
	obj->thinkTime = g_curTime;
}

//called when a beam is resized
void ObjBeam_Resized(gameObject_t *obj)
{
	float fwd[3], right[3], up[3];
	Math_AngleVectors(obj->net.ang, fwd, right, up);
	if (obj->net.modelScale[0] == 0.0f && obj->net.modelScale[1] == 0.0f)
	{ //no curve
		float p[2][3];
		p[0][0] = 0.0f;
		p[0][1] = 0.0f;
		p[0][2] = 0.0f;
		Math_VecMA(p[0], obj->net.effectLen, fwd, p[1]);
		Math_BoundsFromPoints(obj->spawnMins, obj->spawnMaxs, p[0], 2);
	}
	else
	{
		float curve[4];
		Math_VecCopy(obj->net.modelScale, curve);
		curve[3] = obj->net.maxs[2];

		float pt1[3], pt2[3];
		pt1[0] = 0.0f;
		pt1[1] = 0.0f;
		pt1[2] = 0.0f;
		Math_VecMA(pt1, obj->net.effectLen, fwd, pt2);
		float exPoints[8][3];
		Math_VecMA(pt1, curve[0], right, exPoints[0]);
		Math_VecMA(exPoints[0], curve[1], up, exPoints[0]);
		Math_VecMA(pt1, -curve[0], right, exPoints[1]);
		Math_VecMA(exPoints[1], -curve[1], up, exPoints[1]);
		Math_VecMA(pt1, -curve[0], right, exPoints[2]);
		Math_VecMA(exPoints[2], curve[1], up, exPoints[2]);
		Math_VecMA(pt1, curve[0], right, exPoints[3]);
		Math_VecMA(exPoints[3], -curve[1], up, exPoints[3]);
		Math_VecMA(pt2, curve[0], right, exPoints[4]);
		Math_VecMA(exPoints[4], curve[1], up, exPoints[4]);
		Math_VecMA(pt2, -curve[0], right, exPoints[5]);
		Math_VecMA(exPoints[5], -curve[1], up, exPoints[5]);
		Math_VecMA(pt2, -curve[0], right, exPoints[6]);
		Math_VecMA(exPoints[6], curve[1], up, exPoints[6]);
		Math_VecMA(pt2, curve[0], right, exPoints[7]);
		Math_VecMA(exPoints[7], -curve[1], up, exPoints[7]);
		Math_BoundsFromPoints(obj->spawnMins, obj->spawnMaxs, exPoints[0], 8);
	}
	obj->spawnMins[0] -= obj->net.maxs[1];
	obj->spawnMins[1] -= obj->net.maxs[1];
	obj->spawnMins[2] -= obj->net.maxs[1];
	obj->spawnMaxs[0] += obj->net.maxs[1];
	obj->spawnMaxs[1] += obj->net.maxs[1];
	obj->spawnMaxs[2] += obj->net.maxs[1];
}

//spawn
void ObjBeam_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->net.maxs[0] = 0.0f;
	obj->net.maxs[2] = 0.0f;
	obj->net.mins[0] = 0.0f;
	obj->net.mins[1] = 0.0f;
	obj->net.mins[2] = 0.0f;

	obj->net.maxs[1] = 32.0f;
	obj->net.effectLen = 512.0f;
	for (int i = 0; i < numArgs; i++)
	{
		const objArgs_t *arg = args+i;
		if (!stricmp(arg->key, "curveright"))
		{
			obj->net.modelScale[0] = (float)atof(arg->val);
		}
		else if (!stricmp(arg->key, "crunchright"))
		{
			obj->net.modelScale[2] = (float)atof(arg->val);
		}
		else if (!stricmp(arg->key, "curveup"))
		{
			obj->net.modelScale[1] = (float)atof(arg->val);
		}
		else if (!stricmp(arg->key, "crunchup"))
		{
			obj->net.maxs[2] = (float)atof(arg->val);
		}
		else if (!stricmp(arg->key, "width"))
		{
			obj->net.maxs[1] = (float)atof(arg->val);
		}
		else if (!stricmp(arg->key, "length"))
		{
			obj->net.effectLen = (float)atof(arg->val);
		}
		else if (!stricmp(arg->key, "texture"))
		{
			char str[1024];
			sprintf(str, "^%s", arg->val);
			obj->net.strIndex = g_sharedFn->Common_ServerString(str);
		}
		else if (!stricmp(arg->key, "repeat"))
		{
			obj->net.lerpDuration = atoi(arg->val);
		}
		else if (!stricmp(arg->key, "color"))
		{
			sscanf(arg->val, "(%f %f %f %f)", &obj->net.mins[0], &obj->net.mins[1],
				&obj->net.mins[2], &obj->net.maxs[0]);
		}
		else if (!stricmp(arg->key, "jiggy"))
		{
			obj->generalFlag = 1;
		}
	}
	obj->activate = ObjBeam_Activate;
	obj->think = ObjBeam_Think;
	obj->thinkTime = g_curTime;

	//set bounds around real extents of the beam
	ObjBeam_Resized(obj);
}
