/*
=============================================================================
Module Information
------------------
Name:			obj_ccon.cpp
Author:			Rich Whitehouse
Description:	server logic object: control console
=============================================================================
*/

#include "main.h"
#include "ai.h"

//think
void ObjCCon_Think(gameObject_t *obj, float timeMod)
{
	bool linkFail = false;
	if (!obj->target || !obj->target->inuse || (obj->target->net.renderEffects & FXFL_HIDDEN))
	{
		linkFail = true;
	}

	if (linkFail && !obj->generalFlag)
	{
		obj->net.strIndex = g_sharedFn->Common_ServerString("&assets/models/ccon2.rdm");
		obj->generalFlag = 1;
	}
	else if (!linkFail && obj->generalFlag)
	{
		obj->net.strIndex = g_sharedFn->Common_ServerString("&assets/models/ccon.rdm");
		obj->generalFlag = 0;
	}
	LServ_UpdateRClip(obj);
}

//pain
void ObjCCon_Pain(gameObject_t *obj, gameObject_t *hurter, int dmg, const collObj_t *col)
{
	ObjSound_Create(obj->net.pos, "assets/sound/cb/hitmetal.wav", 1.0f, -1);
	if (hurter->plObj)
	{
		const invItemDef_t *item = ObjPlayer_GetEquippedItem(hurter);
		if (item)
		{
			if (item->itemBehavior == INVITEM_BEHAVIOR_VIEWHEALTH)
			{
				ObjPlayer_HealthDisplay(hurter, obj);
			}
		}
	}
}

//death
void ObjCCon_Death(gameObject_t *obj, gameObject_t *killer, int dmg)
{
	if (obj->target && obj->target->inuse && obj->target->activate && !(obj->target->net.renderEffects & FXFL_HIDDEN))
	{
		obj->target->activate(obj->target, obj);
	}
	if (obj->chain)
	{
		obj->chain->think = ObjGeneral_RemoveThink;
		obj->chain->thinkTime = g_curTime;
		obj->chain = NULL;
	}
	float c[3];
	obj->hurtable = false;
	float ang[3] = {0.0f, 0.0f, 0.0f};
	Util_GameObjectCenter(obj, c);
	ObjParticles_Create("other/conblow", c, ang, -1);
	ObjSound_Create(c, "assets/sound/cb/boom.wav", 1.0f, -1);
	ObjSound_Create(c, "assets/sound/cb/boom.wav", 1.0f, -1);
	obj->net.renderEffects2 |= FXFL2_DEATH2;
	obj->think = ObjGeneral_RemoveThink;
	obj->thinkTime = g_curTime + 5000;
	obj->net.solid = 0;
	LServ_UpdateRClip(obj);

	if (killer && killer->inuse && killer->hurtable)
	{ //radius damage in the name of the killer
		Util_RadiusDamage(killer, 200, 1024.0f, c, false);
	}
}

//spawn
void ObjCCon_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	g_sharedFn->Common_ServerString("&assets/models/ccon2.rdm");
	g_sharedFn->Common_ServerString("&&other/conblow");

	AI_GenericSpawn(obj, b, args, numArgs);

	obj->canBePushed = false;
	obj->aiObj->maxHealth = obj->health;
	obj->aiObj->nonActive = true;

	obj->net.aiDescIndex = AIDESC_CCON;

	obj->think = ObjCCon_Think;
	obj->pain = ObjCCon_Pain;
	obj->death = ObjCCon_Death;

	objArgs_t lightArgs[5];
	lightArgs[0].key = "color";
	lightArgs[0].val = "(1.5 1.5 1.5)";
	lightArgs[1].key = "radius";
	lightArgs[1].val = "2048";
	lightArgs[2].key = "shadows";
	lightArgs[2].val = "0";
	lightArgs[3].key = "spotcone";
	lightArgs[3].val = "60";
	lightArgs[4].key = "spotlight";
	lightArgs[4].val = "1";
	float lightAng[3] = {30.0f, obj->net.ang[YAW]+90.0f, 0.0f};
	float lightPos[3];
	float ang[3] = {obj->net.ang[0], obj->net.ang[1]-90.0f, 0.0f};
	float fwd[3], up[3];
	Math_AngleVectors(ang, fwd, 0, up);
	Math_VecMA(obj->net.pos, 700.0f, fwd, lightPos);
	Math_VecMA(lightPos, 500.0f, up, lightPos);
	obj->chain = LServ_ObjectFromName("obj_dynamiclight", lightPos, lightAng, lightArgs, 5);
	if (obj->chain)
	{
		obj->chain->spawnArgs = NULL;
		obj->chain->numSpawnArgs = 0;
	}
}
