/*
=============================================================================
Module Information
------------------
Name:			obj_sound.cpp
Author:			Rich Whitehouse
Description:	server logic object: sound
=============================================================================
*/

#include "main.h"

//frame function
void ObjSound_Think(gameObject_t *obj, float timeMod)
{
	LServ_FreeObject(obj);
}

//creation from index
void ObjSound_CreateFromIndex(float *pos, int index, float volume, int attachIndex)
{
	gameObject_t *snd = LServ_CreateObject();

	if (!snd)
	{
		return;
	}

	snd->net.type = OBJ_TYPE_NETEVENT;
	snd->net.frame = NETEVENT_SOUND;
	snd->net.pos[0] = pos[0];
	snd->net.pos[1] = pos[1];
	snd->net.pos[2] = pos[2];
	snd->net.modelScale[0] = volume;
	if (attachIndex != -1)
	{
		snd->net.owner = 1; //neverStomp
	}
	else
	{
		snd->net.owner = 0;
	}
	snd->net.solid = attachIndex;

	snd->net.ang[0] = 0.0f;
	snd->net.ang[1] = 0.0f;
	snd->net.ang[2] = 0.0f;

	snd->think = ObjSound_Think;
	snd->thinkTime = g_curTime;

	snd->net.strIndex = index;
}

//creation
void ObjSound_Create(float *pos, const char *sound, float volume, int attachIndex)
{
	char str[64];
    sprintf(str, "$%s", sound);
	int index = g_sharedFn->Common_ServerString(str);
	ObjSound_CreateFromIndex(pos, index, volume, attachIndex);
}
