#ifndef _CLSHARED_H

#define _CLSHARED_H

#define CL_LOGIC_API_VERSION	1340

class CSafeModelPtr;
typedef struct rda_s rda_t;
typedef struct texShader_s texShader_t;
typedef struct rsprite_s rsprite_t;
typedef struct cubicGridSpace_s cubicGridSpace_t;
typedef struct waveFile_s waveFile_t;
typedef struct particleInstance_s particleInstance_t;
typedef struct particleSystem_s particleSystem_t;

typedef struct clientString_s
{
	char		p[64];
} clientString_t;

typedef struct texContainer_s
{
	bool			inuse;
	texShader_t		*shader;
} texContainer_t;

typedef enum
{
	FLARETEX_CORONA,
	FLARETEX_MID,
	FLARETEX_MID2,
	FLARETEX_MID3,
	FLARETEX_BURST,
	FLARETEX_END,
	FLARETEX_NUM
} flareTextures_e;

typedef struct lensFlare_s
{
	unsigned long		inViewTime;

	int					numMidSections;
	float				length;
	float				sizeScale;
	texContainer_t		textures[FLARETEX_NUM];
} lensFlare_t;

typedef struct ambientLight_s
{
	//ambientLightInteraction_t	*interactions;
	//int						numInteractions;
	float						worldTranslation[3];
	//float						mins[3];
	//float						maxs[3];

	float						scale[3];
	int							glTex;
} ambientLight_t;

typedef struct modelLightInteraction_s modelLightInteraction_t;
typedef struct sceneLight_s
{
	float			pos[3];
	float			color[3];
	float			radius;
	bool			shadows;
	ambientLight_t	*ambientLight;
	int				staticIndex;
	bool			hasFrameScissor;
	bool			doFrameScissor;
	float			frameScissor[6];
	int				lightFlags;
	viewFrustum_t	*spotFrust;
	texContainer_t	spotTex;
	bool			noVolumes;
	CSafeModelPtr	*noShadowModels[8];
	int				numNoShadowModels;
	float			lightMatrix[16];
	bool			hasShadowMaps;

	jobHandle_t				job;
	modelLightInteraction_t	*inter;
	int						numInter;
} sceneLight_t;

typedef struct trailPoint_s
{
	float			pos[3];
	unsigned long	time;
} trailPoint_t;

typedef struct renderTrail_s
{
	trailPoint_t	*points;
	int				numPoints;
	float			width;
	unsigned long	segmentLife;
	unsigned long	segmentFade;
	float			segmentRise;

	float			*fadeMap;
	int				fadeNum;
	float			*tcMap;
	int				tcNum;

	float			*worldNormals;
	bool			batchAllocated;

	float			mins[3];
	float			maxs[3];
} renderTrail_t;

typedef struct spriteBatchInfo_s
{
	float			pos[3];
	float			ang[3];
	float			rgba[4];
	float			scale[2];
	float			*tc;
} spriteBatchInfo_t;

typedef struct simpleSpriteTrn_s simpleSpriteTrn_t;

typedef struct simpleSprite_s
{
	//float			verts[3*4];
	//float			tc[2*4];
	float			*verts;
	float			*tc;
	float			scaleX;
	float			scaleY;
	bool			noDepthWrite;
	bool			noDepthTest;
	bool			twoSided;
	spriteBatchInfo_t *batchInfo;
} simpleSprite_t;

typedef struct genericDraw_s
{
	int				primType;

	int				numVerts;
	float			*verts;
	float			*texCoords;
	float			*colors;

	float			pos[3];
	float			ang[3];

	bool			freeBuffers;
	bool			forceNoDepth;

	genericDraw_s	*next;
} genericDraw_t;

typedef struct textureRemap_s
{
	texContainer_t		src;
	texContainer_t		dst;
} textureRemap_t;

typedef struct drawObject_s
{
	float				pos[3];
	float				ang[3];

	CSafeModelPtr		*model;
	rda_t				*anim;
	float				modelScale[3];

	cubicGridSpace_t	*cgrid;
	int					cgridNum;

	rsprite_t			*rspr;
	int					rsprAng;
	bool				rsprNoOri;

	int					blendFrame; //applicable only for skeletal animation
	int					frame;
	float				lerpAmount; //applicable only for skeletal animation

	renderTrail_t		*trail;
	simpleSprite_t		*ssprite;
	int					sspriteBatchNum;
	simpleSpriteTrn_t	*sspriteTransform;

	lensFlare_t			*lensFlare;

	texContainer_t		texture;
	int					deforms;
	float				deformPropA;
	float				deformPropB;
	float				deformPropC;
	float				deformPropD;

	float				postTrailLen;
	float				postTrailMul;
	float				postTrailDir[3];
	int					postStencil;

	int					blendSrc;
	int					blendDst;
	float				blendRGBA[4];

	int					staticIndex;

	bool				angAbsolute;

	bool				objDynamicIllumination;

	bool				noShadows;
	bool				skipDepth;

	int					gridColorFrame;
	float				gridColor[3];
	float				gridColorSec[3];
	float				gridNormal[3];
	float				gridNormalWorld[3];
	float				groundZ;
	bool				groundZValid;

	bool				frameCulled;
	bool				didFrameCulling;

	bool				hasRepInfo;

	float				modelMat[16];
	float				modelToLocalMat[16];
	modelMatrix_t		invModelMat;
	float				testMins[3];
	float				testMaxs[3];

	textureRemap_t		*texRemaps;
	int					numTexRemaps;

	/*
	//SSHX THIS MUST REMAIN IN THE LAST 160 BYTES
	int					hasModelMat;
	float				modelMat[16];
	int					hasModelToLocalMat;
	float				modelToLocalMat[16];
	float				testMins[3];
	float				testMaxs[3];
	*/
} drawObject_t;

typedef struct clientObject_s
{
	bool			active;

	CSafeModelPtr	*model;
	rda_t			*anim;
	int				animStrIndex;

	lensFlare_t		flare;
	renderTrail_t	*trail;
	renderTrail_t	*boneTrail;
	int				boneTrailBoneIndex;
	renderTrail_t	*bladeTrail;
	int				bladeTrailBoneIndex;
	int				bladeTrailBone2Index;
	float			postPos[3];
	float			postFade;
	unsigned long	deathFxTime;
	unsigned long	spawnFxTime;
	unsigned long	otherFxTime;
	unsigned long	deathPclTime;
	bool			hasBoneOverride;
	bool			hasIKBall;
	bool			hasIKHair;

	float			projPos[3];
	float			projAng[3];
	float			projScale[3];

	bool			postAdd; //add after everything else

	BYTE			*objectData;
	bool			checkedProps;

	unsigned long	clAnimTime;

	unsigned long	clLerpAnimTime;
	int				clLerpAnimFrame;
	int				clLerpAnimBlendFrame;

	bool			hasSoundData;
	float			soundData;

	textureRemap_t	texRemaps[4];
	int				numTexRemaps;

	drawObject_t	obj;
	gameObjNet_t	net;
} clientObject_t;

typedef struct menuScript_s menuScript_t;
typedef struct mscriptNode_s mscriptNode_t;

//max args in a single script instruction
#define MAX_MENUSCRIPT_ARGS		8

typedef struct menu_s
{
    char				name[64];
	char				*text;
	int					x;
	int					y;
	int					w;
	int					h;
	texContainer_t		texture;
	int					drawTypeID;

	int					textOffX;
	int					textOffY;
	int					inputTextOffX;
	int					inputTextOffY;

	int					blendSrc;
	int					blendDst;
	float				blendRGBA[4];

	bool				selectable;
	bool				ratioCorrect;
	bool				noLineWrap;
	int					textSelector;
	char				*textSelPtr;
	int					textSelLineCount;
	float				fontScaleX;
	float				fontScaleY;

	bool				takeInput;
	char				inputStr[64];

	bool				inuse;
	bool				server; //if true, then input etc should be sent to the server.

	char				activateScript[64];
	char				onEscape[64];
	char				onSort[64];
	bool				draw;

	bool				isSorting;
	int					sortLine;

	CSafeModelPtr		*model;
	rda_t				*modelAnim;
	int					modelAnimStart;
	int					modelAnimEnd;
	int					modelAnimFrame;
	int					modelAnimBlendFrame;
	unsigned long		modelAnimLerpTime;
	char				*modelName;
	char				*modelAnimName;
	float				modelOfs[3];
	float				modelAng[3];

	texContainer_t		ptrTexture;
} menu_t;

typedef struct menuPointer_s
{
	menu_t			*selected;
} menuPointer_t;

typedef struct mscriptArg_s
{
	char			p[64];
} mscriptArg_t;

typedef struct mscriptHandler_s
{
	char			*name;
	bool			(*handlerFunc)(mscriptNode_t *node, menuScript_t *mscript);
	int				argNum;
} mscriptHandler_t;

typedef struct mscriptNode_s
{
	mscriptArg_t		menuArgs[MAX_MENUSCRIPT_ARGS];
	mscriptHandler_t	*nodeHandler;

	mscriptNode_t		*next;
} mscriptNode_t;

typedef struct menuScript_s
{
	char			name[64];

	unsigned long	scriptTime;
	mscriptNode_t	*nodes;
	mscriptNode_t	*curNode;

	bool			inuse;
} menuScript_t;

typedef struct sharedCLFunctions_s
{
	//called back into by the engine
	void					(*LCl_Frame)(unsigned long time, int numObj, int localCl, bool clientInterpolate,
										bool isMulti, float musicFrac, float *viewPos, float *viewAng);
	void					(*LCl_Draw2D)(viewFrustum_t *viewFrust);
	void					(*LCl_DrawPostMenu)(viewFrustum_t *viewFrust);
	bool					(*LCl_CanPause)(void);
	void					(*LCl_CacheResources)(void);
	void					(*LCl_NetEvent)(clientEventTypes_e e, BYTE *data, int dataSize);
	void					(*LCl_FreshClientObject)(clientObject_t *obj);
	void					(*LCl_UserMenu)(const char *callName, mscriptNode_t *node, menuScript_t *mscript);
	bool					(*LCl_UserSort)(const char *sortName, menu_t *menu);

	//math routines
	void					(*Math_CalcPlaneEq)(float *x, float *y, float *z, float *planeEq);
	float					(*Math_VecNorm2)(float *v);
	float					(*Math_VecNorm)(float *v);
	float					(*Math_PlaneNorm)(float *plane);
	float					(*Math_VecLen)(float *a);
	float					(*Math_PlaneDist)(const float *pl, const float *p);
	void					(*Math_ProjectOntoPlane)(const float *plane, const float *pos, float *out);
	void					(*Math_VecCopy)(float *a, float *out);
	void					(*Math_VecSub)(float *a, float *b, float *out);
	void					(*Math_VecAdd)(float *a, float *b, float *out);
	void					(*Math_VecScale)(float *a, float scale);
	float					(*Math_Max2)(float a, float b);
	float					(*Math_Max3)(float a, float b, float c);
	void					(*Math_TransformPointByMatrix)(modelMatrix_t *matrix, float *in, float *out);
	void					(*Math_TransformPointByMatrix3x3)(modelMatrix_t *matrix, float *in, float *out);
	void					(*Math_TransformPoint)(float *basePos, float *scale, float *eAngles, float *in, float *out);
	void					(*Math_VecMA)( float *veca, float scale, float *vecb, float *vecc);
	void					(*Math_VecToAngles)(const float *value1, float *angles);
	void					(*Math_TransformPoint2)(float *basePos, float *scale, float *eAngles, float *in, float *out);
	void					(*Math_MatrixInverse)(modelMatrix_t *in, modelMatrix_t *out);
	void					(*Math_MatrixMultiply)(modelMatrix_t *in, modelMatrix_t *in2, modelMatrix_t *out);
	void					(*Math_MatrixMultiply3x3)(modelMatrix_t *in, modelMatrix_t *in2, modelMatrix_t *out);
	void					(*Math_MatrixMultiply4x4)(fourxMatrix_t *in, fourxMatrix_t *in2, fourxMatrix_t *out);
	void					(*Math_RotateMatrix)(modelMatrix_t *mat, float ang, float x, float y, float z);
	void					(*Math_TranslateMatrix)(modelMatrix_t *mat, float *v);
	void					(*Math_AnglesToMat)(const float *incAngles, modelMatrix_t *mat);
	void					(*Math_CrossProduct)(const float *v1, const float *v2, float *cross);
	float					(*Math_DotProduct)(const float *v1, const float *v2);
	float					(*Math_AngleMod)(float angle);
	void					(*Math_InterpolateVector)(float *old, float *cur, float val, float tresh, float *out);
	float					(*Math_BlendAngle)(float in, float goal, float factor);
	float					(*Math_BlendAngleLinear)(float in, float goal, float amount);
	void					(*Math_AngleVectors)(float *angles, float *forward, float *right, float *up);
	void					(*Math_AxisForNormal)(float *normal, float *fwd, float *right, float *up);
	void					(*Math_LerpMatrices)(modelMatrix_t &preMat, modelMatrix_t &postMat, float lerpFrac, modelMatrix_t &outMat, bool nonUniform);
	void					(*Math_CreateMatrixFromOrientation)(float *origin, float *angles, modelMatrix_t *mat);
	void					(*Math_RotationMatrix)(float phi, int axis, modelMatrix_t *mat);
	bool					(*Math_BoxesOverlap)(float *mins1, float *maxs1, float *mins2, float *maxs2);
	void					(*Math_ExpandBounds)(float *baseMins, float *baseMaxs, float *mins, float *maxs);
	void					(*Math_CreateFrustum)(float fov, float *pos, float *ang, viewFrustum_t *out);
	void					(*Math_CreateFrustumForViewAxis)(float *pos, float *axis, viewFrustum_t *out, float fovX, float fovY, float zNear, float zFar);
	void					(*Math_GetFrustumPoints)(viewFrustum_t *frustum, float points[8][3], modelMatrix_t *frustMat);
	void					(*Math_BoundsFromPoints)(float *outMins, float *outMaxs, float *points, int numPoints);
	int						(*Math_PointRelativeToPlane)(float *pos, float *side, float *planeEq);
	void					(*Math_GetBoundsPoints)(float *mins, float *maxs, float *bp, float *baxis);
	bool					(*Math_PointInFrustum)(viewFrustum_t *frustum, float *point, float radius);
	int						(*Math_BoxInFrustum)(viewFrustum_t *frustum, float *mins, float *maxs);
	void					(*Math_MatToAngles)(float *angles, const modelMatrix_t *mat);
	void					(*Math_MatToAngles2)(float *angles, const modelMatrix_t *mat);

	//file system
	int						(*FileSys_OpenFile)(const char *filename, int mode1, int mode2);
	void					(*FileSys_CloseFile)(int handle);
	int						(*FileSys_GetLen)(int handle);
	bool					(*FileSys_ReadFile)(int handle, void *out, int len);
	bool					(*FileSys_WriteFile)(int handle, void *in, int len);
	bool					(*FileSys_Read)(int handle, void *out, int len);
	bool					(*FileSys_Write)(int handle, void *in, int len);
	char					*(*FileSys_GetFileList)(const char *searchPath, const char *searchType);

	void					*(*Common_RCMalloc)(unsigned int size); //malloc
	void					(*Common_RCFree)(void *ptr); //free

	//resource functions
	BYTE					*(*RCO_GetEntryForObject)(const char *objName);
	const char				*(*RCO_GetValForKey)(BYTE *aobj, const char *keyName);
	void					(*RCO_SetValForKey)(BYTE *aobj, const char *keyName, const char *value);
	int						(*Img_TextureLoad)(const char *name, texContainer_t *tx);
	CSafeModelPtr			*(*Model_Allocate)(const char *filename);
	void					(*Model_Free)(CSafeModelPtr *model);
	char					*(*Model_GetName)(CSafeModelPtr *model);
	void					(*Model_ProjectDecal)(drawObject_t *modelSceneObj, float *start, float *end, float decalSize, texContainer_t *decalTex, int lifeTime, int fadeTime);
	rda_t					*(*Anim_Allocate)(const char *filename, bool decompress);
	waveFile_t				*(*S_CacheSound)(const char *filename);
	void					(*S_PlayWave)(waveFile_t *wave, float *pos, float volume, bool neverStomp, int attachClientObj, int forceChannel);
	particleInstance_t		*(*ClPcl_CreateParticles)(const char *pclName, float *pos, float *angles, int clOwner, int clBone);
	void					(*ClPcl_CacheParticleSystemAssets)(const char *pclName, particleSystem_t *pcl);

	//gl interface
	void					(*GL_AddDrawObject)(drawObject_t *obj);
	void					(*GL_AddSkyObject)(drawObject_t *obj);
	void					(*GL_AddSceneLight)(sceneLight_t *light);
	void					(*GL_AddGenericObject)(genericDraw_t *obj);
	void					(*GL_BindTexContainer)(texContainer_t *tx);
	float					(*GL_RatioCorrectWidth)(float f);
	float					(*GL_ScaleBasedOnResX)(float f);
	float					(*GL_ScaleBasedOnResY)(float f);
	float					(*GL_ScaleBasedOnResW)(float f);
	float					(*GL_ScaleBasedOnResH)(float f);
	void					(*GL_VertProgramBegin)(bool untextured);
	void					(*GL_VertProgramEnd)(void);
	void					(*GL_PrepareForDraw)(void);
	void					(*GL_DrawRect)(float x, float y, float w, float h, texContainer_t *tex, bool flipH, bool flipV);
	void					(*GL_DrawRectRot)(float x, float y, float w, float h, texContainer_t *tex, float angle);
	float					(*GL_DrawRawText)(float x, float y, float scaleX, float scaleY,
								char *txPtr, bool isInput, float lineWrapLen);
	void					(*GL_SetFlash)(unsigned long duration, unsigned long time, float *clr);
	void					(*GL_SetViewTrails)(float amount, float decay);
	void					(*GL_SetBloomMod)(float amount);
	void					(*GL_SetFadein)(unsigned long dur);
	void					(*GL_WorldToScreen)(float *worldPos, float *screenPos);
	void					(*RGL_Color4fv)(float *clr);
	void					(*RGL_Color4f)(float r, float g, float b, float a);
	void					(*GL_SetFragmentFog)(float *color, float startDist, float endDist, int fogBlendMode);

	//client
	void					(*Cl_AddAllObjects)(void);
	void					*(*Cl_FrameAlloc)(int size);
	void					(*ClPcl_SetParticleTimeScale)(float timescale);
	void					(*Cl_LocalSaveGame)(char *saveName);
	void					(*Cl_LocalLoadGame)(char *saveName);

	//menu interface
	menu_t					*(*Menu_GetMenu)(char *menuName);
	menu_t					*(*Menu_GetActiveMenu)(char *menuName);
	menuPointer_t			*(*Menu_GetMenuPointer)(void);
	void					(*Menu_ParseFile)(char *menuFile);
	bool					(*Menu_StartScript)(char *scriptName);
	bool					(*Menu_StopScript)(char *scriptName);
	void					(*Menu_SetDraw)(menu_t *menu, bool draw);
	bool					(*Menu_AnyActiveMenus)(void);

	//network interface
	void					(*Net_DoChat)(const char *str);
	int						(*Net_CreateDelta)(void *previous, void *current, int dataSize, BYTE *deltaOut, int deltaOutSize);
	void					(*Net_ParseDelta)(void *current, int dataSize, BYTE *deltaIn);
	void					(*Net_SetClientUserData)(BYTE *data, int dataSize);
	void					(*Net_SendSvEventType)(serverEventTypes_e eventType, void *data, int dataSize);

	//input
	bool					(*DInput_ButtonPressed)(int button);
	void					(*DInput_GetAnalogs)(WORD *analogs);

	//threading
	void					(*JT_DoJob)(void (*job)(void *userData), void *userData, jobHandle_t *jobHandle);
	bool					(*JT_JobDone)(jobHandle_t *jobHandle, bool stall);
	void					(*Thread_EnterCritical)(int critIndex);
	void					(*Thread_LeaveCritical)(int critIndex);

	//parsing
	textParser_t			*(*Parse_InitParser)(char *rawText);
	textParser_t			*(*Parse_InitParserFromFile)(const char *filename);
	void					(*Parse_FreeParser)(textParser_t *parser);
	void					(*Parse_EnableInclude)(textParser_t *parser, const char *includeKey);
	bool					(*Parse_GetNextToken)(textParser_t *parser, parseToken_t *parseToken);
	bool					(*Parse_WhiteSpace)(char chr);

	//containers
	cntArray_t				*(*Array_Alloc)(int elementSize, int initialNum);
	void					(*Array_Free)(cntArray_t *ar);
	void					(*Array_SetGrowth)(cntArray_t *ar, bool exponential);
	void					*(*Array_GetElement)(cntArray_t *ar, int index);
	void					*(*Array_GetElementGrow)(cntArray_t *ar, int index);
	void					(*Array_Append)(cntArray_t *ar, void *element);
	void					(*Array_RemoveLast)(cntArray_t *ar);
	void					(*Array_Insert)(cntArray_t *ar, void *element, int index);
	void					(*Array_Remove)(cntArray_t *ar, int index);
	int						(*Array_GetCount)(cntArray_t *ar);
	void					(*Array_Tighten)(cntArray_t *ar);
	unsigned int			(*Hash_GetKey)(unsigned char *data, int dataLen);
	cntHash_t				*(*Hash_Alloc)(int size);
	void					(*Hash_Free)(cntHash_t *hash);
	void					(*Hash_AddIndexedKey)(cntHash_t *hash, unsigned int key, int index);
	void					(*Hash_RemoveIndexedKey)(cntHash_t *hash, unsigned int key, int index);
	cntHashList_t			*(*Hash_GetKeyList)(cntHash_t *hash, unsigned int key);
	cntStream_t				*(*Stream_Alloc)(void *buffer, int size);
	void					(*Stream_Free)(cntStream_t *st);
	void					(*Stream_WriteBits)(cntStream_t *st, void *buf, int size);
	void					(*Stream_WriteBytes)(cntStream_t *st, void *buf, int size);
	bool					(*Stream_ReadBits)(cntStream_t *st, void *buf, int size);
	bool					(*Stream_ReadBytes)(cntStream_t *st, void *buf, int size);
	void					(*Stream_WriteBool)(cntStream_t *st, bool val);
	void					(*Stream_WriteInt)(cntStream_t *st, int val);
	void					(*Stream_WriteFloat)(cntStream_t *st, float val);
	void					(*Stream_WriteString)(cntStream_t *st, char *str);
	bool					(*Stream_ReadBool)(cntStream_t *st);
	int						(*Stream_ReadInt)(cntStream_t *st);
	float					(*Stream_ReadFloat)(cntStream_t *st);
	void					(*Stream_ReadString)(cntStream_t *st, char *str, int maxSize);
	void					*(*Stream_Buffer)(cntStream_t *st);
	int						(*Stream_Size)(cntStream_t *st);
	void					(*Stream_SetOffset)(cntStream_t *st, int offset);
	int						(*Stream_GetOffset)(cntStream_t *st);
	strHash_t				*(*SHash_Alloc)(int poolSize);
	void					(*SHash_Free)(strHash_t *s);
	int						(*SHash_Index)(strHash_t *s, char *str);
	char					*(*SHash_String)(strHash_t *s, int index);
	int						(*SHash_GetCount)(strHash_t *s);
} sharedCLFunctions_t;

#endif //_CLSHARED_H
