/*
=============================================================================
Module Information
------------------
Name:			obj_forcefield.cpp
Author:			Rich Whitehouse
Description:	trigger box
=============================================================================
*/

#include "main.h"
#include "ai.h"
#include "rscript.h"

//can be activated for immediate use
void ObjForceField_Activate(gameObject_t *obj, gameObject_t *activator)
{
	obj->net.renderEffects ^= FXFL_HIDDEN;
}

//if nothing is inside, become solid
void ObjForceField_BecomeSolid(gameObject_t *obj)
{
	if (obj->net.solid)
	{
		return;
	}

	collObj_t col;
	g_sharedFn->Coll_MovementTranslation(obj->rcColModel, &col, obj->net.pos, obj->net.pos, NULL, NULL);
	if (!col.hit && !col.containsSolid)
	{
		ObjSound_Create(obj->net.pos, "assets/sound/cb/beamoff.wav", 1.0f, -1);
		obj->net.solid = 1;
		LServ_UpdateRClip(obj);
	}
}

//think
void ObjForceField_Think(gameObject_t *obj, float timeMod)
{
	obj->thinkTime = g_gameTime;

	RCUBE_ASSERT(obj->rcColModel);
	if (obj->net.renderEffects & FXFL_HIDDEN)
	{ //become unsolid
		if (obj->net.solid)
		{
			ObjSound_Create(obj->net.pos, "assets/sound/cb/beamoff.wav", 1.0f, -1);
			ObjSound_Create(obj->net.pos, "assets/sound/cb/beamoff.wav", 1.0f, -1);
			obj->net.solid = 0;
			LServ_UpdateRClip(obj);
		}
	}
	else
	{
		ObjForceField_BecomeSolid(obj);
	}
}

//axis distances
static void ObjForceField_AxDistances(gameObject_t *obj, float *dir, int axis, float &d1, float &d2)
{
	collObj_t col;
	collOpt_t opt;
	memset(&opt, 0, sizeof(opt));
	opt.ignoreBoxModels = true;
	float dst[3];
	Math_VecMA(obj->net.pos, 16384.0f, dir, dst);
	g_sharedFn->Coll_RadiusTranslation(obj->rcColModel, &col, obj->net.pos, dst, 0.0f, NULL, &opt);
	d1 = col.distance;
	Math_VecMA(obj->net.pos, -16384.0f, dir, dst);
	g_sharedFn->Coll_RadiusTranslation(obj->rcColModel, &col, obj->net.pos, dst, 0.0f, NULL, &opt);
	d2 = col.distance;
}

//axial mid-point
static float ObjForceField_AxMidPoint(gameObject_t *obj, float *dir, int axis, float *outPos)
{
	float d1, d2;
	ObjForceField_AxDistances(obj, dir, axis, d1, d2);
	outPos[0] = obj->net.pos[0]+dir[0]*d1;
	outPos[1] = obj->net.pos[1]+dir[1]*d1;
	outPos[2] = obj->net.pos[2]+dir[2]*d1;
	d1 = (d1+d2)*0.5f;
	outPos[0] -= dir[0]*d1;
	outPos[1] -= dir[1]*d1;
	outPos[2] -= dir[2]*d1;
	return d1;
}

//spawn
void ObjForceField_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	g_sharedFn->Common_ServerString("$assets/sound/cb/beamoff.wav");
	g_sharedFn->Common_ServerString("^assets/textures/forcefield");
	g_sharedFn->Common_ServerString("^assets/textures/forcefield2");
	obj->rcColModel = g_sharedFn->Coll_RegisterModelInstance("*box");
	obj->net.solid = 1;
	LServ_UpdateRClip(obj);

	obj->net.ang[0] = 0.0f;
	obj->net.ang[1] = 0.0f;
	obj->net.ang[2] = 0.0f;

	float fwd[3], right[3], up[3];
	Math_AngleVectors(obj->net.ang, fwd, right, up);
	obj->spawnMaxs[2] = ObjForceField_AxMidPoint(obj, up, 2, obj->net.pos);
	float fwd1, fwd2, right1, right2;
	ObjForceField_AxDistances(obj, fwd, 0, fwd1, fwd2);
	ObjForceField_AxDistances(obj, right, 1, right1, right2);
	fwd1 += fwd2;
	right1 += right2;
	if (fwd1 < right1)
	{
		obj->spawnMaxs[0] = ObjForceField_AxMidPoint(obj, fwd, 0, obj->net.pos);
		obj->spawnMaxs[1] = 1.0f;
		obj->net.ang[1] = 90.0f;
	}
	else
	{
		obj->spawnMaxs[0] = 1.0f;
		obj->spawnMaxs[1] = ObjForceField_AxMidPoint(obj, right, 1, obj->net.pos);
	}
	obj->spawnMins[0] = -obj->spawnMaxs[0];
	obj->spawnMins[1] = -obj->spawnMaxs[1];
	obj->spawnMins[2] = -obj->spawnMaxs[2];
	Math_VecCopy(obj->spawnMins, obj->net.mins);
	Math_VecCopy(obj->spawnMaxs, obj->net.maxs);

	LServ_UpdateRClip(obj);

	obj->activate = ObjForceField_Activate;
	obj->think = ObjForceField_Think;
	obj->thinkTime = g_gameTime;
	obj->net.renderEffects2 |= FXFL2_FORCEFIELD;

	for (int i = 0; i < numArgs; i++)
	{
		const objArgs_t *arg = obj->spawnArgs+i;
		if (!stricmp(arg->key, "startoff"))
		{
			if (atoi(arg->val))
			{
				obj->net.renderEffects |= FXFL_HIDDEN;
			}
		}
	}
}
