/*
=============================================================================
Module Information
------------------
Name:			obj_general.cpp
Author:			Rich Whitehouse
Description:	server logic object: general
=============================================================================
*/

#include "main.h"

//removal upon next think
void ObjGeneral_RemoveThink(gameObject_t *obj, float timeMod)
{
	LServ_FreeObject(obj);
}

//frame function
void ObjGeneral_Think(gameObject_t *obj, float timeMod)
{
	/*
	if (obj->net.strIndexB)
	{
		if (obj->debounce2 < g_gameTime)
		{
			int lastFrame = obj->net.frame;
			obj->net.frame += 1;
			if (obj->net.frame >= 400)
			{
				obj->net.frame = 0;
			}
			obj->net.lerpDuration = (int)(68.0f*g_invTimeScale);
			
			if (obj->rcColModel)
			{
				obj->rcColModel->blendFrame = lastFrame;
				obj->rcColModel->frame = obj->net.frame;
				obj->debounce3 = g_gameTime;
				g_sharedFn->Coll_UpdateModel(obj->rcColModel, NULL);
			}
			obj->debounce2 = g_gameTime + 50;
		}

		if (obj->debounce < g_gameTime)
		{
			gameObject_t *pl = &g_gameObjects[0];
			if (pl->inuse)
			{
				float d[3];
				Math_VecSub(pl->net.pos, obj->net.pos, d);
				if (Math_VecLen(d) < 5000.0f)
				{
					Math_VecNorm(d);
					float factor = 64.0f;
					obj->net.vel[0] += d[0]*factor;
					obj->net.vel[1] += d[1]*factor;
					//obj->net.vel[2] += d[2]*factor;
					Math_VecToAngles(obj->net.vel, obj->net.ang);
				}
			}
			obj->debounce = g_gameTime + 10;
		}
		Phys_ApplyObjectPhysics(obj, timeMod, obj->radius, 80.0f, 0.0f);
	}

	if (obj->rcColModel && obj->debounce3)
	{
		serverTime_t lerpDur = 68;
		serverTime_t dif = g_gameTime-obj->debounce3;
		if (dif > lerpDur)
		{
			dif = lerpDur;
		}

		obj->rcColModel->lerpAmount = 1.0f-((float)dif/(float)lerpDur);
		g_sharedFn->Coll_UpdateModel(obj->rcColModel, NULL);

		modelMatrix_t boneMat;
		if (g_sharedFn->Coll_GetModelBoneMatrix(obj->rcColModel, "b32", &boneMat))
		{
			Math_VecNorm(boneMat.x1);
			Math_VecNorm(boneMat.x2);
			Math_VecNorm(boneMat.x3);

			float ofs[3] = {0.0f, 0.0f, -80.0f};
			float bonePos[3], boneDir[3];
			Math_TransformPointByMatrix(&boneMat, ofs, bonePos);
			Math_VecSub(bonePos, boneMat.o, boneDir);
			Math_VecNorm(boneDir);

			Util_DebugFX(bonePos, boneDir);
		}
	}
	*/

	obj->thinkTime = g_gameTime;
}

//spawn generic netless object
void ObjGeneral_SpawnNoNet(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->localFlags |= LFL_NONET;
}

//spawn generic object
void ObjGeneral_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
}
