/*
=============================================================================
Module Information
------------------
Name:			obj_lift.cpp
Author:			Rich Whitehouse
Description:	elevators and such
=============================================================================
*/

#include "main.h"

//think
void ObjLift_Think(gameObject_t *obj, float timeMod)
{
	float targetPos[3];

	if (obj->debounce2)
	{ //back to start
		targetPos[0] = obj->spareVec[0];
		targetPos[1] = obj->spareVec[1];
		targetPos[2] = obj->spareVec[2];
	}
	else
	{
		targetPos[0] = obj->target->net.pos[0];
		targetPos[1] = obj->target->net.pos[1];
		targetPos[2] = obj->target->net.pos[2];
	}

	if (!obj->generalFlag)
	{
		for (int i = 0; i < MAX_NET_CLIENTS; i++)
		{
			gameObject_t *pl = &g_gameObjects[i];
			if (pl->inuse)
			{
				float d[3];
				Math_VecSub(obj->net.pos, pl->net.pos, d);
				if (Math_VecLen(d) < 400)
				{
					obj->generalFlag = 1;
					break;
				}
			}
		}
	}

	if (obj->generalFlag && obj->target && obj->debounce < g_gameTime)
	{ //move toward target
		float moveAmount = 40.0f*timeMod;
		float d[3];
		Math_VecSub(targetPos, obj->net.pos, d);
		float l = Math_VecNorm(d);
		if (l > moveAmount)
		{
			Math_VecNorm(d);
			d[0] *= moveAmount;
			d[1] *= moveAmount;
			d[2] *= moveAmount;
			d[0] += obj->net.pos[0];
			d[1] += obj->net.pos[1];
			d[2] += obj->net.pos[2];
		}
		else
		{
			Math_VecCopy(targetPos, d);
			obj->debounce2 = !obj->debounce2;
			obj->debounce = g_gameTime + 4000;
		}
		Phys_TranslatePusher(obj, d);

		if (obj->debounce3 < g_gameTime)
		{
			ObjSound_Create(obj->net.pos, "assets/sound/other/lift01.wav", 0.95f, -1);
			obj->debounce3 = g_gameTime+500;
		}

        gameObject_t *pl = &g_gameObjects[0];
		if (pl->inuse && pl->net.lives > 0)
		{
			float down[3];
			down[0] = pl->net.pos[0];
			down[1] = pl->net.pos[1];
			down[2] = pl->net.pos[2]-moveAmount-1.0f;

			collObj_t col;
			g_sharedFn->Coll_RadiusTranslation(pl->rcColModel, &col, pl->net.pos,
				down, pl->radius, NULL, false);
            if (col.hit && col.hitObjectIndex == obj->net.index)
			{
				Math_VecCopy(col.endPos, pl->net.pos);
			}
		}
	}

	obj->thinkTime = g_gameTime;
}

//lift spawn
void ObjLift_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	g_sharedFn->Common_ServerString("$assets/sound/other/lift01.wav");
	g_sharedFn->Common_ServerString("$assets/sound/other/lift02.wav");

	obj->spareVec[0] = obj->net.pos[0];
	obj->spareVec[1] = obj->net.pos[1];
	obj->spareVec[2] = obj->net.pos[2];

	obj->think = ObjLift_Think;
	obj->thinkTime = g_gameTime+50;
}
