/*
=============================================================================
Module Information
------------------
Name:			obj_particles.cpp
Author:			Rich Whitehouse
Description:	server logic object: particles
=============================================================================
*/

#include "main.h"

//frame function
void ObjParticles_Think(gameObject_t *obj, float timeMod)
{
	LServ_FreeObject(obj);
}

//creation
void ObjParticles_CreateFromIndex(int strIndex, const float *pos, const float *ang, int owner)
{
	gameObject_t *pcl = LServ_CreateObject();

	if (!pcl)
	{
		return;
	}

	pcl->net.type = OBJ_TYPE_NETEVENT;
	pcl->net.frame = NETEVENT_PARTICLES;
	pcl->net.pos[0] = pos[0];
	pcl->net.pos[1] = pos[1];
	pcl->net.pos[2] = pos[2];

	pcl->net.ang[0] = ang[0];
	pcl->net.ang[1] = ang[1];
	pcl->net.ang[2] = ang[2];

	pcl->net.owner = owner;

	pcl->think = ObjParticles_Think;
	pcl->thinkTime = g_gameTime;

	pcl->net.strIndex = strIndex;
}

void ObjParticles_Create(const char *particles, const float *pos, const float *ang, int owner)
{
	char str[64];
    sprintf(str, "&&%s", particles);
	int strIndex = g_sharedFn->Common_ServerString(str);
	ObjParticles_CreateFromIndex(strIndex, pos, ang, owner);
}
