/*
=============================================================================
Module Information
------------------
Name:			obj_plitems.cpp
Author:			Rich Whitehouse
Description:	object and support routines for player inventory items
=============================================================================
*/

#include "main.h"
#include "ai.h"

//vortex think
void ObjVortex_Think(gameObject_t *obj, float timeMod)
{
	if (obj->debounce < g_gameTime || !obj->chain || !obj->chain->inuse)
	{
		obj->think = ObjGeneral_RemoveThink;
		return;
	}

	if (obj->debounce2 < g_gameTime)
	{
		float ang[3] = {0.0f, 0.0f, 0.0f};
		ObjParticles_Create("items/vortex", obj->net.pos, ang, -1);
		ObjSound_Create(obj->net.pos, "assets/sound/cb/suck.wav", 1.0f, -1);
		obj->debounce2 = g_gameTime+200;
	}

	for (int i = 0; i < g_gameObjectSlots; i++)
	{
		gameObject_t *other = &g_gameObjects[i];
		if (other->inuse && other->canBePushed && Util_ValidEnemies(obj, other))
		{
			float c[3];
			float d[3];
			Util_GameObjectCenter(other, c);
			Math_VecSub(obj->net.pos, c, d);
			float dist = Math_VecNorm(d);
			if (dist < obj->atkRadiusCore)
			{
				float halfRad = obj->atkRadiusCore*0.5f;
				float pullStr = dist;
				if (pullStr > halfRad)
				{
					pullStr = halfRad-(pullStr-halfRad);
				}
				other->net.vel[0] += d[0]*pullStr;
				other->net.vel[1] += d[1]*pullStr;
				other->net.vel[2] += d[2]*pullStr;
				if (dist < halfRad && other->aiObj)
				{
					bool doPainAnim = AI_PainAnimChance(other);
					if (doPainAnim)
					{
						AI_StartAnim(other, HUMANIM_FLYBACK, true);
						Util_SetSequenceDamage(obj, other);
					}
				}
			}
		}
	}
}

//vortex spawn
void ObjVortex_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->think = ObjVortex_Think;
	obj->thinkTime = g_gameTime;
}

//register sounds/fx
int ObjSword_RegMedia(BYTE *b, char *prefix, int *medOut, bool isFX)
{
	char str[512];
	int num = 0;
	for (int i = 0; i < 8; i++)
	{
		sprintf(str, "%s%i", prefix, i);
		const char *med = Common_GetValForKey(b, str);
		if (!med || !med[0])
		{
			break;
		}

		if (isFX)
		{
			sprintf(str, "&&%s", med);
		}
		else
		{
			sprintf(str, "$%s", med);
		}
		int medIdx = g_sharedFn->Common_ServerString(str);
		if (medOut)
		{
			medOut[num] = medIdx;
		}
		num++;
	}
	return num;
}

//sword spawn
void ObjSword_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->swordObj = (swordObject_t *)g_sharedFn->Common_RCMalloc(sizeof(swordObject_t));
	memset(obj->swordObj, 0, sizeof(swordObject_t));

	obj->swordObj->numHitSounds = ObjSword_RegMedia(b, "swdHitSnd", obj->swordObj->hitSounds, false);
	obj->swordObj->numSwingSounds = ObjSword_RegMedia(b, "swdSwing", obj->swordObj->swingSounds, false);
	obj->swordObj->numImpactSounds = ObjSword_RegMedia(b, "swdImpact", obj->swordObj->impactSounds, false);
	obj->swordObj->numUnholsterSounds = ObjSword_RegMedia(b, "swdUnholst", obj->swordObj->unholsterSounds, false);
	obj->swordObj->numHolsterSounds = ObjSword_RegMedia(b, "swdHolst", obj->swordObj->holsterSounds, false);
	obj->swordObj->numHitFX = ObjSword_RegMedia(b, "swdHitFx", obj->swordObj->hitFX, true);
	obj->swordObj->numImpactFX = ObjSword_RegMedia(b, "swdImpactFx", obj->swordObj->impactFX, true);

	obj->generalFlag = 50;
	obj->spareVec[0] = 20.0f;
	obj->spareVec[1] = 430.0f;
	const char *hiltLen = Common_GetValForKey(b, "hiltLen");
	if (hiltLen && hiltLen[0])
	{
		obj->spareVec[0] = (float)atof(hiltLen);
	}
	const char *bladeLen = Common_GetValForKey(b, "bladeLen");
	if (bladeLen && bladeLen[0])
	{
		obj->spareVec[1] = (float)atof(bladeLen);
	}
	const char *bladeDmg = Common_GetValForKey(b, "bladeDmg");
	if (bladeDmg && bladeDmg[0])
	{
		obj->generalFlag = atoi(bladeDmg);
	}
	const char *bladeRad = Common_GetValForKey(b, "bladeRad");
	if (bladeRad && bladeRad[0])
	{
		obj->spareVec[2] = (float)atof(bladeRad);
	}
	const char *bladeEvo = Common_GetValForKey(b, "bladeEvo");
	if (bladeEvo && bladeEvo[0])
	{
		obj->generalFlag2 = atoi(bladeEvo);
	}
	const char *bladeDrain = Common_GetValForKey(b, "bladeDrain");
	if (bladeDrain && bladeDrain[0])
	{
		obj->generalFlag3 = atoi(bladeDrain);
	}
}

//create a vortex
void PlItem_CreateVortex(gameObject_t *pl, float *pos, int duration, float power)
{
	float safePos[3];
	Util_GetSafeOffset(pl, pos, safePos);
	float ang[3] = {0.0f, 0.0f, 0.0f};
	gameObject_t *vortex = LServ_ObjectFromName("obj_vortex", pos, ang, NULL, 0);
	if (vortex)
	{
		vortex->chain = pl;
		vortex->localFlags = (pl->localFlags & LFL_ENEMY);
		vortex->debounce = g_gameTime + duration;
		vortex->atkRadiusCore = power;
	}
}

//drain
void PlItem_DrainEnemies(gameObject_t *pl, float *pos, float radius, int drainAmount)
{
	ObjSound_Create(pos, "assets/sound/cb/chargeheal.wav", 1.0f, -1);
	ObjSound_Create(pos, "assets/sound/cb/healstep.wav", 1.0f, -1);
	for (int i = 0; i < g_gameObjectSlots; i++)
	{
		gameObject_t *other = &g_gameObjects[i];
		if (other->inuse && other->hurtable && Util_ValidEnemies(pl, other))
		{
			float d[3];
			Math_VecSub(pl->net.pos, other->net.pos, d);
			if (Math_VecLen(d) < radius)
			{
				Util_DamageObject(pl, other, drainAmount);
				pl->health += drainAmount;
				if (pl->health > pl->plObj->plData.maxHealth)
				{
					pl->health = pl->plObj->plData.maxHealth;
				}
			}
		}
	}
}

//earthquake
void PlItem_Quake(gameObject_t *pl, float *pos, float radius, int damage)
{
	ObjSound_Create(pos, "assets/sound/cb/quake.wav", 1.0f, -1);
	Util_ProximityShake(pos, radius, 12.0f, 1.0f);
	for (int i = 0; i < g_gameObjectSlots; i++)
	{
		gameObject_t *other = &g_gameObjects[i];
		if (other->inuse && other->hurtable && other->onGround &&
			Util_ValidEnemies(pl, other))
		{
			float d[3];
			Math_VecSub(pl->net.pos, other->net.pos, d);
			if (Math_VecLen(d) < radius)
			{
				Util_DamageObject(pl, other, damage);
				if (other->aiObj)
				{
					bool doPainAnim = AI_PainAnimChance(other);
					if (doPainAnim)
					{
						other->knockTime = g_gameTime + Util_LocalDelay(other, 100);
						AI_StartAnim(other, HUMANIM_FLYBACK2, true);
						other->net.vel[2] = 1300.0f;
					}
				}
			}
		}
	}
}

//confusion
void PlItem_Confuse(gameObject_t *pl, float *pos, float radius, int duration)
{
	ObjSound_Create(pos, "assets/sound/cb/confuse.wav", 1.0f, -1);
	for (int i = 0; i < g_gameObjectSlots; i++)
	{
		gameObject_t *other = &g_gameObjects[i];
		if (other->inuse && other->hurtable && other->onGround &&
			Util_ValidEnemies(pl, other) && other->aiObj)
		{
			other->aiObj->confuseTime = g_gameTime+duration;
		}
	}
}
