/*
=============================================================================
Module Information
------------------
Name:			obj_projectiles.cpp
Author:			Rich Whitehouse
Description:	projectiles
=============================================================================
*/

#include "main.h"

//init all projectile stuff
void ObjProjectile_Init(void)
{
	//LServ_CacheObj("obj_proj_smallbeam_blue");
	//LServ_CacheObj("obj_proj_smallbeam");
	//LServ_CacheObj("obj_supernova");
}

//impact
void ObjProjectile_Touch(gameObject_t *obj, gameObject_t *other, const collObj_t *col)
{
	if (!obj->net.solid)
	{
		return;
	}

	float plane[3];
	plane[0] = col->endNormal[0];
	plane[1] = col->endNormal[1];
	plane[2] = col->endNormal[2];
	const float *pos = col->endPos;

	if (col->hitObjectIndex == obj->net.index && other)
	{ //hack for projectiles hitting each other
		plane[0] = -plane[0];
		plane[1] = -plane[1];
		plane[2] = -plane[2];
	}

	const char *impactDcl = Common_GetValForKey(obj->objData, "dcl_impact");
	if (impactDcl && impactDcl[0] && other && other->inuse)
	{
		float posFwd[3]/*, posFwd2[3]*/, dclNormal[3];
		//Math_AngleVectors(obj->projVelAng, dclNormal, 0, 0);
		dclNormal[0] = -plane[0];
		dclNormal[1] = -plane[1];
		dclNormal[2] = -plane[2];
		posFwd[0] = pos[0] + dclNormal[0]*(obj->radius-1.0f);
		posFwd[1] = pos[1] + dclNormal[1]*(obj->radius-1.0f);
		posFwd[2] = pos[2] + dclNormal[2]*(obj->radius-1.0f);
		//posFwd2[0] = pos[0] + dclNormal[0]*obj->radius;
		//posFwd2[1] = pos[1] + dclNormal[1]*obj->radius;
		//posFwd2[2] = pos[2] + dclNormal[2]*obj->radius;
		Util_ProjectDecal(other, pos, posFwd, impactDcl, 64.0f,
			5000, 4500);
	}

	const char *impactRpl = Common_GetValForKey(obj->objData, "rpl_impact");
	if (impactRpl && impactRpl[0])
	{ //play impact particle system
		float impactFxAng[3];
		Math_VecToAngles(plane, impactFxAng);
		ObjParticles_Create(impactRpl, pos, impactFxAng, -1);
	}

	obj->net.pos[0] = pos[0];
	obj->net.pos[1] = pos[1];
	obj->net.pos[2] = pos[2];

	//do not rehit
	obj->net.solid = 0;
	LServ_UpdateRClip(obj);

	if (obj->objData)
	{
		const char *s;
		if (other && other->inuse && other->hurtable && Util_DamageObject(obj, other, obj->projDamage))
		{
			s = Common_GetValForKey(obj->objData, "dmgsoundhit");
		}
		else
		{
			s = Common_GetValForKey(obj->objData, "dmgsoundno");
		}

		if (s && s[0])
		{
			ObjSound_Create(obj->net.pos, s, 1.0f, -1);
		}
	}

	obj->projVelocity[0] = 0.0f;
	obj->projVelocity[1] = 0.0f;
	obj->projVelocity[2] = 0.0f;

	obj->net.solid = 0;

	obj->think = ObjGeneral_RemoveThink;
	obj->thinkTime = g_gameTime-1; //be sure to remove next frame think
}

//custom spawn
void ObjProjectile_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	const char *s;

	obj->think = ObjProjectile_Think;
	obj->touch = ObjProjectile_Touch;

	Util_ParseVector(Common_GetValForKey(b, "projvel"), obj->projVelocity);
	Util_ParseVector(Common_GetValForKey(b, "projfriction"), obj->projFriction);

	int numFireSounds;
	Util_ParseInt(Common_GetValForKey(b, "numfiresounds"), &numFireSounds);
	if (numFireSounds > 0)
	{
		if (g_musical)
		{
			s = Common_GetValForKey(b, "firesoundmus");
			if (s && s[0])
			{
				ObjSound_Create(obj->net.pos, s, 1.0f, -1);
				return;
			}
		}
		int index = rand()%numFireSounds;
		char fireSoundStr[256];
		sprintf(fireSoundStr, "firesound%i", index);
		s = Common_GetValForKey(b, fireSoundStr);
		if (s && s[0])
		{
			ObjSound_Create(obj->net.pos, s, 1.0f, -1);
		}
	}
}

//create a new projectile
gameObject_t *ObjProjectile_Create(gameObject_t *owner, const char *name, float *pos, float *dir)
{
	if (!owner)
	{
		return NULL;
	}
	float ang[3];
	Math_VecToAngles(dir, ang);
	gameObject_t *proj = LServ_ObjectFromName(name, pos, ang, NULL, 0);
	if (proj)
	{
		const char *dmgStr = Common_GetValForKey(proj->objData, "damage");
		if (dmgStr && dmgStr[0])
		{
			proj->projDamage = atoi(dmgStr);
		}
		else
		{
			proj->projDamage = 100;
		}
		if (proj->rcColModel)
		{
			proj->rcColModel->gameIgnore = owner->net.index;
			proj->rcColModel->clipFlags |= CLIPFL_PROJECTILE;
		}
		const char *muzzleRpl = Common_GetValForKey(proj->objData, "rpl_muzzle");
		if (muzzleRpl && muzzleRpl[0])
		{ //create the muzzle flash on the owner
			float z[3] = {0.0f, 0.0f, 0.0f};
			ObjParticles_Create(muzzleRpl, z, z, owner->net.index);
		}

		proj->net.owner = owner->net.index;
		Math_VecCopy(proj->net.ang, proj->projVelAng);
	}

	return proj;
}

//simple projectile physics
void ObjProjectile_Physics(gameObject_t *obj, float timeMod)
{
	float lastProjPos[3];
    Math_VecCopy(obj->net.pos, lastProjPos);
	float fwd[3], right[3], up[3];
	Math_AngleVectors(obj->projVelAng, fwd, right, up);
	fwd[0] *= obj->projVelocity[0]*timeMod;
	fwd[1] *= obj->projVelocity[0]*timeMod;
	fwd[2] *= obj->projVelocity[0]*timeMod;
	right[0] *= obj->projVelocity[1]*timeMod;
	right[1] *= obj->projVelocity[1]*timeMod;
	right[2] *= obj->projVelocity[1]*timeMod;
	up[0] *= obj->projVelocity[2]*timeMod;
	up[1] *= obj->projVelocity[2]*timeMod;
	up[2] *= obj->projVelocity[2]*timeMod;

	int i = 0;
	while (i < 3)
	{
		obj->net.pos[i] += fwd[i];
		obj->net.pos[i] += right[i];
		obj->net.pos[i] += up[i];
		i++;
	}

	i = 0;
	while (i < 3)
	{
		if (obj->projVelocity[i] > 0.0f)
		{
			obj->projVelocity[i] -= obj->projFriction[i]*timeMod;
			if (obj->projVelocity[i] < 0.0f)
			{
				obj->projVelocity[i] = 0.0f;
			}
		}
		else if (obj->projVelocity[i] < 0.0f)
		{
			obj->projVelocity[i] += obj->projFriction[i]*timeMod;
			if (obj->projVelocity[i] > 0.0f)
			{
				obj->projVelocity[i] = 0.0f;
			}
		}
		i++;
	}

	collObj_t col;
	g_sharedFn->Coll_RadiusTranslation(obj->rcColModel, &col, lastProjPos, obj->net.pos, obj->radius, NULL, false);
	if (col.hit && col.hitObjectIndex != -1)
	{
		gameObject_t *other = &g_gameObjects[col.hitObjectIndex];
		if (other->inuse)
		{
			Util_TouchObjects(obj, other, &col);
		}
	}

	LServ_UpdateRClip(obj);
}

//frame function
void ObjProjectile_Think(gameObject_t *obj, float timeMod)
{
	if (obj->net.ang[YAW] < 0.0f)
	{
		obj->net.ang[YAW] += 360.0f;
	}
	else if (obj->net.ang[YAW] > 360.0f)
	{
		obj->net.ang[YAW] -= 360.0f;
	}

	ObjProjectile_Physics(obj, timeMod);

	ObjCam_Removal(obj);
}
