/*
=============================================================================
Module Information
------------------
Name:			obj_rscript.cpp
Author:			Rich Whitehouse
Description:	runs r-scripts in its think

Object Arguments
script:			Name of the R-Script routine to run.
startdelay:		Time to delay starting the script, in milliseconds.
=============================================================================
*/

#include "main.h"
#include "rscript.h"

//think
void ObjRSRunner_Think(gameObject_t *obj, float timeMod)
{
	if (obj->debounce < g_gameTime)
	{
		if (!RScr_RunScript(obj->rscript, timeMod))
		{ //once it's done running, kill this object
			obj->think = ObjGeneral_RemoveThink;
		}
	}
	obj->thinkTime = g_gameTime;
}

//spawn
void ObjRSRunner_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->localFlags |= LFL_NONET;

	for (int i = 0; i < numArgs; i++)
	{
		const objArgs_t *arg = args+i;
		if (!stricmp(arg->key, "script"))
		{
			obj->rscript = RScr_CreateScript(arg->val);
		}
		else if (!stricmp(arg->key, "startdelay"))
		{
			obj->debounce = g_gameTime + atoi(arg->val);
		}
	}
	obj->think = ObjRSRunner_Think;
	obj->thinkTime = g_gameTime;
}
