#ifndef _SHAREDFN_H
#define _SHAREDFN_H

#define LOGIC_API_VERSION	1340

typedef struct sharedSVFunctions_s
{
	//server logic module routines (these should be set by the dll, and called by the exe)
	void					(*LServ_RunFrame)(unsigned long prvTime, unsigned long curTime, bool paused);
	void					(*LServ_ObjectInfo)(void **baseAddr, int *size, int *num, int *netSize, int **activeObjPtr);
	void					(*LServ_ClientSaveGame)(int clientIndex, BYTE *saveData, int saveSize);
	void					(*LServ_ClientInput)(int clientNum, BYTE *buttons, BYTE *userData, int userDataSize);
	void					(*LServ_ClientInputAngle)(int clientNum, float *angles);
	void					(*LServ_ClientInputAnalog)(int clientNum, WORD *analogs);
	void					(*LServ_InitPlayerObj)(int clientNum, const char *clientInfo);
	void					(*LServ_FreePlayerObj)(int clientNum);
	void					(*LServ_UpdateTime)(unsigned long time);
	void					(*LServ_InitMapObj)(const char *objName, float *pos, float *ang, const objArgs_t *args, int numArgs);
	void					(*LServ_PostMapSpawn)(void);
	void					(*LServ_ChangeMusic)(char *music);
	void					(*LServ_DevCommand)(char *cmd);
	void					(*LServ_ServerEvent)(int clientIndex, serverEventTypes_e ev, BYTE *data, int dataSize);
	void					(*LServ_MusicalReset)(const char *musicName);
	void					(*LServ_PhysicsImpact)(int objNum, int otherNum, const float *planeDir, const float *point);
	void					(*LServ_SaveGame)(const char *saveName, const char *modName);
	void					(*LServ_LoadGame)(const char *saveName);

	//math routines
	void					(*Math_CalcPlaneEq)(float *x, float *y, float *z, float *planeEq);
	float					(*Math_VecNorm2)(float *v);
	float					(*Math_VecNorm)(float *v);
	float					(*Math_PlaneNorm)(float *plane);
	float					(*Math_VecLen)(float *a);
	float					(*Math_PlaneDist)(const float *pl, const float *p);
	void					(*Math_ProjectOntoPlane)(const float *plane, const float *pos, float *out);
	void					(*Math_VecCopy)(float *a, float *out);
	void					(*Math_VecSub)(float *a, float *b, float *out);
	void					(*Math_VecAdd)(float *a, float *b, float *out);
	void					(*Math_VecScale)(float *a, float scale);
	float					(*Math_Max2)(float a, float b);
	float					(*Math_Max3)(float a, float b, float c);
	void					(*Math_TransformPointByMatrix)(modelMatrix_t *matrix, float *in, float *out);
	void					(*Math_TransformPointByMatrix3x3)(modelMatrix_t *matrix, float *in, float *out);
	void					(*Math_TransformPoint)(float *basePos, float *scale, float *eAngles, float *in, float *out);
	void					(*Math_VecMA)( float *veca, float scale, float *vecb, float *vecc);
	void					(*Math_VecToAngles)(const float *value1, float *angles);
	void					(*Math_TransformPoint2)(float *basePos, float *scale, float *eAngles, float *in, float *out);
	void					(*Math_MatrixInverse)(modelMatrix_t *in, modelMatrix_t *out);
	void					(*Math_MatrixMultiply)(modelMatrix_t *in, modelMatrix_t *in2, modelMatrix_t *out);
	void					(*Math_MatrixMultiply3x3)(modelMatrix_t *in, modelMatrix_t *in2, modelMatrix_t *out);
	void					(*Math_MatrixMultiply4x4)(fourxMatrix_t *in, fourxMatrix_t *in2, fourxMatrix_t *out);
	void					(*Math_RotateMatrix)(modelMatrix_t *mat, float ang, float x, float y, float z);
	void					(*Math_TranslateMatrix)(modelMatrix_t *mat, float *v);
	void					(*Math_AnglesToMat)(const float *incAngles, modelMatrix_t *mat);
	void					(*Math_CrossProduct)(const float *v1, const float *v2, float *cross);
	float					(*Math_DotProduct)(const float *v1, const float *v2);
	float					(*Math_AngleMod)(float angle);
	void					(*Math_InterpolateVector)(float *old, float *cur, float val, float tresh, float *out);
	float					(*Math_BlendAngle)(float in, float goal, float factor);
	float					(*Math_BlendAngleLinear)(float in, float goal, float amount);
	void					(*Math_AngleVectors)(float *angles, float *forward, float *right, float *up);
	void					(*Math_AxisForNormal)(float *normal, float *fwd, float *right, float *up);
	void					(*Math_LerpMatrices)(modelMatrix_t &preMat, modelMatrix_t &postMat, float lerpFrac, modelMatrix_t &outMat, bool nonUniform);
	void					(*Math_CreateMatrixFromOrientation)(float *origin, float *angles, modelMatrix_t *mat);
	void					(*Math_RotationMatrix)(float phi, int axis, modelMatrix_t *mat);
	bool					(*Math_BoxesOverlap)(float *mins1, float *maxs1, float *mins2, float *maxs2);
	void					(*Math_ExpandBounds)(float *baseMins, float *baseMaxs, float *mins, float *maxs);
	void					(*Math_CreateFrustum)(float fov, float *pos, float *ang, viewFrustum_t *out);
	void					(*Math_CreateFrustumForViewAxis)(float *pos, float *axis, viewFrustum_t *out, float fovX, float fovY, float zNear, float zFar);
	void					(*Math_GetFrustumPoints)(viewFrustum_t *frustum, float points[8][3], modelMatrix_t *frustMat);
	void					(*Math_BoundsFromPoints)(float *outMins, float *outMaxs, float *points, int numPoints);
	int						(*Math_PointRelativeToPlane)(float *pos, float *side, float *planeEq);
	void					(*Math_GetBoundsPoints)(float *mins, float *maxs, float *bp, float *baxis);
	bool					(*Math_PointInFrustum)(viewFrustum_t *frustum, float *point, float radius);
	int						(*Math_BoxInFrustum)(viewFrustum_t *frustum, float *mins, float *maxs);
	void					(*Math_MatToAngles)(float *angles, const modelMatrix_t *mat);
	void					(*Math_MatToAngles2)(float *angles, const modelMatrix_t *mat);

	//file system
	int						(*FileSys_OpenFile)(const char *filename, int mode1, int mode2);
	void					(*FileSys_CloseFile)(int handle);
	int						(*FileSys_GetLen)(int handle);
	bool					(*FileSys_ReadFile)(int handle, void *out, int len);
	bool					(*FileSys_WriteFile)(int handle, void *in, int len);
	bool					(*FileSys_Read)(int handle, void *out, int len);
	bool					(*FileSys_Write)(int handle, void *in, int len);
	char					*(*FileSys_GetFileList)(const char *searchPath, const char *searchType);

	//networking util
	void					(*Net_SendMessage)(const char *str);
	void					(*Net_SendEventType)(clientEventTypes_e eventType, void *data, int dataSize, int singleClient);
	int						(*Net_CreateDelta)(void *previous, void *current, int dataSize, BYTE *deltaOut, int deltaOutSize);
	void					(*Net_ParseDelta)(void *current, int dataSize, BYTE *deltaIn);

	//threading
	void					(*JT_DoJob)(void (*job)(void *userData), void *userData, jobHandle_t *jobHandle);
	bool					(*JT_JobDone)(jobHandle_t *jobHandle, bool stall);
	void					(*Thread_EnterCritical)(int critIndex);
	void					(*Thread_LeaveCritical)(int critIndex);

	//parsing
	textParser_t			*(*Parse_InitParser)(char *rawText);
	textParser_t			*(*Parse_InitParserFromFile)(const char *filename);
	void					(*Parse_FreeParser)(textParser_t *parser);
	void					(*Parse_EnableInclude)(textParser_t *parser, const char *includeKey);
	bool					(*Parse_GetNextToken)(textParser_t *parser, parseToken_t *parseToken);
	bool					(*Parse_WhiteSpace)(char chr);

	//containers
	cntArray_t				*(*Array_Alloc)(int elementSize, int initialNum);
	void					(*Array_Free)(cntArray_t *ar);
	void					(*Array_SetGrowth)(cntArray_t *ar, bool exponential);
	void					*(*Array_GetElement)(cntArray_t *ar, int index);
	void					*(*Array_GetElementGrow)(cntArray_t *ar, int index);
	void					(*Array_Append)(cntArray_t *ar, void *element);
	void					(*Array_RemoveLast)(cntArray_t *ar);
	void					(*Array_Insert)(cntArray_t *ar, void *element, int index);
	void					(*Array_Remove)(cntArray_t *ar, int index);
	int						(*Array_GetCount)(cntArray_t *ar);
	void					(*Array_Tighten)(cntArray_t *ar);
	unsigned int			(*Hash_GetKey)(unsigned char *data, int dataLen);
	cntHash_t				*(*Hash_Alloc)(int size);
	void					(*Hash_Free)(cntHash_t *hash);
	void					(*Hash_AddIndexedKey)(cntHash_t *hash, unsigned int key, int index);
	void					(*Hash_RemoveIndexedKey)(cntHash_t *hash, unsigned int key, int index);
	cntHashList_t			*(*Hash_GetKeyList)(cntHash_t *hash, unsigned int key);
	cntStream_t				*(*Stream_Alloc)(void *buffer, int size);
	void					(*Stream_Free)(cntStream_t *st);
	void					(*Stream_WriteBits)(cntStream_t *st, void *buf, int size);
	void					(*Stream_WriteBytes)(cntStream_t *st, void *buf, int size);
	bool					(*Stream_ReadBits)(cntStream_t *st, void *buf, int size);
	bool					(*Stream_ReadBytes)(cntStream_t *st, void *buf, int size);
	void					(*Stream_WriteBool)(cntStream_t *st, bool val);
	void					(*Stream_WriteInt)(cntStream_t *st, int val);
	void					(*Stream_WriteFloat)(cntStream_t *st, float val);
	void					(*Stream_WriteString)(cntStream_t *st, char *str);
	bool					(*Stream_ReadBool)(cntStream_t *st);
	int						(*Stream_ReadInt)(cntStream_t *st);
	float					(*Stream_ReadFloat)(cntStream_t *st);
	void					(*Stream_ReadString)(cntStream_t *st, char *str, int maxSize);
	void					*(*Stream_Buffer)(cntStream_t *st);
	int						(*Stream_Size)(cntStream_t *st);
	void					(*Stream_SetOffset)(cntStream_t *st, int offset);
	int						(*Stream_GetOffset)(cntStream_t *st);
	strHash_t				*(*SHash_Alloc)(int poolSize);
	void					(*SHash_Free)(strHash_t *s);
	int						(*SHash_Index)(strHash_t *s, char *str);
	char					*(*SHash_String)(strHash_t *s, int index);
	int						(*SHash_GetCount)(strHash_t *s);

	//engine utility functions
	//old - for tile mesh collision stuff
	bool					(*Common_Collide)(float *start, float *end, float *mins, float *maxs, int objIgnore, collObj_t *collision);

	//new collision routines

	//make sure a model (and optionally anim) is cached
	void					(*Coll_CacheModel)(const char *modelName, const char *animName);
	//register a collision model
	rcColModel_t			*(*Coll_RegisterModelInstance)(const char *modelName);
	//destroy a collision model
	void					(*Coll_DestroyModelInstance)(rcColModel_t *colModel);
	//update model from parameters, optionally attach an animation to a collision model
	void					(*Coll_UpdateModel)(rcColModel_t *colModel, const char *animName);
	//returns true if the model is a tree model
	bool					(*Coll_IsTreeModel)(rcColModel_t *colModel);
	//sets the view node on all tree models
	void					(*Coll_SetupVisibility)(float *viewPos);
	//checks visibility between two points, using all clipmodels with node trees
	bool					(*Coll_GeneralVisibility)(float *p1, float *p2, float p1Rad);
	//checks visibility between two points, using all clipmodels with node trees
	bool					(*Coll_GeneralVisibilityWithBounds)(float *p1, float *p2, float p1Rad, float *mins, float *maxs);
	//bounds sweep against a model - if other is non-null, only that model will be collided with.
	void					(*Coll_BoundsTranslation)(rcColModel_t *ownerModel, collObj_t *collision, float *start, float *end, float *mins, float *maxs, rcColModel_t *other, collOpt_t *opt);
	//radial line trace against a model - passing a radius of 0.0f will do a point trace instead. if other is non-null, only that model will be collided with.
	void					(*Coll_RadiusTranslation)(rcColModel_t *ownerModel, collObj_t *collision, float *start, float *end, float rad, rcColModel_t *other, collOpt_t *opt);
	//movement translation for the ownerModel, which may be box or sphere translations or a number of object-dependant types
	void					(*Coll_MovementTranslation)(rcColModel_t *ownerModel, collObj_t *collision, float *start, float *end, rcColModel_t *other, collOpt_t *opt);
	//gets an impact surface name from a collision
	const char				*(*Coll_GetHitTexName)(collObj_t *collision);
	//get the combined bounds of all clipmodels
	void					(*Coll_GetWorldBounds)(float *mins, float *maxs);
	//get a model's bone matrix, returns false if the bone was not found
	bool					(*Coll_GetModelBoneMatrix)(rcColModel_t *rcModel, const char *boneName, modelMatrix_t *mat);
	//set a bone override
	bool					(*Coll_SetBoneOverride)(rcColModel_t *rcModel, const char *boneName, modelMatrix_t *offsetMat, int offsetType, float lerpAmt, float *constraint, int centerAxis);

#ifdef _RC_NOVODEX
	void					(*Common_CreateNxActor)(void **nxActor, gameObjNet_t *netObj, const char *clipModel); //create novodex actor
	void					(*Common_FreeNxActor)(void *nxActor); //free novodex actor
	void					(*Common_UpdateFromNxActor)(void *nxActor, gameObjNet_t *netObj); //update from novodex actor
	void					(*Common_NxActorOverride)(void *nxActor, gameObjNet_t *netObj); //override novodex actor
	void					(*Common_NxFullCollision)(void *nxActor, int flags); //put novodex actor to sleep
	void					(*Common_NxActorForce)(void *nxActor, float *vel, float *ang, bool onGround); //add force to actor
	void					(*Common_NxLinkContact)(void *actor, void *other); //link nxactors for touching
	void					(*Common_NxRayTrace)(float *start, float *dir, collObj_t *collision, int ignoreObj); //call to novodex's raytrace function
	void					(*Common_RunPhysics)(float time); //runs a physics frame
#endif

	void					(*Common_QueryMusic)(float *amp, float *pos); //get music stats for musical mode
	void					*(*Common_RCMalloc)(unsigned int size); //malloc
	void					(*Common_RCFree)(void *ptr); //free
	unsigned long			(*Common_GetTime)(void); //returns time (milliseconds)
	void					(*Common_MapChange)(const char *map, unsigned long time); //changes the map (NULL restarts current)
	void					(*Common_SaveGameValues)(void *val, int gameValuesSize); //get the game values
	int						(*Common_ServerString)(const char *str); //gets an index to a server string (creates if none exist)
	char					*(*Common_ServerStringFromIndex)(int index); //gets string contents from an index
	int						(*Common_ServerStringPfx)(const char *str); //gets an index to a server string prefix (creates if none exist)
	bool					(*Common_ModifyString)(int stringIndex, char *newStr); //modify a server string by index
	void					(*Common_CacheModel)(const char *str); //precache a model
	BYTE *					(*Common_GetEntryForObject)(const char *objName); //get object definition
	const char *			(*Common_GetValForKey)(BYTE *aobj, const char *keyName); //get value for key from object def
	void					(*Common_SetValForKey)(BYTE *aobj, const char *keyName, const char *value); //set value for key in object def

} sharedSVFunctions_t;

#endif //_SHAREDFN_H
