/*
=============================================================================
Module Information
------------------
Name:			clmain.cpp
Author:			Rich Whitehouse
Description:	core client logic module implementation.
=============================================================================
*/

#include "clmain.h"

sharedCLFunctions_t *g_sharedCl;
clientObject_t *g_clientObjects;
clientString_t *g_clientStrings;
int g_clTouchBased = 0;
clientResources_t g_clRes;

clientGlobals_t g_clg;

const float g_angleBlendRate = 0.3f;//0.1f;
const float g_transBlendRate = 0.3f;

//return api version
int LCl_GetAPIVersion(void)
{
	return CL_LOGIC_API_VERSION;
}

//get local camera
clientObject_t *LCl_LocalCam(void)
{
	return &g_clientObjects[CAM_TRACK_NUM];
}

//set the render view
void LCl_SetViewPos(void)
{
	g_clg.viewAng[YAW] = 90.0f;
	g_clg.viewAng[PITCH] = 0.0f;
	g_clg.viewAng[ROLL] = 0.0f;
	//Math_VecCopy(g_clientObjects[g_clg.selfClientNum].projPos, g_clg.viewPos);
	g_clg.viewPos[0] = 0.0f;
	g_clg.viewPos[1] = 0.0f;
	g_clg.viewPos[2] = 0.0f;

	if (LCl_LocalCam()->active)
	{
		g_clg.viewPos[0] = LCl_LocalCam()->projPos[0];
		g_clg.viewPos[1] = LCl_LocalCam()->projPos[1];
		g_clg.viewPos[2] = LCl_LocalCam()->projPos[2];
		g_clg.viewAng[PITCH] += LCl_LocalCam()->projAng[PITCH];
		g_clg.viewAng[YAW] += LCl_LocalCam()->projAng[YAW];
		g_clg.viewAng[ROLL] += LCl_LocalCam()->projAng[ROLL];
	}

	if (g_clg.hudState.theShakes > 0.0f)
	{
		float r = (float)(rand()%16384)/16384.0f;
		g_clg.viewAng[PITCH] += (-g_clg.hudState.theShakes + g_clg.hudState.theShakes*2.0f*r);
		r = (float)(rand()%16384)/16384.0f;
		g_clg.viewAng[YAW] += (-g_clg.hudState.theShakes + g_clg.hudState.theShakes*2.0f*r);
		if (g_clg.hudState.shakeDec)
		{
			float timeDif = ((float)g_clg.gameTime-(float)g_clg.prvTime)/50.0f;
			g_clg.hudState.theShakes -= g_clg.hudState.shakeDec*timeDif;
			if (g_clg.hudState.theShakes < 0.0f)
			{
				g_clg.hudState.theShakes = 0.0f;
			}
		}
	}

	int x = 0;
	while (x < 3)
	{
		while (g_clg.viewAng[x] < 0.0f)
		{
			g_clg.viewAng[x] += 360.0f;
		}
		while (g_clg.viewAng[x] > 360.0f)
		{
			g_clg.viewAng[x] -= 360.0f;
		}
		x++;
	}
}

//decide position
void LCl_InterpolateObjectPos(clientObject_t *obj, bool clientInterpolate)
{
	if (clientInterpolate)
	{
		if (obj->net.index == LCl_LocalCam()->net.index)
		{
			Math_InterpolateVector(obj->projPos, obj->net.pos, g_transBlendRate*1.25f, 8192.0f, obj->obj.pos);
		}
		else
		{
			Math_InterpolateVector(obj->projPos, obj->net.pos, g_transBlendRate, 2048.0f, obj->obj.pos);
		}
	}
	else
	{
		Math_VecCopy(obj->net.pos, obj->obj.pos);
	}

	if (obj->net.type == OBJ_TYPE_PROJECTILE)
	{
		Math_VecCopy(obj->net.ang, obj->obj.ang);
	}
	else
	{
		if (clientInterpolate)
		{
			int i = 0;
			while (i < 3)
			{
				float ang = (360.0f / 65536) * ((int)(obj->net.ang[i] * (65536 / 360.0f)) & 65535);
				obj->obj.ang[i] = Math_BlendAngle(obj->projAng[i], ang, g_angleBlendRate);
				i++;
			}
		}
		else
		{
			Math_VecCopy(obj->net.ang, obj->obj.ang);
		}
	}

	Math_VecCopy(obj->obj.pos, obj->projPos);
	Math_VecCopy(obj->obj.ang, obj->projAng);
}

//cycle inventory
void LCl_InventoryCycle(int dir)
{
	if (g_clg.clientState.desiredItem <= -1)
	{
		return;
	}
	for (int i = g_clg.clientState.desiredItem+dir; 1; i += dir)
	{
		if (i >= MAX_PLAYER_INVENTORY_ITEMS)
		{
			i = 0;
		}
		else if (i < 0)
		{
			i = MAX_PLAYER_INVENTORY_ITEMS-1;
		}

		if (g_clg.clientState.localPl->inventory[i].itemQuantity > 0)
		{
			g_clg.clientState.desiredItem = i;
			break;
		}
	}
}

//frame
void LCl_Frame(unsigned long time, int numObj, int localCl, bool clientInterpolate,
			   bool isMulti, float musicFrac, float *viewPos, float *viewAng)
{
	g_clg.prvTime = g_clg.gameTime;
	g_clg.gameTime = time;
	if (!g_clg.prvTime)
	{
		g_clg.prvTime = time;
	}
	g_clg.viewPos = viewPos;
	g_clg.viewAng = viewAng;
	g_clg.numActiveGameObj = numObj;
	g_clg.selfClientNum = localCl;
	g_clg.clientState.localPl = (localCl >= 0) ? &g_clg.clientState.plData[localCl] : NULL;
	//g_musicFrac = musicFrac;

	if (g_clg.clientState.desiredItem == -1)
	{ //set initial desired item to the server's state
		clientObject_t *pl = (g_clg.numActiveGameObj > g_clg.selfClientNum && g_clientObjects[g_clg.selfClientNum].active) ? &g_clientObjects[g_clg.selfClientNum] : NULL;
		if (pl && pl->net.spare1 != 255)
		{
			g_clg.clientState.desiredItem = (pl->net.spare1&((1<<8)-1));
		}
	}
	else
	{
		if (g_clg.clientState.localPl->inventory[g_clg.clientState.desiredItem].itemQuantity <= 0)
		{ //ran out of the equipped item
			g_clg.clientState.desiredItem = 0;
		}
		else
		{
			static WORD lastAnalogs[5] = {32767, 32767, 32767, 32767, 32767};
			WORD analogs[5];
			g_sharedCl->DInput_GetAnalogs(analogs);
			if (lastAnalogs[4] > 20000 && lastAnalogs[4] < 44000 &&
				!(analogs[4] > 20000 && analogs[4] < 44000) &&
				!g_clg.hudState.hideHud)
			{ //pressing analog trigger
				int curItem = g_clg.clientState.desiredItem;
				if (analogs[4] > 32767)
				{
					LCl_InventoryCycle(-1);
				}
				else
				{
					LCl_InventoryCycle(1);
				}

				if (curItem != g_clg.clientState.desiredItem)
				{
					g_sharedCl->S_PlayWave(g_sharedCl->S_CacheSound("assets/sound/items/invcycle.wav"), NULL, 1.0f, false, -1, -1);
					g_clg.hudState.itemNameTime = g_clg.gameTime+2000;
				}
			}
			lastAnalogs[0] = analogs[0];
			lastAnalogs[1] = analogs[1];
			lastAnalogs[2] = analogs[2];
			lastAnalogs[3] = analogs[3];
			lastAnalogs[4] = analogs[4];
		}
	}

	g_sharedCl->Net_SetClientUserData((BYTE *)&g_clg.clientState.desiredItem, sizeof(int));

	clientObject_t *cam = (g_clg.numActiveGameObj > CAM_TRACK_NUM && LCl_LocalCam()->active) ? LCl_LocalCam() : NULL;

	/*
	if (cam && (cam->net.renderEffects2 & FXFL2_MUSICAL))
	{ //musical!
		g_musicalMode = true;
	}
	else
	{
		g_musicalMode = false;
	}
	*/

	int i = 0;
	while (i < g_clg.numActiveGameObj)
	{
		if (g_clientObjects[i].active)
		{
			LCl_InterpolateObjectPos(&g_clientObjects[i], clientInterpolate);
		}
		i++;
	}

	LCl_SetViewPos();

	g_sharedCl->Cl_AddAllObjects();

	if (g_clg.clientState.globalNet.skyboxModel > 0)
	{ //add a sky model
		char *skyModel = g_clientStrings[g_clg.clientState.globalNet.skyboxModel].p;
		if (skyModel[0] == '&')
		{
			skyModel++;
			if (!g_clg.clientState.skyModel || stricmp(skyModel, g_sharedCl->Model_GetName(g_clg.clientState.skyModel)))
			{
				if (g_clg.clientState.skyModel)
				{
					g_sharedCl->Model_Free(g_clg.clientState.skyModel);
				}
				g_clg.clientState.skyModel = g_sharedCl->Model_Allocate(skyModel);
			}

			char *skyTerrain = g_clientStrings[g_clg.clientState.globalNet.skyboxTerrain].p;
			if (skyTerrain[0] == '&')
			{
				skyTerrain++;
				if (!g_clg.clientState.skyTerrain || stricmp(skyTerrain, g_sharedCl->Model_GetName(g_clg.clientState.skyTerrain)))
				{
					if (g_clg.clientState.skyTerrain)
					{
						g_sharedCl->Model_Free(g_clg.clientState.skyTerrain);
					}
					g_clg.clientState.skyTerrain = g_sharedCl->Model_Allocate(skyTerrain);
				}
			}
			if (g_clg.clientState.globalNet.skyboxTerrain && g_clg.clientState.skyTerrain)
			{
				drawObject_t dobj;
				memset(&dobj, 0, sizeof(dobj));
				dobj.ang[0] = 0.0f;
				dobj.ang[1] = 180.0f;
				dobj.ang[2] = 0.0f;
				dobj.modelScale[0] = 2.5f;
				dobj.modelScale[1] = 2.5f;
				dobj.modelScale[2] = 2.5f;
				dobj.pos[0] = (g_clg.viewPos[0]-2000.0f) - g_clg.viewPos[0]*0.1f;
				dobj.pos[1] = (g_clg.viewPos[1]-4000.0f) - g_clg.viewPos[1]*0.1f;
				dobj.pos[2] = (g_clg.viewPos[2]-400.0f) - g_clg.viewPos[2]*0.1f;
				dobj.model = g_clg.clientState.skyTerrain;

				g_sharedCl->GL_AddSkyObject(&dobj);
			}
			drawObject_t dobj;
			memset(&dobj, 0, sizeof(dobj));
			dobj.ang[0] = 0.0f;
			dobj.ang[1] = 0.0f;
			dobj.ang[2] = 0.0f;
			if (g_clg.clientState.globalNet.skyboxTerrain)
			{
				dobj.modelScale[0] = 1.5f;
				dobj.modelScale[1] = 1.5f;
				dobj.modelScale[2] = 1.5f;
				dobj.pos[0] = g_clg.viewPos[0] - g_clg.viewPos[0]*0.05f;
				dobj.pos[1] = g_clg.viewPos[1] - g_clg.viewPos[1]*0.05f;
				dobj.pos[2] = g_clg.viewPos[2] - g_clg.viewPos[2]*0.05f;
			}
			else
			{
				dobj.pos[0] = g_clg.viewPos[0] - g_clg.viewPos[0]*0.1f;
				dobj.pos[1] = g_clg.viewPos[1] - g_clg.viewPos[1]*0.1f;
				dobj.pos[2] = g_clg.viewPos[2] - g_clg.viewPos[2]*0.1f;
			}
			dobj.model = g_clg.clientState.skyModel;

			if (g_clg.clientState.globalNet.skyboxColor[0] ||
				g_clg.clientState.globalNet.skyboxColor[1] ||
				g_clg.clientState.globalNet.skyboxColor[2])
			{
				dobj.blendSrc = 2;
				dobj.blendDst = 2;
				dobj.blendRGBA[0] = g_clg.clientState.globalNet.skyboxColor[0];
				dobj.blendRGBA[1] = g_clg.clientState.globalNet.skyboxColor[1];
				dobj.blendRGBA[2] = g_clg.clientState.globalNet.skyboxColor[2];
				dobj.blendRGBA[3] = 1.0f;
			}

			g_sharedCl->GL_AddSkyObject(&dobj);
		}
	}
}

//draw hud and other game-specific elements
void LCl_Draw2D(viewFrustum_t *viewFrust)
{
	LCl_DrawHudElements(viewFrust);
}

//draw post-menu
void LCl_DrawPostMenu(viewFrustum_t *viewFrust)
{
	clientObject_t *obj = &g_clientObjects[0]; //g_clg.selfClientNum
	if (obj->active && g_sharedCl->Menu_AnyActiveMenus())
	{
		g_clg.hudState.lastMakoStash = g_clg.clientState.makoStash;
		g_clg.hudState.makoShowTime = g_clg.gameTime + 1000;
		g_clg.hudState.makoStrength = 0.25f;
		LCl_DrawHudMakoStash(g_clg.clientState.makoStash);
	}
}

//load resources
void LCl_CacheResources(void)
{
	g_sharedCl->Img_TextureLoad("assets/textures/test_white", &g_clRes.whiteTex);
	g_sharedCl->Img_TextureLoad("assets/textures/trail01", &g_clRes.trailTex);
	g_sharedCl->Img_TextureLoad("assets/textures/lstream", &g_clRes.streamTex);
	g_sharedCl->Img_TextureLoad("assets/textures/goop", &g_clRes.spawnGoo);
	g_sharedCl->Img_TextureLoad("assets/textures/targptr", &g_clRes.targTex);
	g_sharedCl->Img_TextureLoad("assets/textures/targptr2", &g_clRes.targTex2);
	g_sharedCl->Img_TextureLoad("assets/textures/confuse", &g_clRes.confuseTex);
	g_sharedCl->Img_TextureLoad("assets/textures/brightcoreglow", &g_clRes.coreTex);
	g_sharedCl->Img_TextureLoad("assets/textures/beamcore", &g_clRes.beamCoreTex);
	g_sharedCl->Img_TextureLoad("assets/textures/specshell", &g_clRes.specShellTex);
	g_sharedCl->Img_TextureLoad("assets/textures/specshell2", &g_clRes.specShell2Tex);
	g_sharedCl->Img_TextureLoad("assets/textures/specshell3", &g_clRes.specShell3Tex);
	g_sharedCl->Img_TextureLoad("assets/textures/holyjustice", &g_clRes.holyJustice);

	g_sharedCl->Img_TextureLoad("assets/textures/hud/knucklepiece", &g_clRes.hudKnuckle);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/knucklepieceglow", &g_clRes.hudKnuckleGlow);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifepiece", &g_clRes.hudLifePiece);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifepieceglow", &g_clRes.hudLifePieceGlow);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifechunk", &g_clRes.hudLifeChunk);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifechunkglow", &g_clRes.hudLifeChunkGlow);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifeend", &g_clRes.hudLifeEnd);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifeendglow", &g_clRes.hudLifeEndGlow);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifesliver", &g_clRes.hudLifeSliver);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/lifesliver2", &g_clRes.hudLifeSliver2);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/chargesphere", &g_clRes.hudChargeSphere);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/mako1", &g_clRes.hudMako1);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/mako2", &g_clRes.hudMako2);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/makoglow", &g_clRes.hudMakoGlow);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/chargemeter", &g_clRes.hudChargeMeter);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/chargemeterglow", &g_clRes.hudChargeMeterGlow);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/bar", &g_clRes.hudBar);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/p2ico", &g_clRes.hudP2Icon);
	g_sharedCl->Img_TextureLoad("assets/menus/textures/menubg1", &g_clRes.talkBubbleBack);

	g_sharedCl->Img_TextureLoad("button_stick", &g_clRes.buttonStick);
	g_sharedCl->Img_TextureLoad("button_pad", &g_clRes.buttonPad);
	g_sharedCl->Img_TextureLoad("button_p", &g_clRes.buttonP);
	g_sharedCl->Img_TextureLoad("button_k", &g_clRes.buttonK);
	g_sharedCl->Img_TextureLoad("button_j", &g_clRes.buttonJ);
	g_sharedCl->Img_TextureLoad("button_i", &g_clRes.buttonI);
	g_sharedCl->Img_TextureLoad("button_c", &g_clRes.buttonC);
	g_sharedCl->Img_TextureLoad("button_t", &g_clRes.buttonT);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/menubutton", &g_clRes.buttonMenu);
	g_sharedCl->Img_TextureLoad("assets/textures/hud/menubutton_down", &g_clRes.buttonMenuDown);

	for (int i = 0; i < NUM_INVENTORY_ITEM_DEFS; i++)
	{
		const invItemDef_t *item = &g_invItems[i];
		if (item->icon && item->icon[0])
		{
			g_sharedCl->Img_TextureLoad(item->icon, &g_clRes.invItemIcons[i]);
		}
	}

	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/makodeath", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/energydeath", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/makopower", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/flameaura", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/boneaura", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/healingaura", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/invinaura", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/drainaura", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/itemsparkle", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/phoenix", NULL);
	g_sharedCl->ClPcl_CacheParticleSystemAssets("general/aurafist", NULL);

	if (g_clTouchBased)
	{
		g_sharedCl->Img_TextureLoad("assets/textures/hud/stick_base", &g_clRes.touchStickBase);
		g_sharedCl->Img_TextureLoad("assets/textures/hud/stick_top", &g_clRes.touchStickTop);
		g_sharedCl->Img_TextureLoad("assets/textures/hud/stick_glow", &g_clRes.touchStickGlow);
	}

	g_sharedCl->S_CacheSound("assets/sound/menu/menuerr.wav");
	g_sharedCl->S_CacheSound("assets/sound/items/invcycle.wav");
}

//can i pause?
bool LCl_CanPause(void)
{
	if (g_clg.hudState.hideHud)
	{
		return false;
	}
	return true;
}

//module init
int LCl_Initialize(sharedCLFunctions_t *sharedFunc, clientObject_t *clientObjects, clientString_t *clientStrings)
{
	g_sharedCl = sharedFunc;
	g_clientObjects = clientObjects;
	g_clientStrings = clientStrings;

	g_sharedCl->LCl_Frame = LCl_Frame;
	g_sharedCl->LCl_Draw2D = LCl_Draw2D;
	g_sharedCl->LCl_DrawPostMenu = LCl_DrawPostMenu;
	g_sharedCl->LCl_CanPause = LCl_CanPause;
	g_sharedCl->LCl_CacheResources = LCl_CacheResources;
	g_sharedCl->LCl_NetEvent = LCl_NetEvent;
	g_sharedCl->LCl_FreshClientObject = LCl_FreshClientObject;
	g_sharedCl->LCl_UserMenu = LCl_UserMenu;
	g_sharedCl->LCl_UserSort = LCl_UserSort;

	g_sharedCl->Cl_GetEnOp(ENOP_TOUCHBASED, &g_clTouchBased);

	sharedInterface_t si;
	si.Parse_InitParser = g_sharedCl->Parse_InitParser;
	si.Parse_InitParserFromFile = g_sharedCl->Parse_InitParserFromFile;
	si.Parse_FreeParser = g_sharedCl->Parse_FreeParser;
	si.Parse_EnableInclude = g_sharedCl->Parse_EnableInclude;
	si.Parse_GetNextToken = g_sharedCl->Parse_GetNextToken;
	Shared_LoadUserItems(&si);

	memset(&g_clg, 0, sizeof(g_clg));
	g_clg.clientState.localPl = &g_clg.clientState.plData[0];
	g_clg.clientState.desiredItem = -1;

	return 1;
}

//module shutdown
void LCl_Shutdown(void)
{
}
