#ifndef _CLMAIN_H
#define _CLMAIN_H

#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <math.h>
#include <assert.h>
#include "../logicsv_ava/sharedtypes.h"
#include "clshared.h"

extern sharedCLFunctions_t *g_sharedCl;
extern clientObject_t *g_clientObjects;
extern clientString_t *g_clientStrings;
extern int g_clTouchBased;

typedef struct clientResources_s
{
	texContainer_t			whiteTex;
	texContainer_t			trailTex;
	texContainer_t			streamTex;
	texContainer_t			spawnGoo;
	texContainer_t			targTex;
	texContainer_t			targTex2;
	texContainer_t			confuseTex;
	texContainer_t			coreTex;
	texContainer_t			beamCoreTex;
	texContainer_t			specShellTex;
	texContainer_t			specShell2Tex;
	texContainer_t			specShell3Tex;
	texContainer_t			holyJustice;

	texContainer_t			hudKnuckle;
	texContainer_t			hudKnuckleGlow;
	texContainer_t			hudLifePiece;
	texContainer_t			hudLifePieceGlow;
	texContainer_t			hudLifeChunk;
	texContainer_t			hudLifeChunkGlow;
	texContainer_t			hudLifeEnd;
	texContainer_t			hudLifeEndGlow;
	texContainer_t			hudLifeSliver;
	texContainer_t			hudLifeSliver2;
	texContainer_t			hudChargeSphere;
	texContainer_t			hudMako1;
	texContainer_t			hudMako2;
	texContainer_t			hudMakoGlow;
	texContainer_t			hudChargeMeter;
	texContainer_t			hudChargeMeterGlow;
	texContainer_t			hudBar;
	texContainer_t			hudP2Icon;

	texContainer_t			talkBubbleBack;

	texContainer_t			buttonStick;
	texContainer_t			buttonPad;
	texContainer_t			buttonP;
	texContainer_t			buttonK;
	texContainer_t			buttonJ;
	texContainer_t			buttonI;
	texContainer_t			buttonC;
	texContainer_t			buttonT;
	texContainer_t			buttonMenu;
	texContainer_t			buttonMenuDown;

	texContainer_t			touchStickBase;
	texContainer_t			touchStickTop;
	texContainer_t			touchStickGlow;

	texContainer_t			invItemIcons[NUM_INVENTORY_ITEM_DEFS];
} clientResources_t;
extern clientResources_t g_clRes;

#define	HUD_STATUS_DEFAULT_DURATION		3000
#define MAX_HUD_STATUS_MSG				6
typedef struct hudStatusMsg_s
{
	char			str[256];
	unsigned long	time;

	float			idealX;
	float			idealY;
	float			curX;
	float			curY;
} hudStatusMsg_t;

#define MAX_TALK_BUBBLES				8
typedef struct talkBubble_s
{
	int				objIndex;
	char			talkName[256];
	char			talkText[256];
	unsigned long	time;
	bool			indef;
	float			scale;
	float			distToPlane;
} talkBubble_t;

typedef struct hudState_s
{
	bool			hideHud;

	int				healthRed;
	int				lastMakoStash;
	unsigned long	makoShowTime;
	float			makoStrength;
	float			chargeAlpha;
	int				lastMakoChargeCount;
	float			makoChargeStrength[4];
	int				lastHealth;
	int				lastMaxHealth;
	int				lastMakoChargeCountMax;
	int				lastEquippedItem;

	float			screenFade;
	float			screenFadeColor[3];
	float			screenPicFade;
	texContainer_t	screenPic;

	float			theShakes;
	float			shakeDec;

	const char		*enemyHealthName;
	float			enemyHealthFrac;
	float			enemyHealthFade;
	unsigned long	enemyHealthTime;

	unsigned long	itemNameTime;

	hudStatusMsg_t	statusMessages[MAX_HUD_STATUS_MSG];
	talkBubble_t	talkBubbles[MAX_TALK_BUBBLES];
	char			errorMessage[256];
} hudState_t;
extern hudState_t g_hudState;

typedef struct clientState_s
{
	int				desiredItem;
	int				makoStash;
	unsigned long	makoStashUpdateTime;
	CSafeModelPtr	*skyModel;
	CSafeModelPtr	*skyTerrain;
	playerData_t	plData[MAX_NET_CLIENTS];
	playerData_t	*localPl;
	globalNetData_t	globalNet;
} clientState_t;

typedef struct clientGlobals_s
{
	unsigned long		gameTime;
	unsigned long		prvTime;
	int					numActiveGameObj;
	int					selfClientNum;
	float				*viewPos;
	float				*viewAng;

	clientState_t		clientState;
	hudState_t			hudState;
} clientGlobals_t;
extern clientGlobals_t g_clg;

//for convenience
#define Math_CalcPlaneEq						g_sharedCl->Math_CalcPlaneEq
#define Math_VecNorm2							g_sharedCl->Math_VecNorm2
#define Math_VecNorm							g_sharedCl->Math_VecNorm
#define Math_PlaneNorm							g_sharedCl->Math_PlaneNorm
#define Math_VecLen								g_sharedCl->Math_VecLen
#define Math_PlaneDist							g_sharedCl->Math_PlaneDist
#define Math_ProjectOntoPlane					g_sharedCl->Math_ProjectOntoPlane
#define Math_VecCopy							g_sharedCl->Math_VecCopy
#define Math_VecSub								g_sharedCl->Math_VecSub
#define Math_VecAdd								g_sharedCl->Math_VecAdd
#define Math_VecScale							g_sharedCl->Math_VecScale
#define Math_Max2								g_sharedCl->Math_Max2
#define Math_Max3								g_sharedCl->Math_Max3
#define Math_TransformPointByMatrix				g_sharedCl->Math_TransformPointByMatrix
#define Math_TransformPointByMatrix3x3			g_sharedCl->Math_TransformPointByMatrix3x3
#define Math_TransformPoint						g_sharedCl->Math_TransformPoint
#define Math_VecMA								g_sharedCl->Math_VecMA
#define Math_VecToAngles						g_sharedCl->Math_VecToAngles
#define Math_TransformPoint2					g_sharedCl->Math_TransformPoint2
#define Math_MatrixInverse						g_sharedCl->Math_MatrixInverse
#define Math_MatrixMultiply						g_sharedCl->Math_MatrixMultiply
#define Math_MatrixMultiply3x3					g_sharedCl->Math_MatrixMultiply3x3
#define Math_MatrixMultiply4x4					g_sharedCl->Math_MatrixMultiply4x4
#define Math_RotateMatrix						g_sharedCl->Math_RotateMatrix
#define Math_TranslateMatrix					g_sharedCl->Math_TranslateMatrix
#define Math_AnglesToMat						g_sharedCl->Math_AnglesToMat
#define Math_CrossProduct						g_sharedCl->Math_CrossProduct
#define Math_DotProduct							g_sharedCl->Math_DotProduct
#define Math_AngleMod							g_sharedCl->Math_AngleMod
#define Math_InterpolateVector					g_sharedCl->Math_InterpolateVector
#define Math_BlendAngle							g_sharedCl->Math_BlendAngle
#define Math_BlendAngleLinear					g_sharedCl->Math_BlendAngleLinear
#define Math_AngleVectors						g_sharedCl->Math_AngleVectors
#define Math_AxisForNormal						g_sharedCl->Math_AxisForNormal
#define Math_LerpMatrices						g_sharedCl->Math_LerpMatrices
#define Math_CreateMatrixFromOrientation		g_sharedCl->Math_CreateMatrixFromOrientation
#define Math_RotationMatrix						g_sharedCl->Math_RotationMatrix
#define Math_BoxesOverlap						g_sharedCl->Math_BoxesOverlap
#define Math_ExpandBounds						g_sharedCl->Math_ExpandBounds
#define Math_CreateFrustum						g_sharedCl->Math_CreateFrustum
#define Math_CreateFrustumForViewAxis			g_sharedCl->Math_CreateFrustumForViewAxis
#define Math_GetFrustumPoints					g_sharedCl->Math_GetFrustumPoints
#define Math_BoundsFromPoints					g_sharedCl->Math_BoundsFromPoints
#define Math_PointRelativeToPlane				g_sharedCl->Math_PointRelativeToPlane
#define Math_GetBoundsPoints					g_sharedCl->Math_GetBoundsPoints
#define Math_PointInFrustum						g_sharedCl->Math_PointInFrustum
#define Math_BoxInFrustum						g_sharedCl->Math_BoxInFrustum
#define Math_MatToAngles						g_sharedCl->Math_MatToAngles
#define Math_MatToAngles2						g_sharedCl->Math_MatToAngles2

#define RGL_Enable								g_sharedCl->RGL_Enable
#define RGL_Disable								g_sharedCl->RGL_Disable
#define RGL_BlendFunc							g_sharedCl->RGL_BlendFunc

//cldraw.cpp
extern void LCl_UpdateEnemyHealth(int health, int maxHealth, const aiDesc_t *aiDesc);
extern void LCl_AddTalkBubble(int objIndex, char *talkName, char *talkText, unsigned long duration);
extern void LCl_AddStatusMessage(const char *msg, unsigned long duration = HUD_STATUS_DEFAULT_DURATION);
extern void LCl_DrawHudMakoStash(int makoStash);
extern void LCl_DrawHudElements(viewFrustum_t *viewFrust);

//clevents.cpp
extern void LCl_NetEvent(clientEventTypes_e e, BYTE *data, int dataSize);
extern void LCl_FreshClientObject(clientObject_t *obj);

//clmain.cpp
extern clientObject_t *LCl_LocalCam(void);

//clmenus.cpp
extern void LCl_UpdateStatMenu(void);
extern void LCl_UserMenu(const char *callName, mscriptNode_t *node, menuScript_t *mscript);
extern bool LCl_UserSort(const char *sortName, menu_t *menu);

#endif //_CLMAIN_H
