#define MAX_AI_DAMAGE_BONES		16

typedef struct aiChoiceNode_s aiChoiceNode_t;
typedef struct aiPathNode_s aiPathNode_t;

typedef struct aiPathNode_s
{
	float			pos[3];
	float			len;
	aiPathNode_t	*next;
} aiPathNode_t;

typedef struct aiPath_s
{
	aiPathNode_t		*nodes;
	int					userCount;
} aiPath_t;

#define AI_CHOICENODE_X_NEG		0
#define AI_CHOICENODE_X_POS		1
#define AI_CHOICENODE_Y_NEG		2
#define AI_CHOICENODE_Y_POS		3
typedef struct aiChoiceNode_s
{
	float			pos[3];
	float			weight;
	float			distToDest;
	aiChoiceNode_t	*neighbors[4];
} aiChoiceNode_t;

typedef struct aiObject_s
{
	int					maxHealth;
	float				moveSpeed;
	float				lookYaw;
	float				lookPitch;
	bool				fly;
	int					painChance;
	float				forceGravity;

	float				combatRange;
	float				goalRange;
	float				goalPos[3];
	gameObject_t		*goalObj;
	float				distToGoal;

	serverTime_t		obstructTime;

	int					makoValue;
	int					aiLevel;

	float				aiFov;
	float				aiRange;

	gameObject_t		*scriptGoal;
	gameObject_t		*scriptLookGoal;
	float				scriptGoalRange;

	aiPath_t			*path;
	aiPathNode_t		*pathNode;
	serverTime_t		pathCheckTime;

	gameObject_t		*enemy;
	float				distToEnemy;
	serverTime_t		attackTime;
	serverTime_t		noMoveTime;
	serverTime_t		confuseTime;

	char				*swordBone;
	float				swordOfs[3];

	dmgBoneLine_t		lastDmg[MAX_AI_DAMAGE_BONES];
	bool				hasLastDmg;
	int					*dmgSounds;
	int					numDmgSounds;
	char				*dmgEffect;

	bool				nonActive;

	serverTime_t		boneDmgTime;
	float				boneDmgDir[3];

	BYTE				dropChances[NUM_INVENTORY_ITEM_DEFS];
} aiObject_t;

//ai_anim.cpp
extern void AI_StartAnim(gameObject_t *obj, int anim, bool restart, bool transitional = false);
extern void AI_PickAnim(gameObject_t *obj, float timeMod);
extern bool AI_NonAnglingAnim(gameObject_t *obj);
extern bool AI_NonMovingAnim(gameObject_t *obj);
extern bool AI_AnglesForAnim(gameObject_t *obj, float *ang);
extern void AI_PainAnim(gameObject_t *obj, const collObj_t *col);
extern bool AI_ApplyAnimationVelocity(gameObject_t *obj, float timeMod);
extern void AI_ApplyAnimationEffects(gameObject_t *obj, float timeMod);

//ai_combat.cpp
extern int AI_LevelDamage(gameObject_t *obj, int dmg);
extern void AI_TransformDamageBones(gameObject_t *obj, damageBone_t *damageBones, dmgBoneLine_t *dmgPos, int numDamageBones);
extern int AI_RunDamageBone(gameObject_t *obj, damageBone_t *dmgBone, dmgBoneLine_t *linePrev, dmgBoneLine_t *lineCur, int dmg);

//ai_logic.cpp
extern void AI_GlobalFrame(void);
extern bool AI_ShouldCloseIn(gameObject_t *obj);
extern bool AI_FacingEnemy(gameObject_t *obj, gameObject_t *other, float minDot = 0.5f);
extern void AI_GetToGoal(gameObject_t *obj, float timeMod);
extern bool AI_ValidateEnemy(gameObject_t *obj, gameObject_t *other);
extern gameObject_t *AI_GetEnemy(gameObject_t *obj);
extern void AI_StandardGoals(gameObject_t *obj, float timeMod);

//ai_nav.cpp
extern float AI_GroundDistance(gameObject_t *obj, float *pos, float *groundPos);
extern bool AI_CanReachPoint(gameObject_t *obj, float *pos, gameObject_t *ignore);
extern aiPathNode_t *AI_ClosestPathNode(gameObject_t *obj, float *pos, aiPath_t *path);
extern aiPath_t *AI_ChartPath(gameObject_t *obj, float *dst);
extern void AI_FreePath(aiPath_t *path);
extern void AI_Move(gameObject_t *obj, float timeMod, float *moveVec, bool cancelObstructed = false);
extern aiPath_t *AI_BorrowPath(gameObject_t *obj, float *dst);

//ai_obj.cpp
extern void AI_FreeAIObject(aiObject_t *aiObj);
extern float AI_GetGravity(gameObject_t *obj, float timeMod);
extern bool AI_PainAnimChance(gameObject_t *obj);
extern void AI_GenericPain(gameObject_t *obj, gameObject_t *hurter, int dmg, const collObj_t *col);
extern void AI_CheckEffects(gameObject_t *obj, float timeMod);
extern void AI_SetGroundDistance(gameObject_t *obj);
extern bool AI_ShouldThink(gameObject_t *obj);
extern void AI_GenericThink(gameObject_t *obj, float timeMod);
extern void AI_GenericTouch(gameObject_t *obj, gameObject_t *other, const collObj_t *col);
extern void AI_DropMako(gameObject_t *obj, float timeMod);
extern void AI_DropItem(gameObject_t *obj, float timeMod);
extern void AI_ImmortalDeath(gameObject_t *obj, gameObject_t *killer, int dmg);
extern void AI_DeathRoutines(gameObject_t *obj, gameObject_t *killer, int dmg);
extern void AI_GenericDeath(gameObject_t *obj, gameObject_t *killer, int dmg);
extern void AI_GenericSpawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs);
