/*
=============================================================================
Module Information
------------------
Name:			obj_itemdrop.cpp
Author:			Rich Whitehouse
Description:	dropped item spheres
=============================================================================
*/

#include "main.h"

//think
void ObjItemDrop_Think(gameObject_t *obj, float timeMod)
{
	gameObject_t *pl = &g_gameObjects[0];
	float up[3] = {-90.0f, 0.0f, 0.0f};
	if (obj->makoCount && pl->inuse && pl->health > 0 && pl->plObj && (pl->hurtable || pl->plObj->ride))
	{ //makoCount is an index to the inventory item held within
		float c[3], d[3];
		modelMatrix_t boneMat;
		if (g_sharedFn->Coll_GetModelBoneMatrix(pl->rcColModel, "b1", &boneMat))
		{
			Math_VecCopy(boneMat.o, c);
		}
		else
		{
			Util_GameObjectCenter(pl, c);
		}
		Math_VecSub(c, obj->net.pos, d);
		float l = Math_VecLen(d);
		if (l < 1400.0f)
		{
			float moveSpeed = (1401.0f-l)*0.5f;
			if (moveSpeed > 256.0f)
			{
				moveSpeed = 256.0f;
			}
			if (Phys_LinearMove(obj, c, moveSpeed*timeMod))
			{
				if (obj->str1)
				{ //set gvar
					GVar_SetInt(obj->str1, 1);
				}

				obj->net.renderEffects |= FXFL_HIDDEN;
				obj->think = ObjGeneral_RemoveThink;
				obj->thinkTime = g_glb.gameTime+2000;
				ObjParticles_Create("general/itempickup", obj->net.pos, up, -1);
				//give item
				if (Shared_CanHaveItem(&pl->plObj->plData, obj->makoCount))
				{
					ObjPlayer_GiveItem(pl, obj->makoCount);
					ObjSound_Create(obj->net.pos, "assets/sound/items/itempickup.wav", 1.0f, -1);
				}
				else
				{
					const invItemDef_t *item = &g_invItems[obj->makoCount];
					Util_StatusMessage("*$%s$%s *(1 1 1 1)(full)", item->icon, item->name);
					ObjSound_Create(obj->net.pos, "assets/sound/cb/makopop.wav", 1.0f, -1);
				}
			}
		}
	}

	if (obj->debounce2 < g_glb.gameTime)
	{
		gameObject_t *cam = Util_GetCam(0);
		if (g_sharedFn->Coll_GeneralVisibilityWithBounds(obj->net.pos, cam->net.pos, obj->radius, obj->spawnMins, obj->spawnMaxs))
		{
			float p[3] = {-4.0f, 0.0f, 0.0f};
			ObjParticles_Create("general/droppeditem", p, up, obj->net.index);
		}
		obj->debounce2 = g_glb.gameTime+100;
	}

	obj->thinkTime = g_glb.gameTime;
	if (obj->debounce && obj->debounce < g_glb.gameTime)
	{
		ObjParticles_Create("general/itemfade", obj->net.pos, up, -1);
		obj->net.renderEffects |= FXFL_HIDDEN;
		obj->thinkTime = g_glb.gameTime+2000;
		obj->think = ObjGeneral_RemoveThink;
	}
}

//spawn
void ObjItemDrop_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	bool preplaced = false;
	for (int i = 0; i < numArgs; i++)
	{
		const objArgs_t *arg = args+i;
		if (!stricmp(arg->key, "item"))
		{
			for (int j = 0; j < NUM_INVENTORY_ITEM_DEFS; j++)
			{
				const invItemDef_t *item = &g_invItems[j];
				if (item->name && !stricmp(item->name, arg->val))
				{
					obj->makoCount = j;
					break;
				}
			}
			preplaced = true;
		}
		else if (!stricmp(arg->key, "gvar"))
		{
			obj->str1 = arg->val;
		}
	}

	float up[3] = {-90.0f, 0.0f, 0.0f};
	if (!preplaced)
	{
		ObjParticles_Create("general/itemfade", obj->net.pos, up, -1);
		ObjSound_Create(obj->net.pos, "assets/sound/items/itempop.wav", 1.0f, -1);
		obj->debounce = g_glb.gameTime + 10000;
	}
	obj->net.modelScale[0] = 0.1f;
	obj->net.modelScale[1] = 0.1f;
	obj->net.modelScale[2] = 0.1f;
	obj->think = ObjItemDrop_Think;

	if (obj->str1)
	{ //don't spawn if the associated gvar is set
		if (GVar_GetInt(obj->str1) > 0)
		{
			obj->think = ObjGeneral_RemoveThink;
		}
	}
}
