/*
=============================================================================
Module Information
------------------
Name:			obj_jenova.cpp
Author:			Rich Whitehouse
Description:	server logic object: jenova
=============================================================================
*/

#include "main.h"
#include "ai.h"

typedef enum
{
	JENOANIM_PREPARE_SUCK = NUM_HUMAN_ANIMS,
	JENOANIM_SUCK,
	JENOANIM_SLAP,
	JENOANIM_CIN_IDLE_1,
	NUM_JENO_ANIMS
} jenovaAnims_e;

static gameAnim_t g_jenovaAnims[NUM_JENO_ANIMS] =
{
	{0, 35, 68.0f, true},			//HUMANIM_IDLE
	{0, 35, 168.0f, true},			//HUMANIM_WALK
	{0, 35, 118.0f, true},			//HUMANIM_RUNSLOW
	{0, 35, 68.0f, true},			//HUMANIM_RUN
	{0, 2, 68.0f, false},			//HUMANIM_JUMP
	{0, 2, 68.0f, false},			//HUMANIM_FALL
	{0, 2, 68.0f, false},			//HUMANIM_LAND
	{36, 44, 68.0f, false},			//HUMANIM_PAIN_HIGH1
	{36, 44, 68.0f, false},			//HUMANIM_PAIN_HIGH2
	{36, 44, 68.0f, false},			//HUMANIM_PAIN_LOW1
	{36, 44, 68.0f, false},			//HUMANIM_PAIN_LOW2
	{36, 44, 68.0f, false},			//HUMANIM_PAIN_AIR
	{36, 44, 68.0f, false},			//HUMANIM_PAIN_POPUP
	{0, 4, 68.0f, false},			//HUMANIM_GETUP_BACK
	{0, 4, 68.0f, false},			//HUMANIM_GETUP_FRONT
	{0, 4, 68.0f, false},			//HUMANIM_FLYBACK
	{0, 4, 68.0f, false},			//HUMANIM_FLYBACK2
	{0, 4, 68.0f, false},			//HUMANIM_HIT_FALLFORWARD
	{0, 4, 68.0f, false},			//HUMANIM_FALL_LAND
	{0, 4, 68.0f, false},			//HUMANIM_POPUP_LAND
	{172, 172, 2568.0f, false},		//HUMANIM_DEATH
	{46, 62, 68.0f, true},			//JENOANIM_PREPARE_SUCK
	{63, 116, 68.0f, true},			//JENOANIM_SUCK
	{119, 164, 68.0f, true},		//JENOANIM_SLAP
	{0, 35, 68.0f, true}			//JENOANIM_CIN_IDLE_1
};

static scriptableAnim_t g_jenovaScriptAnims[] =
{
	DEF_SCRIPT_ANIM(HUMANIM_IDLE),
	{0, NULL}
};

typedef enum
{
	JENBONE_LTENT_1,
	JENBONE_LTENT_2,
	JENBONE_LTENT_3,
	JENBONE_LTENT_4,
	JENBONE_LTENT_5,
	JENBONE_RTENT_1,
	JENBONE_RTENT_2,
	JENBONE_RTENT_3,
	JENBONE_RTENT_4,
	JENBONE_RTENT_5,
	NUM_JENOVA_DAMAGE_BONES
} jenovaDamageBone_e;
const float g_jenBoneRad = 256.0f;
static damageBone_t g_jenovaDamageBones[NUM_JENOVA_DAMAGE_BONES] =
{
	{"b8", "b7", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},			//JENBONE_LTENT_1
	{"b9", "b8", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},			//JENBONE_LTENT_2
	{"b10", "b9", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},		//JENBONE_LTENT_3
	{"b11", "b10", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},		//JENBONE_LTENT_4
	{"b12", "b11", {0.0f, 0.0f, -200.0f}, g_jenBoneRad},	//JENBONE_LTENT_5
	{"b25", "b24", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},		//JENBONE_RTENT_1
	{"b26", "b25", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},		//JENBONE_RTENT_2
	{"b27", "b26", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},		//JENBONE_RTENT_3
	{"b28", "b27", {0.0f, 0.0f, 0.0f}, g_jenBoneRad},		//JENBONE_RTENT_4
	{"b29", "b28", {0.0f, 0.0f, -200.0f}, g_jenBoneRad}		//JENBONE_RTENT_5
};

//spawn enemy
void ObjJenova_SpawnEnemy(gameObject_t *obj, char *enemyName)
{
	float pos[3], ang[3];
	Math_VecCopy(obj->net.pos, pos);
	Math_VecCopy(obj->net.ang, ang);
	gameObject_t *en = LServ_ObjectFromName(enemyName, pos, ang, NULL, 0);
	if (en)
	{
		en->net.renderEffects2 |= FXFL2_SPAWN;
	}

	float fxPos[3] = {0.0f, 0.0f, 0.0f};
	float fxAng[3] = {90.0f, 0.0f, 0.0f};
	ObjParticles_Create("other/spawnenemy", fxPos, fxAng, obj->net.index);
	ObjSound_Create(obj->net.pos, "assets/sound/cb/beamoff.wav", 1.0f, -1);
}

//think
void ObjJenova_Think(gameObject_t *obj, float timeMod)
{
	obj->noGravTime = g_glb.gameTime+10000;

	if (!AI_ShouldThink(obj))
	{
		return;
	}

	if (obj->curAnim >= JENOANIM_CIN_IDLE_1)
	{
		Util_AnimateObject(obj, timeMod);
		return;
	}

	if (obj->debounce5 >= g_glb.gameTime)
	{
		obj->net.renderEffects2 |= FXFL2_DRAINAURA;
	}
	else
	{
		obj->net.renderEffects2 &= ~FXFL2_DRAINAURA;
	}

	if (obj->hurtable)
	{ //killing time
		if (obj->net.renderEffects2 & FXFL2_GODLIGHT)
		{
			obj->net.renderEffects2 &= ~FXFL2_GODLIGHT;
			obj->net.boltOffsets[0] = 0.0f;
			obj->net.boltOffsets[1] = 0.0f;
			obj->net.boltOffsets[2] = 0.0f;
		}
		if (obj->chain)
		{
			gameObject_t *beamChain = obj->chain;
			while (beamChain)
			{
				beamChain->think = ObjGeneral_RemoveThink;
				beamChain->thinkTime = g_glb.gameTime;
				beamChain = beamChain->chain;
			}
			obj->chain = NULL;
		}
		obj->net.renderEffects2 &= ~FXFL2_NOSHADOWS;
		obj->aiObj->combatRange = 3000.0f;
		if (obj->debounce4 >= g_glb.gameTime)
		{ //spawning guys
			if (g_glb.ai.numActiveEnemyAI >= 6)
			{ //got enough
				obj->debounce4 = 0;
			}
			else
			{
				float groundDist = AI_GroundDistance(obj, obj->net.pos, NULL);
				if (groundDist < 1500.0f)
				{
					obj->net.vel[2] += 16.0f;
				}
				if (groundDist > 1000.0f && obj->aiObj->attackTime < g_glb.gameTime)
				{
					char *enemyName = (rand()%20 < 15) ? "obj_e30black" : "obj_e30";
					ObjJenova_SpawnEnemy(obj, enemyName);
					obj->aiObj->attackTime = g_glb.gameTime + 1000 + rand()%2000;
				}
			}
		}
		else if (obj->aiObj->enemy && obj->aiObj->enemy->net.pos[2] < obj->net.pos[2]-64.0f &&
			obj->aiObj->distToEnemy > 2000.0f)
		{
			obj->net.vel[2] -= 16.0f;
		}
		AI_StandardGoals(obj, timeMod);
		if (obj->curAnim == JENOANIM_SUCK && obj->net.frame > 67 && obj->net.frame <= 116)
		{
			obj->aiObj->lookPitch = 330.0f;
		}
		else if (obj->debounce4 >= g_glb.gameTime)
		{ //spawnings
			obj->aiObj->lookPitch = 0.0f;
		}
		AI_GenericThink(obj, timeMod);
		AI_GetToGoal(obj, timeMod);

		dmgBoneLine_t dmgPos[NUM_JENOVA_DAMAGE_BONES];
		AI_TransformDamageBones(obj, g_jenovaDamageBones, dmgPos, NUM_JENOVA_DAMAGE_BONES);
		if (obj->aiObj->hasLastDmg)
		{
			if (obj->curAnim == JENOANIM_SLAP)
			{
				for (int i = JENBONE_LTENT_1; i <= JENBONE_LTENT_5; i++)
				{
					AI_RunDamageBone(obj, &g_jenovaDamageBones[i], &obj->aiObj->lastDmg[i],
						&dmgPos[i], AI_LevelDamage(obj, 100));
				}
			}
			else if (obj->curAnim == JENOANIM_SUCK && obj->aiObj->enemy && obj->aiObj->enemy->inuse)
			{
				if (obj->net.frame <= 67)
				{ //suck them in
					if (!obj->target)
					{
						if (obj->aiObj->distToEnemy < 3000.0f)
						{
							float d[3];
							Math_VecSub(dmgPos[JENBONE_RTENT_5].pos, obj->aiObj->enemy->net.pos, d);
							float dist = Math_VecNorm(d);
							if (dist < 512.0f)
							{ //got them
								obj->target = obj->aiObj->enemy;
							}
							else
							{
								float pullStr = (dist < 1024.0f) ? dist : 256.0f;
								d[0] *= pullStr;
								d[1] *= pullStr;
								d[2] *= pullStr;
								if (dist < 1024.0f)
								{
									Math_VecCopy(d, obj->aiObj->enemy->net.vel);
								}
								else
								{
									Math_VecAdd(obj->aiObj->enemy->net.vel, d, obj->aiObj->enemy->net.vel);
								}
							}
						}
					}
				}
				else if (obj->net.frame > 67 && obj->net.frame <= 116)
				{
					if (!obj->target || !obj->target->inuse)
					{ //didn't get a suck target
						AI_StartAnim(obj, HUMANIM_IDLE, true);
					}
					else
					{
						if (obj->debounce3 < g_glb.gameTime)
						{
							Util_DamageObject(obj, obj->target, 1);
							AI_StartAnim(obj->target, HUMANIM_PAIN_HIGH1, true);
							obj->debounce3 = g_glb.gameTime+100;
						}
						float d[3];
						float destPos[3];
						Math_VecCopy(dmgPos[JENBONE_RTENT_5].pos, destPos);
						destPos[2] -= (obj->target->net.maxs[2]+64.0f);
						Math_VecSub(destPos, obj->target->net.pos, d);
						Math_VecCopy(d, obj->target->net.vel);
						obj->target->noGravTime = g_glb.gameTime+200;
					}
				}
			}
			else
			{
				obj->target = NULL;
			}
		}
		memcpy(obj->aiObj->lastDmg, dmgPos, sizeof(dmgPos));
		obj->aiObj->hasLastDmg = true;

		if (g_glb.ai.numActiveEnemyAI < 3 && obj->aiObj->enemy)
		{ //fly around and plop some guys out
			obj->debounce4 = g_glb.gameTime+20000;
		}
		else if (obj->aiObj->attackTime < g_glb.gameTime && obj->aiObj->enemy)
		{
			if (obj->aiObj->distToEnemy < 3000.0f && obj->aiObj->distToEnemy > 2000.0f)
			{
				if (rand()%10 < 5)
				{
					ObjSound_CreateFromIndex(obj->net.pos, g_soundPunch[rand()%NUM_SOUNDS_PUNCH], 1.0f, -1);
					AI_StartAnim(obj, JENOANIM_SLAP, true);
					obj->aiObj->attackTime = g_glb.gameTime + 3000 + rand()%2000;
				}
				else
				{
					ObjSound_CreateFromIndex(obj->net.pos, g_soundPunch[rand()%NUM_SOUNDS_PUNCH], 1.0f, -1);
					AI_StartAnim(obj, JENOANIM_PREPARE_SUCK, true);
					obj->aiObj->attackTime = g_glb.gameTime + 3000 + rand()%2000;
				}
			}
		}
	}
	else
	{
		obj->net.renderEffects2 |= FXFL2_NOSHADOWS;
		AI_GenericThink(obj, timeMod);
		gameObject_t *beamChain = obj->chain;
		if (beamChain)
		{
			modelMatrix_t boneMat;
			if (g_sharedFn->Coll_GetModelBoneMatrix(obj->rcColModel, "b29", &boneMat))
			{
				Math_VecCopy(boneMat.o, beamChain->net.pos);
			}
			beamChain = beamChain->chain;
			if (beamChain)
			{
				beamChain = beamChain->chain;
				if (beamChain)
				{
					if (g_sharedFn->Coll_GetModelBoneMatrix(obj->rcColModel, "b12", &boneMat))
					{
						Math_VecCopy(boneMat.o, beamChain->net.pos);
					}
				}
			}
		}
		if (obj->debounce2 && obj->debounce2 < g_glb.gameTime)
		{ //death sequence
			ObjSound_Create(obj->net.pos, "assets/sound/cb/lstreamsh.wav", 1.0f, -1);
			ObjSound_Create(obj->net.pos, "assets/sound/cb/lstreamsh.wav", 1.0f, -1);

			obj->makoCount = 10;
			obj->debounce2 = 0;
			obj->net.renderEffects |= FXFL_DEATH;
			obj->preDeathTime = g_glb.gameTime + (int)(200.0f*g_glb.timeScale);
		}
	}
}

//pick which anim to be in
void ObjJenova_PickAnim(gameObject_t *obj, float timeMod)
{
	gameAnim_t *curAnim = obj->animTable+obj->curAnim;

	if (obj->curAnim >= JENOANIM_CIN_IDLE_1)
	{ //script will break out
		return;
	}
	else if (obj->curAnim == JENOANIM_PREPARE_SUCK)
	{
		if (obj->net.frame == curAnim->endFrame && !obj->animRestart)
		{
			ObjSound_CreateFromIndex(obj->net.pos, g_soundKick[rand()%NUM_SOUNDS_KICK], 1.0f, -1);
			AI_StartAnim(obj, JENOANIM_SUCK, true);
		}
	}
	else if (obj->net.frame == curAnim->endFrame && !obj->animRestart)
	{
		AI_StartAnim(obj, HUMANIM_IDLE, true);
	}
}

//frame tick
void ObjJenova_FrameTick(gameObject_t *obj, float timeMod, int oldFrame)
{
	if (obj->net.frame == 139 ||
		obj->net.frame == 143 ||
		obj->net.frame == 149 ||
		obj->net.frame == 153)
	{ //slap
		ObjSound_CreateFromIndex(obj->net.pos, g_soundPunch[rand()%NUM_SOUNDS_PUNCH], 1.0f, -1);
		obj->atkLastSeq++;
	}
	else if (obj->net.frame == 72 ||
		obj->net.frame == 80 ||
		obj->net.frame == 87 ||
		obj->net.frame == 95 ||
		obj->net.frame == 102 ||
		obj->net.frame == 110)
	{ //suck
		if (obj->target)
		{
			ObjSound_Create(obj->net.pos, "assets/sound/cb/healstep.wav", 1.0f, -1);
			ObjSound_Create(obj->net.pos, "assets/sound/cb/healstep.wav", 1.0f, -1);
			obj->net.effectLen = 200.0f;
			obj->net.renderEffects2 |= FXFL2_DRAINAURA;
			obj->debounce5 = g_glb.gameTime + Util_LocalDelay(obj, 210);
			Util_DamageObject(obj, obj->target, AI_LevelDamage(obj, 100));
			obj->health += 100;
			if (obj->health > obj->aiObj->maxHealth)
			{
				obj->health = obj->aiObj->maxHealth;
			}
		}
	}
}

//death
void ObjJenova_Death(gameObject_t *obj, gameObject_t *killer, int dmg)
{
	AI_GenericDeath(obj, killer, dmg);
	Util_RunScript("obj_jdeathscr", "arena_jenovadeath");
	obj->net.renderEffects &= ~FXFL_DEATH;
	obj->preDeathTime = 0;
	obj->debounce2 = g_glb.gameTime+1000;
}

//removal
void ObjJenova_OnRemove(gameObject_t *obj)
{
	if (obj->chain)
	{
		gameObject_t *beamChain = obj->chain;
		while (beamChain)
		{
			beamChain->think = ObjGeneral_RemoveThink;
			beamChain->thinkTime = g_glb.gameTime;
			beamChain = beamChain->chain;
		}
		obj->chain = NULL;
	}
}

//spawn
void ObjJenova_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	LServ_CacheObj("obj_e30");
	LServ_CacheObj("obj_e30black");
	g_sharedFn->Common_ServerString("&&other/spawnenemy");
	g_sharedFn->Common_ServerString("$assets/sound/cb/beamoff.wav");

	objArgs_t beamArgs[4];
	beamArgs[0].key = "width";
	beamArgs[0].val = "256";
	beamArgs[1].key = "texture";
	beamArgs[1].val = "assets/textures/beamchain";
	beamArgs[2].key = "repeat";
	beamArgs[2].val = "2";
	beamArgs[3].key = "jiggy";
	beamArgs[3].val = "1";
	obj->chain = LServ_ObjectFromName("obj_beam", obj->net.pos, obj->net.ang, beamArgs, 4);
	obj->chain->target = Util_FindTargetObject("jenovachain1");
	obj->chain->chain = LServ_ObjectFromName("obj_beam", obj->net.pos, obj->net.ang, beamArgs, 4);
	obj->chain->chain->target = Util_FindTargetObject("jenovachain2");
	obj->chain->chain->chain = LServ_ObjectFromName("obj_beam", obj->net.pos, obj->net.ang, beamArgs, 4);
	obj->chain->chain->chain->target = Util_FindTargetObject("jenovachain3");
	//obj->chain->chain->chain->chain = LServ_ObjectFromName("obj_beam", obj->net.pos, obj->net.ang, beamArgs, 4);
	//obj->chain->chain->chain->chain->target = Util_FindTargetObject("jenovachain4");

	float p[3];
	Math_VecCopy(obj->net.pos, p);
	AI_GenericSpawn(obj, b, args, numArgs);
	Math_VecCopy(p, obj->net.pos);
	obj->aiObj->fly = true;
	obj->net.renderEffects2 |= FXFL2_NOSHADOWS;
	obj->hurtable = 0;
	obj->death = ObjJenova_Death;
	obj->onremove = ObjJenova_OnRemove;

	obj->net.renderEffects2 |= FXFL2_GODLIGHT;
	obj->net.boltOffsets[0] = 0.0f;
	obj->net.boltOffsets[1] = 0.0f;
	obj->net.boltOffsets[2] = 16000.0f;

	const char *elvalue = Common_GetValForKey(b, "elvalue");
	if (elvalue && elvalue[0])
	{
		obj->generalFlag = atoi(elvalue);
	}

	obj->health = 30000;
	obj->aiObj->makoValue = 500;
	obj->net.aiDescIndex = AIDESC_JENOVA;
	obj->aiObj->maxHealth = obj->health;

	obj->aiObj->dmgEffect = "melee/impacten";

	obj->aiObj->moveSpeed = 50.0f;
	obj->animhandler = ObjJenova_PickAnim;
	obj->animframetick = ObjJenova_FrameTick;
	obj->animTable = g_jenovaAnims;
	obj->scriptAnims = g_jenovaScriptAnims;
	obj->curAnim = HUMANIM_IDLE;
	obj->think = ObjJenova_Think;
}
