/*
=============================================================================
Module Information
------------------
Name:			obj_mako.cpp
Author:			Rich Whitehouse
Description:	mako
=============================================================================
*/

#include "main.h"

//think
void ObjMako_Think(gameObject_t *obj, float timeMod)
{
	gameObject_t *pl = &g_gameObjects[0];
	float up[3] = {-90.0f, 0.0f, 0.0f};
	if (pl->inuse && pl->health > 0 && pl->hurtable)
	{
		float c[3], d[3];
		modelMatrix_t boneMat;
		if (g_sharedFn->Coll_GetModelBoneMatrix(pl->rcColModel, "b1", &boneMat))
		{
			Math_VecCopy(boneMat.o, c);
		}
		else
		{
			Util_GameObjectCenter(pl, c);
		}
		Math_VecSub(c, obj->net.pos, d);
		float l = Math_VecLen(d);
		if (l < 1400.0f)
		{
			float moveSpeed = (1401.0f-l)*0.5f;
			if (moveSpeed > 256.0f)
			{
				moveSpeed = 256.0f;
			}
			if (Phys_LinearMove(obj, c, moveSpeed*timeMod))
			{
				obj->net.renderEffects |= FXFL_HIDDEN;
				obj->think = ObjGeneral_RemoveThink;
				obj->thinkTime = g_glb.gameTime+2000;
				ObjParticles_Create("general/makopickup", obj->net.pos, up, -1);
				ObjPlayer_GiveMako(pl, obj->generalFlag);
				ObjSound_Create(obj->net.pos, "assets/sound/cb/makopickup.wav", 1.0f, -1);
			}
		}
	}

	if (obj->debounce2 < g_glb.gameTime)
	{
		gameObject_t *cam = Util_GetCam(0);
		if (g_sharedFn->Coll_GeneralVisibilityWithBounds(obj->net.pos, cam->net.pos, obj->radius, obj->spawnMins, obj->spawnMaxs))
		{
			//ObjParticles_Create("general/makodeath", obj->net.pos, up, -1);
			float p[3] = {0.0f, 0.0f, 0.0f};
			ObjParticles_Create("general/makosit", p, up, obj->net.index);
		}
		obj->debounce2 = g_glb.gameTime+100;//400;
	}

	obj->thinkTime = g_glb.gameTime;
	if (obj->debounce < g_glb.gameTime)
	{
		ObjParticles_Create("general/makofade", obj->net.pos, up, -1);
		obj->net.renderEffects |= FXFL_HIDDEN;
		obj->thinkTime = g_glb.gameTime+2000;
		obj->think = ObjGeneral_RemoveThink;
	}
}

//spawn
void ObjMako_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	float up[3] = {-90.0f, 0.0f, 0.0f};
	obj->generalFlag = 1;
	gameObject_t *cam = Util_GetCam(0);
	if (g_sharedFn->Coll_GeneralVisibilityWithBounds(obj->net.pos, cam->net.pos, obj->radius, obj->spawnMins, obj->spawnMaxs))
	{
		ObjParticles_Create("general/makofade", obj->net.pos, up, -1);
		ObjSound_Create(obj->net.pos, "assets/sound/cb/makopop.wav", 1.0f, -1);
	}
	obj->debounce = g_glb.gameTime + 10000;
	//obj->net.renderEffects = FXFL_TRAIL;
	/*
	obj->net.modelScale[0] = 0.5f;
	obj->net.modelScale[1] = 0.5f;
	obj->net.modelScale[2] = 0.5f;
	*/
	obj->think = ObjMako_Think;
}
