/*
=============================================================================
Module Information
------------------
Name:			obj_rigidbody.cpp
Author:			Rich Whitehouse
Description:	simple object utilizing rigid body physics

Object Arguments
model:			Model for the object
rigidprop:		Name of rigid body property entry
gravity:		Gravity factor (default 80.0)
=============================================================================
*/

#include "main.h"

//frame function
void ObjRigidBody_Think(gameObject_t *obj, float timeMod)
{
	Phys_RunRigid(obj, timeMod, obj->rigid->gravity);
	Math_MatToAngles2(obj->net.ang, &obj->rigid->invMat);
	LServ_UpdateRClip(obj);

	obj->thinkTime = g_glb.gameTime;
}

//spawn
void ObjRigidBody_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->rigid = (rigidBody_t *)g_sharedFn->Common_RCMalloc(sizeof(rigidBody_t));
	memset(obj->rigid, 0, sizeof(rigidBody_t));
	obj->rigid->gravity = DEFAULT_GRAVITY;
	Math_AnglesToMat(obj->net.ang, &obj->rigid->mat);
	Math_MatrixInverse(&obj->rigid->mat, &obj->rigid->invMat);

	const char *rbProp = Common_GetValForKey(b, "rigidProp");

	for (int i = 0; i < numArgs; i++)
	{
		const objArgs_t *arg = args+i;
		if (!stricmp(arg->key, "model"))
		{
			char str[256];
			sprintf(str, "&%s", arg->val);
			obj->net.strIndex = g_sharedFn->Common_ServerString(str);
			obj->rcColModel = g_sharedFn->Coll_RegisterModelInstance(arg->val);
			g_sharedFn->Coll_UpdateModel(obj->rcColModel, NULL);
		}
		else if (!stricmp(arg->key, "rigidprop"))
		{
			rbProp = arg->val;
		}
		else if (!stricmp(arg->key, "gravity"))
		{
			obj->rigid->gravity = (float)atof(arg->val);
		}
	}

	obj->rigid->rp = Phys_LoadRigidBody(rbProp);
	if (!obj->rigid->rp)
	{
		Util_ErrorMessage("Rigid body object with bad rigid body name.");
		obj->think = ObjGeneral_RemoveThink;
		obj->thinkTime = g_glb.gameTime;
		return;
	}

	obj->think = ObjRigidBody_Think;
	obj->thinkTime = g_glb.gameTime;
}
