/*
=============================================================================
Module Information
------------------
Name:			obj_supernova.cpp
Author:			Rich Whitehouse
Description:	\m/
=============================================================================
*/

#include "main.h"

//think
void ObjSupernova_Think(gameObject_t *obj, float timeMod)
{
	gameObject_t *cam = Util_GetCam(0);
	if (cam->inuse)
	{
		obj->net.pos[0] = cam->net.pos[0]+obj->spareVec[0];
		obj->net.pos[1] = cam->net.pos[1]+obj->spareVec[1];
		obj->net.pos[2] = cam->net.pos[2]+obj->spareVec[2];
	}

	float scaleFactor = 0.25f;//0.4f;
	/*
	if (g_musical)
	{
		scaleFactor = 0.7f;
	}
	*/
	if (obj->debounce2 > g_glb.gameTime)
	{
		scaleFactor = 0.1f;
		obj->net.renderEffects |= FXFL_VIEWFLARE;
	}
	else
	{
		/*
		if (g_musical && (obj->net.renderEffects & FXFL_VIEWFLARE))
		{
			ObjSound_Create(obj->net.pos, "assets/sound/weapons/sngrow.wav", 1.0f, -1);
		}
		*/
		obj->net.renderEffects &= ~FXFL_VIEWFLARE;
	}

	float scaleInc = scaleFactor*timeMod;

	obj->net.modelScale[0] += scaleInc;
	obj->net.modelScale[1] += scaleInc;
	obj->net.modelScale[2] += scaleInc;

	if (obj->debounce3 < g_glb.gameTime && obj->net.lerpDuration > 3000)
	{ //damage pulse
		float painRadius = 52.0f*obj->net.modelScale[0];
		for (int i = 0; i < g_glb.gameObjectSlots; i++)
		{
			gameObject_t *other = &g_gameObjects[i];
			if (!other->inuse || (other->inuse & INUSE_NONET) || !other->hurtable)
			{
				continue;
			}
			
			float d[3];
			Math_VecSub(obj->net.pos, other->net.pos, d);
			float distToOther = Math_VecLen(d);
			if (distToOther < (painRadius+other->radius))
			{
				int dmg = 5;
				if (other->health <= 20)
				{ //finish it
					dmg = 20;
				}
				Util_DamageObject(obj, other, dmg);
			}
		}

		if (obj->debounce2 <= g_glb.gameTime && obj->debounce4 < g_glb.gameTime && obj->net.lerpDuration > 8000)
		{
			ObjSound_Create(obj->net.pos, "assets/sound/weapons/sngrow.wav", 1.0f, -1);
			obj->debounce4 = g_glb.gameTime + 2000;
		}
		obj->debounce3 = g_glb.gameTime+50;
	}

	if (obj->debounce < g_glb.gameTime)
	{
		obj->net.lerpDuration -= (int)(timeMod*300.0f);
		if (obj->net.lerpDuration < 0)
		{
			obj->net.lerpDuration = 0;
			obj->think = ObjGeneral_RemoveThink; //done
		}
	}
}

//spawn
void ObjSupernova_Spawn(gameObject_t *obj, BYTE *b, const objArgs_t *args, int numArgs)
{
	obj->net.pos[2] += 64.0f;

	gameObject_t *cam = Util_GetCam(0);
	if (cam->inuse)
	{
		Math_VecSub(obj->net.pos, cam->net.pos, obj->spareVec);
	}

	ObjSound_Create(obj->net.pos, "assets/sound/weapons/sncharge.wav", 1.0f, -1);

	obj->net.modelScale[0] = 0.2f;
	obj->net.modelScale[1] = 0.2f;
	obj->net.modelScale[2] = 0.2f;
	obj->debounce = g_glb.gameTime+3800;
	obj->debounce2 = g_glb.gameTime+2800;
	/*
	if (g_musical)
	{
		obj->net.lerpDuration = 8192;
	}
	else
	*/
	{
		obj->net.lerpDuration = 32768;//65536;
	}
	obj->net.renderEffects |= FXFL_SPECIALBLEND;
	obj->think = ObjSupernova_Think;
}
