!!ARBfp1.0

#standard lighting with normal mapping and volume lighting
#Author: Rich Whitehouse
#---------------------------------------------------------------------

#this has become somewhat of a mess.
#texture0 is the decal
#texture1 is the normal map, with dynamic shadow coords in .texcoord
#texture2 is the dynamic shadow texture, with light vectors in .texcoord
#texture3 is the 3d volume light texture

PARAM	mulf = {2.0, 2.0, 2.0};
PARAM	subf = {-1.0, -1.0, -1.0};

OUTPUT	out = result.color;
TEMP	cbrf, nrml, dcal, lvol, temp, dshd;

#fetch the textures
TEX	dcal, fragment.texcoord[0], texture[0], 2D;
TEX	nrml, fragment.texcoord[0], texture[1], 2D;
TXP	dshd, fragment.texcoord[1], texture[2], 2D;
TEX	lvol, fragment.texcoord[3], texture[3], 3D;

MOV	cbrf, fragment.texcoord[2];

#expand the normals
MAD	nrml, nrml, mulf, subf;

#now done here instead of relying on cubemap
DP3	temp, cbrf, cbrf;
RSQ	temp, temp.x;
MUL	temp, temp.x, cbrf;
DP3	temp, nrml, temp;

SUB	dshd, 1.0, dshd;
MUL	temp, dshd, temp; #factor in dynamic shadows

#apply minimum light level
#direct lighting when using an ambient map will be washed out,
#so that light bounces still appear.
MAX	temp, 0.2, temp;

MUL	temp, dcal, temp; #factor in decal
MUL	temp, lvol, temp; #factor in lighting volume

MOV	temp.a, dcal.a; #set alpha component by decal

MOV	out, temp;

END
