/*##########################################################################
#   PROGRAM:      Unreal Sample DLL
#   AUTHOR:       Chris Prince (aka Vulcoris) - cprince@u.washington.edu
#   DATE:         October, 1998
#   DESCRIPTION:  Test class to override Unreal's Trigger class, and do some
#                   (hopefully) useful stuff.
#   NOTE(S):      None.
##########################################################################*/

// General DLL-making files
#include "unrMacro.h"
#include "unrClass.h"

// Files more specific to *this* test DLL
#include <stdio.h>



// Do this once per package
IMPLEMENT_PACKAGE(dlltest);



// Our class definition

class ADLLTrigger : public ATrigger
{
public:
    //------------------------------------------------
    //   fnNothing1
    // Does nothing; no params, no return values
    //------------------------------------------------
    void execfnNothing1( FFrame& Stack, BYTE*& Result )
    {
        // Get arguments
        PARAMS_FINISHED;

        // No params, no return values
        int i = 1;
    }


    //------------------------------------------------
    //   fnBreak1
    // Executes a hard-coded breakpoint.
    //------------------------------------------------
    void execfnBreak1( FFrame& Stack, BYTE*& Result )
    {
        // Get arguments
        PARAMS_FINISHED;

        // User-breakpoint
        __asm int 3  // NOTE: Unreal's exception handler will catch this
    }


    //------------------------------------------------
    //   fnFile1
    // Opens a file (c:\unrtest.txt) and writes a
    // string out to it.
    //------------------------------------------------
    void execfnFile1( FFrame& Stack, BYTE*& Result )
    {
        // Get arguments
        PARAMS_FINISHED;

        // create the file
        FILE* fp = fopen( "c:\\unrtest.txt", "wt" ); // Ugly: hard-coded path
        if( NULL == fp )
        {
            return;  // failure
        }
        //ELSE...

        // write something to it
        fprintf(fp, "This is a test\n" );
        fclose(fp);
    }

//
//  NO_DEFAULT_CONSTRUCTOR(ADLLTrigger);  // ignore this for now :-)
//
};


// Export our class
EXPORT_CLASS( ADLLTrigger );

// Export our class's member functions
EXPORT_FUNC(ADLLTrigger,execfnNothing1);
EXPORT_FUNC(ADLLTrigger,execfnBreak1);
EXPORT_FUNC(ADLLTrigger,execfnFile1);
