//=============================================================================
// DLLTrigger.
//=============================================================================
class DLLTrigger expands Trigger;


// Declare our intrinsic functions
intrinsic function fnNothing1();
intrinsic function fnBreak1();
intrinsic function fnFile1();


// Let's override the Touch function
// (pretty much like ZoneTrigger, but with our additions)
function Touch( actor Other )
{
	local ZoneInfo Z;
	
	// ----- BEGIN ADDED SECTION -----
	// pre-func-call message (for debugging)
	if( IsRelevant( Other ) )
	{
		Other.Instigator.ClientMessage( "About to call my dll function." );
	}
	
	fnFile1();
	//fnNothing1();
	//fnBreak1();

	// post-func-call message (for debugging)
	if( IsRelevant( Other ) )
	{
		Other.Instigator.ClientMessage( "DONE calling my dll function." );
	}
	// ------ END ADDED SECTION ------

	
	if( IsRelevant( Other ) )
	{
		// Broadcast the Trigger message to all matching actors.
		if( Event != '' )
			foreach AllActors( class 'ZoneInfo', Z )
				if ( Z.ZoneTag == Event )
					Z.Trigger( Other, Other.Instigator );

		if( Message != "" )
			// Send a string message to the toucher.
			Other.Instigator.ClientMessage( Message );

		if( bTriggerOnceOnly )
			// Ignore future touches.
			SetCollision(False);
	}
}

// This is also from ZoneTrigger (unchanged)
function UnTouch( actor Other )
{
	local ZoneInfo Z;
	if( IsRelevant( Other ) )
	{
		// Untrigger all matching actors.
		if( Event != '' )
			foreach AllActors( class 'ZoneInfo', Z )
				if ( Z.ZoneTag == Event )
					Z.UnTrigger( Other, Other.Instigator );
	}
}

defaultproperties
{
}
