// Unreal Music (UMX) Ripper 2.0 by Tom Grandgent (tgrand@canvaslink.com)

// Cheesy?  Maybe.  But it works and it's fast.
//
// Update: UMXRip 2.0 has been made more generic to rip modules 
// (MOD, S3M, XM, IT) from any file that simply has header data 
// followed by the module data (like the UMX format).  This should 
// make UMXRip more futureproof - it will only break if Epic 
// encrypts or compresses the module data, or if they add data 
// after the module itself.

#include <stdio.h>

int main(int argc, char *argv[])
{
    int f, i, j, k, chunk;
    FILE *in, *out;
    char sig[4];
    char done, type, ch;
    char buf[65535];
    char ext[6];
    char modsig[4] = "M.K.";
    char mod6sig[4] = "6CHN";
    char mod8sig[4] = "8CHN";
    char s3msig[4] = "SCRM";
    char itsig[4] = "IMPM";
    char xmsig[16] = "Extended Module:";

    setvbuf(stdout, NULL, _IONBF, NULL);

    printf("Unreal Music (UMX) Ripper 2.0 by Tom Grandgent\n\n");

    // Check parameters
    if (argc < 2)
    {
        printf("Example usage:\n\n");
        printf("umxrip *.*\nor\numxrip chizra1.umx\n");
        return 1;
    }

    // Loop through all of the input files
    for (f = 1; f < argc; f++)
    {
        in = fopen(argv[f], "rb");
        if (!in)
        {
            printf("Error: Unable to open %s for reading\n", argv[f]);
            continue;
        }
        printf("%s: ", argv[f]);

        // Read in the beginning of the file
        j = fread(buf, 1, sizeof(buf), in);
        if (j < 64)
        {
            printf("Error: Unable to read from %s - file may be corrupt\n", argv[f]);
            fclose(in);
            continue;
        }

        // Search for a signature (for the MOD, S3M, IT, or XM formats)
        ext[0] = '\0';
        for (i = 0; i < j - 64; i++)
        {
            if (!memcmp(&buf[i], s3msig, 4))
            {
                strcpy(ext, ".s3m");
                fseek(in, i - 44, SEEK_SET);
                break;
            }
            else
            if (!memcmp(&buf[i], itsig, 4))
            {
                strcpy(ext, ".it");
                fseek(in, i, SEEK_SET);
                break;
            }
            else
            if (!memcmp(&buf[i], xmsig, 16))
            {
                strcpy(ext, ".xm");
                fseek(in, i, SEEK_SET);
            }
            else
            if (!memcmp(&buf[i], modsig, 4) || !memcmp(&buf[i], mod6sig, 4) || !memcmp(&buf[i], mod8sig, 4))
            {
                strcpy(ext, ".mod");
                fseek(in, i - 0x438, SEEK_SET);
                break;
            }
        }

        // Bail if no signature was found
        if (!ext[0])
        {
            printf("Error: No signature found in %s, skipping...", argv[f]);
            fclose(in);
            continue;
        }

        // Set up an output filename with the proper extension
        strcpy(buf, argv[f]);
        // Find the extension and nuke it if there is one
        for (i = strlen(buf); i--; i > 0)
            if (buf[i] == '.')
            {
                buf[i] = '\0';
                break;
            }
        // Add the new extension (.mod, .s3m, .it, or .xm)
        strcat(buf, ext);

        // Open the output file
        out = fopen(buf, "wb");
        if (!out)
        {
            printf("Couldn't open %s for writing..\n", buf);
            continue;
        }

        // Write out the data (haha, ok, I know this is not nice)
        while (1)
        {
            i = fgetc(in);
            if (i == EOF)
                break;
            fputc(i, out);
        }

        fclose(in);
        fclose(out);

        printf("Wrote %s.\n", buf);
    }

    return 0;
}
