#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "qheaders.h"



void ReadBSP(char name[56], bsp_header_t* bspHeader, int length)
{
	bsp_lump_t* lump;
	int i;
	char* entityParser;
	int entitiesCount;
	int entitiesCharCount;

	if (bspHeader->magic[0] != 'I' ||
		bspHeader->magic[1] != 'B' ||
		bspHeader->magic[2] != 'S' ||
		bspHeader->magic[3] != 'P' )
	{
		printf("%s is an invalide BSP file.\n",name);
		return;
	}


	printf("                 '%s' is a valid BSP file (version:%d).\n",name,bspHeader->version);
	printf("                 '%s' has a size of %d bytes.\n",name,length);
	lump = bspHeader->lumps;

	for(i=0 ; i < 19 ; i++,lump++){
		printf("                     Lump: %s has a size of %d bytes.\n",lumpNames[i],lump->length);

		switch(i) 
		{
			case LUMP_LIGHTING: printf("                              has %.2f lightmaps.\n",lump->length/(64.0*3)); break;
			case LUMP_FACES:	printf("                              has %d faces.\n",lump->length/sizeof(dface_t));break;
			case LUMP_ENTITIES: 
				{
					entityParser = ((char*)bspHeader) + lump->offset;
					entitiesCount = 0;
					entitiesCharCount = lump->length;
					while(entitiesCharCount)
					{
						if (*entityParser == '{') 
							entitiesCount++;
						entityParser++;
						entitiesCharCount--;
					}
					printf("                              has %d entities.\n",entitiesCount);
				}
				break;

			case LUMP_TEXINFO: 
				{
					printf("                              has %d textures_info.\n",lump->length/sizeof(texinfo_t));
					printf("                              first is 'textures/%s.wal'.\n",((texinfo_t*)((char*)bspHeader + lump->offset))->texture);
				}
				break;
/*
			case LUMP_FACES:
				{

				}
				break;
				*/
		}
	}
}

// BSP FORMAT http://www.flipcode.com/archives/Quake_2_BSP_File_Format.shtml
// WAL FORMAT http://www.flipcode.com/archives/Quake_2_BSP_File_Format.shtml
// PAK FORMAT http://debian.fmi.uni-sofia.bg/~sergei/cgsr/docs/pak.txt

int main(int argc, char** argv)
{
	pakArchive_t pakArchive;
	pak_header_t* pakHeader;
	int numDirEntries;
	directoryEntry_t* dirEntry;
	unsigned int max_w=0,max_h=0;

	int i;

	if (argc < 2){
		printf("\n\nUsage: %s %s",argv[0],"filename\n\n");
		return 0;
	}


	pakArchive.f = fopen(argv[1],"rb");
	if (!pakArchive.f){
		printf("ERROR: Unable to open '%s' file.\n",argv[1]);
		return 0;
	}


	//Get filelength
	fseek(pakArchive.f, 0L, SEEK_END);
	pakArchive.size = ftell(pakArchive.f);
	fseek(pakArchive.f, 0L, SEEK_SET);

	printf("Pak archive is %d bytes.\n",pakArchive.size);

	pakArchive.data = malloc(pakArchive.size);
	fread(pakArchive.data,pakArchive.size,1,pakArchive.f);

	pakHeader = (pak_header_t*)pakArchive.data ;

	//Check magicNumber
	if (pakHeader->signature[0] != 'P' ||
		pakHeader->signature[1] != 'A' ||
		pakHeader->signature[2] != 'C' ||
		pakHeader->signature[3] != 'K'){
			printf("ERROR: Pak archive's magic number is not 'PACK'.\n");
		return 0;
	}

	dirEntry = (directoryEntry_t*)(pakArchive.data + pakHeader->dirOffset);
	numDirEntries = pakHeader->dirLength / sizeof(directoryEntry_t);
	printf("Archive has %d entries.\n",numDirEntries);

	for (i = 0; i < numDirEntries; i++,dirEntry++ ){

		int nameLength = strlen(dirEntry->filename);

		if (dirEntry->filename[nameLength-3] == 'b' &&
			dirEntry->filename[nameLength-2] == 's' &&
			dirEntry->filename[nameLength-1] == 'p' 
			){
				printf("Found bsp entry: '%s'.\n",dirEntry->filename);
				ReadBSP(dirEntry->filename,(bsp_header_t*)(pakArchive.data + dirEntry->offset),dirEntry->length);
		}

		if (dirEntry->filename[nameLength-3] == 'w' &&
			dirEntry->filename[nameLength-2] == 'a' &&
			dirEntry->filename[nameLength-1] == 'l' 
			){
			  
			  wal_header_t* wal_header = (wal_header_t*)(pakArchive.data + dirEntry->offset);

printf("Found wal entry: '%s'.\n",dirEntry->filename);

			  printf("	Texture name =%s w=%u h=%u\n",wal_header->name,wal_header->width,wal_header->height);

			  if (wal_header->width  > max_w) max_w = wal_header->width;
		      if (wal_header->height > max_h) max_h = wal_header->height;
		}
			
	}
	
	printf("Max WAL dimensions: w=%u,h=%d.\n",max_w,max_h);

	free(pakArchive.data);
	fclose(pakArchive.f);

	return 1;
}