typedef struct pak_header_s{
	char signature[4]; 
	int dirOffset;
	int dirLength;
} pak_header_t;

typedef struct pakArchive_s{
	FILE* f;
	int size;
	char* data;
} pakArchive_t ;

typedef struct directotyEntry_s{
	char filename[56];
	int offset;
	int length;
} directoryEntry_t ;


typedef struct bsp_lump_s
{
    unsigned int    offset;     // offset (in bytes) of the data from the beginning of the file
    unsigned int    length;     // length (in bytes) of the data
} bsp_lump_t;

typedef struct bsp_header_s
{
    char    magic[4];      // magic number ("IBSP")
    unsigned int    version;    // version of the BSP format (38)
    bsp_lump_t		lumps[19];   // directory of the lumps
} bsp_header_t;


#define LUMP_LIST \
 FUNCTION(LUMP_ENTITIES), \
 FUNCTION(LUMP_PLANES),\
 FUNCTION(LUMP_VERTEXES),\
 FUNCTION(LUMP_VISIBILITY),\
 FUNCTION(LUMP_NODES),\
 FUNCTION(LUMP_TEXINFO),\
 FUNCTION(LUMP_FACES),\
 FUNCTION(LUMP_LIGHTING),\
 FUNCTION(LUMP_LEAFS),\
 FUNCTION(LUMP_LEAFFACES),\
 FUNCTION(LUMP_LEAFBRUSHES),\
 FUNCTION(LUMP_EDGES),\
 FUNCTION(LUMP_SURFEDGES),\
 FUNCTION(LUMP_MODELS),\
 FUNCTION(LUMP_BRUSHES),\
 FUNCTION(LUMP_BRUSHSIDES),\
 FUNCTION(LUMP_POP),\
 FUNCTION(LUMP_AREAS),\
 FUNCTION(LUMP_AREAPORTALS)

#define FUNCTION(x) x
enum lump_identifiers {LUMP_LIST};
#undef FUNCTION

#define FUNCTION(x) #x
char* lumpNames[] = {LUMP_LIST};
#undef FUNCTION

#define	MAXLIGHTMAPS	4
typedef struct
{
	unsigned short	planenum;
	short		side;

	int			firstedge;		// we must support > 64k edges
	short		numedges;	
	short		texinfo;

// lighting info
	char		styles[MAXLIGHTMAPS];
	int			lightofs;		// start of [numstyles*surfsize] samples
} dface_t;



typedef struct texinfo_s
{
	float		vecs[2][4];		// [s/t][xyz offset]
	int			flags;			// miptex flags + overrides
	int			value;			// light emission, etc
	char		texture[32];	// texture name (textures/*.wal)
	int			nexttexinfo;	// for animations, -1 = end of chain
} texinfo_t;



typedef struct wal_header_s
{

    char    name[32];        // name of the texture
 
    unsigned int  width;           // width (in pixels) of the largest mipmap level
    unsigned int  height;          // height (in pixels) of the largest mipmap level
 
    int   offset[4];       // byte offset of the start of each of the 4 mipmap levels

    char    next_name[32];   // name of the next texture in the animation

    unsigned int  flags;           // ?
    unsigned int  contents;        // ?
    unsigned int  value;           // ?

} wal_header_t;