/*
	MVD_Parser
	(c) Juergen Legler
*/

#include "defaults.h"
#include "version.h"
#include "tools.h"
#include "config.h"
#include "mysql_interface.h"

int debug = 0;
int print_player_info = 0;
int test_runs = 0;
int setup_msyql_weapontable = 0;
extern char *config_file;

std::vector<char *> files;

int Parse_Switch(char *sswitch,char *argument){
  //printf("switch : %s %s\n",sswitch,argument);

	switch (sswitch[1]){
	  case 'c':
      config_file = strdup(argument);
      return 1;
	  case 'f':
      Config::Variable_Add("fragfile",argument);
      return 1;
		case 'd':
			debug = 1;
			return 0;

		case 'p':
			print_player_info = 1;
			return 0;

    case 't':
      test_runs = atoi(argument);
      return 1;

    case 's':
      setup_msyql_weapontable = 1;
      return 0;


    case 'v':
      printf("mvd_parser\n");
      printf("version   :  %s\n",VERSION);
      printf("buildtime :  %s\n",BUILDTIME);
      printf("compiler  :  %s\n",COMPILER_VERSION);
      printf("contact   :  jogihoogi[at]gmx.net\n");
      exit(0);

    case 'h':
      printf("mvd_parser ver. %s\n",VERSION);
      printf("Usage: mvd_parser -[hdpv] file1 file2 ...\n");
      printf("-h            - show this message\n");
      printf("-p            - print information of each player at the end of the stat collection\n");
      printf("-d            - enable debugging\n");
      printf("-v            - print version\n");
      printf("-t [num]      - number of testruns\n");
      printf("-f fragfile   - fragfile.dat location\n");
      printf("-c configfile - config file location\n");
      printf("-s            - sets the mysql weapontable and exits\n");

      exit(0);


		default:
			//printf ("Switch %s not defined\n",sswitch);
			return 0;
	}





}

void Parse_Filename(char *filename){
	struct stat filestats;
	if (!stat(filename,&filestats)){
		//printf("file   : %s\n",filename);
		files.push_back(strdup(filename));
	}else{
		//printf("file   : %s isnt parseable\n",filename);
	}

}


namespace CmdLine {
	void Parse(int argc, char **argv){
		for (int i = 1; i< argc;i++)
			if (argv[i][0] == '-')
				i += Parse_Switch(argv[i],argv[i+1]);
			else
				Parse_Filename(argv[i]);
		//exit (1);

	}


}
