#include "defaults.h"
#include "tools.h"



typedef struct variables_s
  {
    char *name;
    char *value;
    int  ivalue;
  } variables_t;

std::vector<variables_t> variables;


void Load_Config(char *buf,bool _override)
{
  char  *_start;
  char  *_end;
  char  *_line;
  char  **_tokens;
  bool  _found,_error;
  variables_t *_t;


  _start = buf;
  std::vector<variables_t>::iterator _current;
  int i;

  while (_start < buf + strlen(buf))
    {
      _found = _error = false;
      _end = strstr(_start,"\n");
      _line = strndup(_start,_end-_start);

      _tokens = Tokenize_String(_line);

      if (!(_tokens[0] && _tokens[1]))
        _error = true;


      _current = variables.begin();
      while (_current != variables.end() && !_found){
        if (!strcmp(_current->name,(*_tokens))){
          _found = true;
          printf("variable %s was already defined check your config file\n",_line);
          break;
        }
        _current++;
      }

      if (!_found && !_error){
        _t = new variables_t;
        _t->name = strdup(*_tokens);
        _tokens++;
        _t->value = strdup(*_tokens);
        _t->ivalue= atoi(*_tokens);
        variables.push_back(*_t);
      }

      if (_found && _override && !_error){
        free(_current->value);
        _tokens++;
        _current->value = strdup(*_tokens);
        _current->ivalue= atoi(*_tokens);
      }

      free(_line);
      _line = NULL;
      _start = _end+1;

    }
}



  namespace Config
    {

      void Load (char *name)
      {
        char *buf;

        buf = OpenFile(name,NULL);
        Load_Config(buf,true);
        free(buf);
      }

      char *Get_Variable_Value(char *name,bool _exit){
        std::vector<variables_t>::iterator _current;

        _current = variables.begin();

        while (_current != variables.end()){
          if (!strcmp(_current->name,name))
            return _current->value;
          _current++;
        }
        if (_exit){
          printf("quit because variable %s is not set\n",name);
          exit(0);
        }else
          return NULL;
      }

      int Get_Variable_IValue(char *name,bool _exit){
        std::vector<variables_t>::iterator _current;

        _current = variables.begin();

        while (_current != variables.end()){
          if (!strcmp(_current->name,name))
            return _current->ivalue;
          _current++;
        }
        if (_exit){
          printf("quit because variable %s is not set\n",name);
          exit(0);
        }else
          return -1;
      }

      void Variable_Add(char *name, char *value){
        std::vector<variables_t>::iterator _current;
        variables_t *_t;
        _current = variables.begin();

        while (_current != variables.end())
          if (!strcmp(_current->name,name))
            return;

        _t = new variables_t;
        _t->name    = strdup(name);
        _t->value   = strdup(value);
        _t->ivalue  = atoi(value);




      }

}
