#define	MAX_CL_STATS		32
#define	STAT_HEALTH			0
//define STAT_FRAGS			1
#define	STAT_WEAPON			2
#define	STAT_AMMO			3
#define	STAT_ARMOR			4
//define STAT_WEAPONFRAME	5
#define	STAT_SHELLS			6
#define	STAT_NAILS			7
#define	STAT_ROCKETS		8
#define	STAT_CELLS			9
#define	STAT_ACTIVEWEAPON	10
#define	STAT_TOTALSECRETS	11
#define	STAT_TOTALMONSTERS	12
#define	STAT_SECRETS		13		// bumped on client side by svc_foundsecret
#define	STAT_MONSTERS		14		// bumped by svc_killedmonster
#define	STAT_ITEMS			15
#define STAT_VIEWHEIGHT		16		// Z_EXT_VIEWHEIGHT protocol extension
#define STAT_TIME			17		// Z_EXT_TIME extension


#include "defaults.h"
//#include "common.h"
#include "tools.h"

#define	MAX_CL_STATS		32
extern int debug;

void l_printf(char *str, ...);


typedef float vec_t;
typedef vec_t vec3_t[3];
typedef vec_t vec5_t[5];

typedef struct players_s
  {
#ifdef __CONSISTENCY_CHECK__
    char    name[64];
    char    userinfo[512];
    char    team[64];
#else
    char    *name;
    char    *userinfo;
    char    *team;
#endif

    int     pnum;
    int     frame;
    int     userid;
    int     frags;
    int     spectator;
    int     stats[MAX_CL_STATS];
    float   pl;
    int     pl_count;
    float   pl_average;
    float   pl_highest;
    float   pl_lowest;
    float   ping;
    int     ping_count;
    float   ping_average;
    float   ping_highest;
    float   ping_lowest;
    int     armor_count[3];
    int     weapon_count[7];
    int     weapon_drops[7];
    int     weapon_shots[9];
    int     quad_count;
    int		  armor_took_flag;
    float   weapon_time[7];
    int     death_count;
    int     megahealth_count;
    int     ring_count;
    int     pent_count;
    int     armor_wasted[3];
    int     health_count[3];
    int     health_wasted;
    int     jump_count;
    int     damage_health[4];
    int     damage_armor[3];
    int     weaponframe;
    int     speed_frame_count;
    float   acc_average_speed;
    float   speed_highest;
    vec3_t  origin;

    int     mysql_id;

    bool    teamkill_flag;



  } players_t;

typedef struct fragstats_s
  {
    int     kills[32][64];
    int     deaths[32][64];
    int     wdeaths[64];
    int     wkills[64];
    int     tkills[64];
    int     tdeaths[64];
    int     total_frags;
    int     flag_touches;
    int     flag_dropped;
    int     flag_captured;
    int     suicides;
    int     teamkills;
  } fragstats_t ;

fragstats_t fragstats[32];

extern players_t  players[32];
extern players_t  lf_players[32];


typedef enum msgtype_s
{
  mt_fragged,
  mt_frags,
  mt_tkills,
  mt_tkilled,

  mt_death,
  mt_suicide,
  mt_frag,
  mt_tkill,
  mt_flagtouch,
  mt_flagdrop,
  mt_flagcap
}
msgtype_t;

typedef struct weapon_class_s
  {
    char *keyword;
    char *name;
    char *shortname;

  } weapon_class_t;

typedef struct msg_type_s
  {
    char      *msg1;
    char      *msg2;
    msgtype_t type;
    int       wclass_index;


  } msg_type_t;

std::vector<msg_type_t>       frag_messages;
std::vector<weapon_class_t>   weapon_classes;




void Load_FragDefs(char *buf)
{
  char  *_start;
  char  *_end;
  char  *_line;
  char  **_tokens;
  bool   _type = 0;
  msg_type_t  *t;
  weapon_class_t *w;
  _start = buf;
  std::vector<weapon_class_t>::iterator wcurrent;
  int i;

  while (_start < buf + strlen(buf))
    {
      _end = strstr(_start,"\n");
      _line = strndup(_start,_end-_start);

      if (strstr(_line,"#DEFINE") == _line)
        {
          //printf("%s\n",_line);
          _tokens = Tokenize_String(_line);
          _tokens++;    // the define thing:>

          if (!strcmp(*_tokens,"OBITUARY"))
            {
              _tokens++;
              t = new msg_type_t;
              memset(t,0,sizeof(msg_type_t));
              if (!strcmp("PLAYER_DEATH",*_tokens))
                t->type = mt_death;
              if (!strcmp("PLAYER_SUICIDE",*_tokens))
                t->type = mt_suicide;
              if (!strcmp("X_FRAGS_UNKNOWN",*_tokens))
                t->type = mt_frag;
              if (!strcmp("X_TEAMKILLS_UNKNOWN",*_tokens))
                t->type = mt_tkill;
              if (!strcmp("X_FRAGS_Y",*_tokens))
                t->type = mt_frags;
              if (!strcmp("X_FRAGGED_BY_Y",*_tokens))
                t->type = mt_fragged;
              if (!strcmp("X_TEAMKILLS_Y",*_tokens))
                t->type = mt_tkills;
              if (!strcmp("X_TEAMKILLED_BY",*_tokens))
                t->type = mt_tkilled;
              _tokens++;// need to read weaponclass
              wcurrent = weapon_classes.begin();
              i = 0;
              while (wcurrent != weapon_classes.end())
                {
                  if (!strcmp(*_tokens,wcurrent->keyword))
                    {
                      t->wclass_index = i;
                      break;
                    }
                  wcurrent++;
                  i++;
                }
              _tokens++;
              if (*_tokens)
                t->msg1 = strdup(*_tokens);
              _tokens++;
              if (*_tokens)
                t->msg2 = strdup(*_tokens);
              frag_messages.push_back(*t);
            }
          else if (!strcmp(*_tokens,"WEAPON_CLASS"))
            {
              _tokens++;
              w = new weapon_class_t;
              w->keyword = strdup(*_tokens);
              _tokens++;
              w->name = strdup(*_tokens);
              _tokens++;
              if (*_tokens)
                w->shortname = strdup(*_tokens);
              else
                w->shortname = w->name;
              weapon_classes.push_back(*w);
            }
          else if (!strcmp(*_tokens,"FLAG_ALERT"))
            {
              _tokens++;
              t = new msg_type_t;
              memset(t,0,sizeof(msg_type_t));
              if (!strcmp("X_TOUCHES_FLAG",*_tokens)||\
                  !strcmp("X_GETS_FLAG",*_tokens)||\
                  !strcmp("X_TAKES_FLAG",*_tokens))
                t->type = mt_flagtouch;
              if (!strcmp("X_DROPS_FLAG",*_tokens)||\
                  !strcmp("X_FUMBLES_FLAG",*_tokens)||\
                  !strcmp("X_LOSES_FLAG",*_tokens))
                t->type = mt_flagdrop;
              if (!strcmp("X_CAPTURES_FLAG",*_tokens)||\
                  !strcmp("X_CAPS_FLAG",*_tokens)||\
                  !strcmp("X_SCORES",*_tokens))
                t->type = mt_flagcap;
              _tokens++;
              if (*_tokens)
                t->msg1 = strdup(*_tokens);
              _tokens++;
              if (*_tokens)
                t->msg2 = strdup(*_tokens);
              frag_messages.push_back(*t);




            }
          else
            {
              while (*_tokens)
                {
                  l_printf("%s\n",*_tokens);
                  _tokens++;
                }
              printf("fragfile corrupt\n");
              exit(1);
            }

        }
      free(_line);
      _line = NULL;
      _start = _end+1;
    }

  if (debug)
    {
      printf("loaded weapon_types:\n");

      wcurrent = weapon_classes.begin();
      while (wcurrent != weapon_classes.end())
        {

          printf("%s %s %s\n",wcurrent->keyword,wcurrent->name,wcurrent->shortname);

          wcurrent++;
        }


      printf("loaded msg_types:\n");
      std::vector<msg_type_t>::iterator current;
      current = frag_messages.begin();
      while (current != frag_messages.end())
        {
          if (current->msg2)
            printf("%i %s %s %s\n",current->type,weapon_classes[current->wclass_index].keyword,current->msg1,current->msg2);
          else
            printf("%i %s %s\n",current->type,weapon_classes[current->wclass_index].keyword,current->msg1);
          current++;
        }
    }
}





namespace Frag_Parser
  {


    void Load_Fragfile(char *file)
    {
      char *buf = NULL;

      buf = OpenFile(file,NULL);

      Load_FragDefs(buf);

      free(buf);
    }



    void Parse(char *string)
    {
      std::vector<msg_type_t>::iterator _current_msg_type;
      bool  _msg_found = 0;


      _current_msg_type = frag_messages.begin();
      l_printf("%s\n",string);
      while (_current_msg_type != frag_messages.end())
        {
          if (_current_msg_type->msg2)
            {
              if (strstr(string,_current_msg_type->msg1) && strstr(string,_current_msg_type->msg2))
                {
                  l_printf("msg found\n");
                  l_printf("%i %s\n%s\n",_current_msg_type->type,weapon_classes[_current_msg_type->wclass_index].keyword,string);
                  _msg_found = 1;
                  break;
                }

            }
          else
            {
              if (strstr(string,_current_msg_type->msg1))
                {
                  l_printf("msg found\n");
                  l_printf("%i %s \n%s\n",_current_msg_type->type,weapon_classes[_current_msg_type->wclass_index].keyword,string);
                  _msg_found = 1;
                  break;
                }
            }

          _current_msg_type++;
        }

      if (!_msg_found)
        {

          l_printf("msg not found\n");
          l_printf("%s",string);
          return;
        }

      players_t *p1=NULL;
      players_t *p2=NULL;
      players_t *victim;
      players_t *killer;
      char *x;
      for (int i=0;i<32;i++)
        {
          if (players[i].name && !players[i].spectator)
            {
              if ((x=strstr(string,players[i].name)))
                {
                  l_printf("string: %i \nx: %i \nfound %s\n\n",string,x,players[i].name);
                  if (x == string)
                    p1 = &players[i];
                  else if (x > string)
                    p2 = &players[i];
                }


            }
        }


      if (p1)
        l_printf("Player 1: %s\n",p1->name);
      if (p2)
        l_printf("Player 2: %s\n",p2->name);

      if (!p1 && p2)
        p1 = p2;
      if (p1 && !p2)
        p2 = p1;

      switch (_current_msg_type->type)
        {
        case mt_death:
          fragstats[p1->pnum].wdeaths[_current_msg_type->wclass_index]++;
          l_printf("%s died by %s\n",p1,weapon_classes[_current_msg_type->wclass_index].name);

          break;

        case mt_suicide:
          l_printf("%s suicided\n",p1);
          fragstats[p1->pnum].suicides++;
          break;

        case mt_fragged:
        case mt_frags:
          killer = (_current_msg_type->type == mt_fragged) ? p2 : p1;
          victim = (_current_msg_type->type == mt_fragged) ? p1 : p2;

          fragstats[killer->pnum].kills[victim->pnum][_current_msg_type->wclass_index]++;
          fragstats[killer->pnum].total_frags++;
          fragstats[killer->pnum].wkills[_current_msg_type->wclass_index]++;
          fragstats[victim->pnum].deaths[killer->pnum][_current_msg_type->wclass_index]++;
          l_printf("%s killed %s with %s\n",killer->name,victim->name,weapon_classes[_current_msg_type->wclass_index].name);
          break;

        case mt_frag:
          fragstats[p1->pnum].wkills[_current_msg_type->wclass_index]++;
          break;


        case mt_tkilled:
        case mt_tkills:
          killer = (_current_msg_type->type == mt_tkilled) ? p2 : p1;
          victim = (_current_msg_type->type == mt_tkilled) ? p1 : p2;

          fragstats[killer->pnum].tkills[victim->pnum]++;
          fragstats[victim->pnum].tdeaths[killer->pnum]++;
          fragstats[killer->pnum].total_frags--;

          if (_current_msg_type->type == mt_tkilled)
            l_printf("%s teamkilled %s\n",killer->name,victim->name);
          if (_current_msg_type->type == mt_tkills)
            l_printf("%s got teamkilled\n",p1);
          break;

        case mt_tkill:
          fragstats[p1->pnum].teamkills++;
          p1->teamkill_flag = true;
          break;

        case mt_flagtouch:
          fragstats[p1->pnum].flag_touches++;
          l_printf("%s touched flag\n",p1->name);
          break;

        case mt_flagdrop:
          fragstats[p1->pnum].flag_dropped++;
          l_printf("%s dropped flag\n",p1->name);
          break;

        case mt_flagcap:
          fragstats[p1->pnum].flag_captured++;
          l_printf("%s captured flag\n",p1->name);
          break;

        default:
          break;











        }




    }
  }
