#define __LITTLE_ENDIAN__Q__
#ifdef __BIG_ENDIAN__Q__
#define BigShort(x)(x)
#define BigLong(x)(x)
#define BigFloat(x)(x)
#define LittleShort(x)ShortSwap(x)
#define LittleLong(x)LongSwap(x)
#define LittleFloat(x)FloatSwap(x)
#elif defined(__LITTLE_ENDIAN__Q__)
#define BigShort(x)ShortSwap(x)
#define BigLong(x)LongSwap(x)
#define BigFloat(x)FloatSwap(x)
#define LittleShort(x)(x)
#define LittleLong(x)(x)
#define LittleFloat(x)(x)
#elif defined(__PDP_ENDIAN__Q__)
#define BigShort(x)ShortSwap(x)
#define BigLong(x)LongSwapPDP2Big(x)
#define BigFloat(x)FloatSwapPDP2Big(x)
#define LittleShort(x)(x)
#define LittleLong(x)LongSwapPDP2Lit(x)
#define LittleFloat(x)FloatSwapPDP2Lit(x)
#else
#error Unknown byte order type!
#endif





#define CM_MSEC	(1 << 7)



#include <sys/time.h>


typedef float vec_t;
typedef vec_t vec3_t[3];
typedef vec_t vec5_t[5];

typedef unsigned char byte;



typedef struct sizebuf_s
  {
    bool	allowoverflow;	// if false, do a Sys_Error
    bool	overflowed;		// set to true if the buffer size failed
    byte	*data;
    int		maxsize;
    int		cursize;
  } sizebuf_t;


#include "protocol.h"


sizebuf_t	net_message;
int msg_readcount;
bool msg_badread;

void MSG_BeginReading (void)
{
  msg_readcount = 0;
  msg_badread = false;
}

int MSG_GetReadCount(void)
{
  return msg_readcount;
}

// returns -1 and sets msg_badread if no more characters are available
int MSG_ReadChar (void)
{
  int c;

  if (msg_readcount + 1 > net_message.cursize)
    {
      msg_badread = true;
      return -1;
    }

  c = (signed char)net_message.data[msg_readcount];
  msg_readcount++;

  return c;
}

int MSG_ReadByte (void)
{
  int c;

  if (msg_readcount + 1 > net_message.cursize)
    {
      msg_badread = true;
      return -1;
    }

  c = (unsigned char)net_message.data[msg_readcount];
  msg_readcount++;

  return c;
}

int MSG_ReadShort (void)
{
  int c;

  if (msg_readcount + 2 > net_message.cursize)
    {
      msg_badread = true;
      return -1;
    }

  c = (short)(net_message.data[msg_readcount]
              + (net_message.data[msg_readcount + 1] << 8));

  msg_readcount += 2;

  return c;
}

int MSG_ReadLong (void)
{
  int c;

  if (msg_readcount + 4 > net_message.cursize)
    {
      msg_badread = true;
      return -1;
    }

  c = net_message.data[msg_readcount]
      + (net_message.data[msg_readcount + 1] << 8)
      + (net_message.data[msg_readcount + 2] << 16)
      + (net_message.data[msg_readcount + 3] << 24);

  msg_readcount += 4;

  return c;
}

float MSG_ReadFloat (void)
{
  union
    {
      byte b[4];
      float f;
      int l;
    } dat;

  dat.b[0] = net_message.data[msg_readcount];
  dat.b[1] = net_message.data[msg_readcount + 1];
  dat.b[2] = net_message.data[msg_readcount + 2];
  dat.b[3] = net_message.data[msg_readcount + 3];
  msg_readcount += 4;

  dat.l = LittleLong (dat.l);

  return dat.f;
}

char *MSG_ReadString (void)
{
  static char string[2048];
  unsigned int l;
  int c;

  l = 0;
  do
    {
      c = MSG_ReadByte ();

      if (c == 255) // skip these to avoid security problems
        continue; // with old clients and servers

      if (c == -1 || c == 0){ // msg_badread or end of string

        break;
      }

      string[l] = c;
      l++;

    }
    while (l < sizeof(string)-1);


  string[l] = 0;

  return string;
}

char *MSG_ReadStringLine (void)
{
  static char string[2048];
  unsigned int l;
  int c;

  l = 0;
  do
    {
      c = MSG_ReadByte ();
      if (c == 255)
        continue;
      if (c == -1 || c == 0 || c == '\n')
        break;
      string[l] = c;
      l++;
    }
  while (l < sizeof(string) - 1);

  string[l] = 0;

  return string;
}

float MSG_ReadCoord (void)
{
  return MSG_ReadShort() * (1.0 / 8);
}

float MSG_ReadAngle (void)
{
  return MSG_ReadChar() * (360.0 / 256);
}

float MSG_ReadAngle16 (void)
{
  return MSG_ReadShort() * (360.0 / 65536);
}


void MSG_ReadDeltaUsercmd (usercmd_t *from, usercmd_t *move, int protoversion)
{
  int bits;

  memcpy (move, from, sizeof(*move));

  bits = MSG_ReadByte ();

  if (protoversion == 26)
    {
// read current angles
      if (bits & CM_ANGLE1)
        move->angles[0] = MSG_ReadAngle16 ();
      move->angles[1] = MSG_ReadAngle16 (); // always sent
      if (bits & CM_ANGLE3)
        move->angles[2] = MSG_ReadAngle16 ();

// read movement
      if (bits & CM_FORWARD)
        move->forwardmove = MSG_ReadChar() << 3;
      if (bits & CM_SIDE)
        move->sidemove = MSG_ReadChar() << 3;
      if (bits & CM_UP)
        move->upmove = MSG_ReadChar() << 3;
    }
  else
    {
// read current angles
      if (bits & CM_ANGLE1)
        move->angles[0] = MSG_ReadAngle16 ();
      if (bits & CM_ANGLE2)
        move->angles[1] = MSG_ReadAngle16 ();
      if (bits & CM_ANGLE3)
        move->angles[2] = MSG_ReadAngle16 ();

// read movement
      if (bits & CM_FORWARD)
        move->forwardmove = MSG_ReadShort ();
      if (bits & CM_SIDE)
        move->sidemove = MSG_ReadShort ();
      if (bits & CM_UP)
        move->upmove = MSG_ReadShort ();
    }

// read buttons
  if (bits & CM_BUTTONS)
    move->buttons = MSG_ReadByte ();

  if (bits & CM_IMPULSE)
    move->impulse = MSG_ReadByte ();

// read time to run command
  if (protoversion == 26)
    {
      if (bits & CM_MSEC)
        move->msec = MSG_ReadByte ();
    }
  else
    {
      move->msec = MSG_ReadByte (); // always sent
    }
}

static int MVD_TranslateFlags(int src)
{
  int dst = 0;

  if (src & DF_EFFECTS)
    dst |= PF_EFFECTS;
  if (src & DF_SKINNUM)
    dst |= PF_SKINNUM;
  if (src & DF_DEAD)
    dst |= PF_DEAD;
  if (src & DF_GIB)
    dst |= PF_GIB;
  if (src & DF_WEAPONFRAME)
    dst |= PF_WEAPONFRAME;
  if (src & DF_MODEL)
    dst |= PF_MODEL;


  return dst;
}

#define VectorCopy(a,b)                       ((b)[0] = (a)[0], (b)[1] = (a)[1], (b)[2] = (a)[2])

#define VectorSubtract(a,b,c) ((c)[0] = (a)[0] - (b)[0], (c)[1] = (a)[1] - (b)[1], (c)[2] = (a)[2] - (b)[2])


char *svc_strings[] =
{
  "svc_bad",
  "svc_nop",
  "svc_disconnect",
  "svc_updatestat",
  "svc_version",		// [long] server version
  "svc_setview",		// [short] entity number
  "svc_sound",		// <see code>
  "svc_time",			// [float] server time
  "svc_print",		// [string] null terminated string
  "svc_stufftext",	// [string] stuffed into client's console buffer
  // the string should be \n terminated
  "svc_setangle",		// [vec3] set the view angle to this absolute value

  "svc_serverdata",	// [long] version ...
  "svc_lightstyle",	// [byte] [string]
  "svc_updatename",	// [byte] [string]
  "svc_updatefrags",	// [byte] [short]
  "svc_clientdata",	// <shortbits + data>
  "svc_stopsound",	// <see code>
  "svc_updatecolors",	// [byte] [byte]
  "svc_particle",		// [vec3] <variable>
  "svc_damage",		// [byte] impact [byte] blood [vec3] from

  "svc_spawnstatic",
  "OBSOLETE svc_spawnbinary",
  "svc_spawnbaseline",

  "svc_temp_entity",	// <variable>
  "svc_setpause",
  "svc_signonnum",
  "svc_centerprint",
  "svc_killedmonster",
  "svc_foundsecret",
  "svc_spawnstaticsound",
  "svc_intermission",
  "svc_finale",

  "svc_cdtrack",
  "svc_sellscreen",

  "svc_smallkick",
  "svc_bigkick",

  "svc_updateping",
  "svc_updateentertime",

  "svc_updatestatlong",
  "svc_muzzleflash",
  "svc_updateuserinfo",
  "svc_download",
  "svc_playerinfo",
  "svc_nails",
  "svc_choke",
  "svc_modellist",
  "svc_soundlist",
  "svc_packetentities",
  "svc_deltapacketentities",
  "svc_maxspeed",
  "svc_entgravity",

  "svc_setinfo",
  "svc_serverinfo",
  "svc_updatepl",
  "svc_nails2",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL",
  "NEW PROTOCOL"
};
