/*
	MVD_Parser
	(c) Juergen Legler
*/



#include "defaults.h"
#include "parser.h"
#include "cmdline.h"
#include "frag_parser.h"
#include "tools.h"
#include "config.h"
#include "mysql_interface.h"




/*
	Aardapel if you ever see this yes the file code is from you :D
*/

FILE *f = NULL;
int i, gb_testrun_count;

extern std::vector <char *> files;
extern int debug, test_runs, setup_msyql_weapontable;
extern double DoubleTime(void);

char  *config_file = "include/config.cfg";
char  *current_demo_name = NULL;

int main(int argc, char **argv)
{
  double _ctime = 0;
  double _itime = 0;
  int i;
  int _testrun_count = 0;
  std::vector<char *>::iterator current, end;
  char *buf;
  int len;

  CmdLine::Parse(argc,argv);

  Config::Load(config_file);

  Frag_Parser::Load_Fragfile(Config::Get_Variable_Value("fragfile",true));

  if (setup_msyql_weapontable)
    {
      MySql::Setup_WT();
      MySql::Setup_IT();
      exit(0);
    }

  current = files.begin();
  end = files.end();

  _ctime = DoubleTime();

  if (!test_runs)
    _testrun_count = 1;
  else
    _testrun_count = test_runs;

  while (current != end)
    {


      for (i=0;i<_testrun_count;i++)
        {
          gb_testrun_count = i;
          _itime = DoubleTime();
          buf = OpenFile(*current,&len);

          current_demo_name = *current;
          Parser::MVD(buf,len);
          free(buf);
#ifdef __CONSISTENCY_CHECK__
          if (!test_runs)
#endif
            printf("Time for \"%s\" - %f\n",*current,DoubleTime() - _itime);
#ifdef __CONSISTENCY_CHECK__
          else
            printf("Time for \"%s\" - %f  run number: %i\n",*current,DoubleTime() - _itime,i);
#endif
        }
      current++;

    }
  //MySql::Frame();
  printf("Time for all files %f\n",DoubleTime() - _ctime);

  return 0;
}
