#include "defaults.h"
#include <mysql/mysql.h>
#include "config.h"

typedef struct weapon_class_s
  {
    char *keyword;
    char *name;
    char *shortname;

  } weapon_class_t;

extern std::vector<weapon_class_t>   weapon_classes;

typedef struct item_cass_s
  {
    char *name;
  } item_class_t;

extern item_class_t items[];

namespace MySql {

  MYSQL *mysql = NULL;
  MYSQL_RES *result = NULL;
  MYSQL_ROW row;



  void Init (void){
    mysql = mysql_init(NULL);
    if (mysql == NULL)
      printf("mysql init failed\n");
  }

  void Connect(char *host, char *user, char *passwd, char *dbname, int mysql_port){
    if (!mysql_real_connect(mysql,host,user,passwd,dbname,mysql_port,NULL,0)){
      //printf("mysql connect failed\n");
      //printf("Mysql connect error: %s\n",mysql_error(mysql));
    }
    //printf("Mysql connect success error: %s\n",mysql_error(mysql));
  }




  void Store_Result(void){
    result = mysql_use_result(mysql);
  }

  char  **Get_Result(void){
    if (result){
      row = mysql_fetch_row(result);
      return row;
    }else{
      return NULL;
    }
  }

  void Free_Result(void){
    if (result){
      mysql_free_result(result);
      result = NULL;
    }
  }

  void Close_Connect(void){

    if (mysql)
      mysql_close(mysql);
  }

   int Query(char *querystring){
    if (mysql_query(mysql,querystring) == 0 ){
      //printf("mysql query failed %s\n",querystring);
      //printf("Mysql error: %s\n",mysql_error(mysql));
      return 0;
    }
    //printf("Mysql error: %s\n",mysql_error(mysql));

    //printf("Mysql success error: %s\n",mysql_error(mysql));

    return 1;
  }

  void Frame (void){
    Init();
    Connect("192.168.222.8","mvd","mvd_test","mvd",3306);
    Query("INSERT INTO 'player' ('name') VALUES ('testname')");
    Close_Connect();


  }

  void Setup_WT(void){
    char buf[1024];
    int i;

    Init();
    Connect(Config::Get_Variable_Value("mysql_ip",true),\
            Config::Get_Variable_Value("mysql_user",true),\
            Config::Get_Variable_Value("mysql_password",true),\
            Config::Get_Variable_Value("mysql_db",true),\
            Config::Get_Variable_IValue("mysql_port",true));


    i = 0;
    std::vector<weapon_class_t>::iterator wcurrent;
    wcurrent = weapon_classes.begin();
    while (wcurrent != weapon_classes.end()){
      sprintf(buf,"INSERT INTO `Weapon` (`Id` , `Name`) VALUES (%i, '%s');",i++,wcurrent->name);
      //printf(buf);
      Query(buf);
      wcurrent++;
    }
    Close_Connect();
  }

  void Setup_IT(void){
    char buf[1024];
    int i;

    Init();
    Connect(Config::Get_Variable_Value("mysql_ip",true),\
            Config::Get_Variable_Value("mysql_user",true),\
            Config::Get_Variable_Value("mysql_password",true),\
            Config::Get_Variable_Value("mysql_db",true),\
            Config::Get_Variable_IValue("mysql_port",true));


    for(i = 0;i<14;i++){
      sprintf(buf,"INSERT INTO `Items` (`Id` , `Name`) VALUES (%i, '%s');",i,items[i].name);
      Query(buf);
    }
    Close_Connect();
  }

}
