/*
	MVD_Parser
	(c) Juergen Legler

*/













#include "defaults.h"
#include "mvd_defs.h"
#include "common.h"
#include "frag_parser.h"
#include <math.h>
#include "mysql_interface.h"
#include "config.h"


typedef struct item_cass_s
  {
    char *name;
  } item_class_t;


item_class_t items[] =
{
  {"super shotgun"},      // 0
  {"nailgun"},            // 1
  {"super nailgun"},      // 2
  {"grenade launcher"},   // 3
  {"rocket launcher"},    // 4
  {"lightning gun"},      // 5
  {"ga"},                 // 6
  {"ya"},                 // 7
  {"ra"},                 // 8
  {"ring"},               // 9
  {"quad"},               // 10
  {"pent"},               // 11
  {"small health"},       // 12
  {"big health"},         // 13
  {"mega health"},        // 14f
};



typedef struct weapon_class_s
  {
    char *keyword;
    char *name;
    char *shortname;

  } weapon_class_t;
/*
typedef struct msg_type_s {
  char      *msg1;
  char      *msg2;
  msgtype_t type;
  int       wclass_index;


} msg_type_t;*/

//extern std::vector<msg_type_t>       frag_messages;
extern std::vector<weapon_class_t>   weapon_classes;



byte newtime;


extern int test_runs, gb_testrun_count;

int os,is;

int stat_count = 0;

int lastto,lasttype;

char *demo = NULL;

void *data = NULL;

extern char *current_demo_name;


char  print_text[2048];


extern int debug ;

bool  players_toggle = 0;

static double demotime= 0;
static double prevdemotime= -1;
static double nextdemotime= 0;
static double lasttime =  - 1;
static double oldtime =  - 1;

typedef struct h_info_s
  {
    int type;
    vec3_t  origin;
  }h_info_t;


#define SIZEOF_DEMOTIME sizeof(newtime)
typedef struct frame_info_s
  {
    int       healthcount;
    h_info_s  healthinfo[32];
    int       jumpcount;
    vec3_t    jumpinfo[32];
  }frame_info_t;

frame_info_t frame_info;

typedef struct players_s
  {
#ifdef __CONSISTENCY_CHECK__
    char    name[64];
    char    userinfo[512];
    char    team[64];
#else
    char    *name;
    char    *userinfo;
    char    *team;
#endif

    int     pnum;
    int     frame;
    int     userid;
    int     frags;
    int     spectator;
    int     stats[MAX_CL_STATS];
    float   pl;
    int     pl_count;
    float   pl_average;
    float   pl_highest;
    float   pl_lowest;
    float   ping;
    int     ping_count;
    float   ping_average;
    float   ping_highest;
    float   ping_lowest;
    int     armor_count[3];
    int     weapon_count[7];
    int     weapon_drops[7];
    int     weapon_shots[9];
    int     quad_count;
    int		  armor_took_flag;
    float   weapon_time[7];
    int     death_count;
    int     megahealth_count;
    int     ring_count;
    int     pent_count;
    int     armor_wasted[3];
    int     health_count[3];
    int     health_wasted;
    int     jump_count;
    int     damage_health[4];
    int     damage_armor[3];
    int     weaponframe;
    int     speed_frame_count;
    float   acc_average_speed;
    float   speed_highest;
    vec3_t  origin;

    int     mysql_id;

    bool    teamkill_flag;
  } players_t;

typedef struct fragstats_s
  {
    int     kills[32][64];
    int     deaths[32][64];
    int     wdeaths[64];
    int     wkills[64];
    int     tkills[64];
    int     tdeaths[64];
    int     total_frags;
    int     flag_touches;
    int     flag_dropped;
    int     flag_captured;
    int     suicides;
    int     teamkills;
  } fragstats_t ;

extern fragstats_t fragstats[32];






players_t	players[32];      // current frame playerinfo
players_t	lf_players[32];   // last    frame playerinfo
players_t	ltr_players[32];  // only used for debugging with -t

std::vector <char *>    players_events[32];

char      *sndlist[1024];

int       sndcount = 0;

typedef struct server_s
  {
    char    *serverinfo;
    bool    countdown;
    bool    match_started;

  } server_t;

server_t serverinfo;

void l_printf(char *str, ...)
{
  va_list argptr;

  if (!debug)
    return;
  va_start (argptr,str);
  vprintf(str,argptr);
  va_end(argptr);

}



void log_event(int i, int type,char *string)
{
  char buf[1024];
  char buf1[1024];

  /*va_start (argptr,string);
  vsprintf(buf,string,argptr);
  va_end(argptr);
  sprintf(buf1,"%f - %s",demotime,buf);
  */
  switch (type)
    {
    case 0:
      sprintf(buf,"\t<type>died</type>\n");
      break;
    case 1:
      sprintf(buf,"\t<type>took</type>\n\t<item>%s</item>\n",string);
      break;
    case 2:
      sprintf(buf,"\t<type>pack_drop</type>\n\t<item>%s</item>\n\t<ammo>%i %i %i %i</ammo>\n",string,lf_players[i].stats[STAT_SHELLS],lf_players[i].stats[STAT_NAILS],lf_players[i].stats[STAT_ROCKETS],lf_players[i].stats[STAT_CELLS]);
    }

  sprintf(buf1,"%s\t<time>%f</time>\n\t<location>%f %f %f</location>\n",buf,demotime,players[i].origin[0],players[i].origin[1],players[i].origin[2]);


  players_events[i].push_back(strndup(buf1,strlen(buf1)));




}


void Stats_Gather(void)
{
  players_t *cf,*lf;
  int i,x;
  for ( i=0 ; i<32 ; i++ )
    {

#ifdef __CONSISTENCY_CHECK__
      if (!players[i].spectator && players[i].userid && players[i].name[0])
#else
      if (!players[i].spectator && players[i].name)
#endif
        {

          cf = &players[i];
          lf = &lf_players[i];

          if (cf->stats[STAT_ARMOR] > lf->stats[STAT_ARMOR])
            {
              if (cf->stats[STAT_ITEMS] & IT_ARMOR1 && lf->stats[STAT_ITEMS] & IT_ARMOR1)
                {
                  cf->armor_count[0]++;
                  cf->armor_wasted[0] += lf->stats[STAT_ARMOR];
                }
              if (cf->stats[STAT_ITEMS] & IT_ARMOR2 && lf->stats[STAT_ITEMS] & IT_ARMOR2)
                {
                  cf->armor_count[1]++;
                  cf->armor_wasted[1] += lf->stats[STAT_ARMOR];
                }
              if (cf->stats[STAT_ITEMS] & IT_ARMOR3 && lf->stats[STAT_ITEMS] & IT_ARMOR3)
                {
                  cf->armor_count[2]++;
                  cf->armor_wasted[2] += lf->stats[STAT_ARMOR];
                }
            }

          if (cf->stats[STAT_HEALTH] <= 0 && lf->stats[STAT_HEALTH] > 0)
            {
              cf->death_count++;
              log_event(i,0,NULL);
            }
          if (cf->stats[STAT_HEALTH] >= 100 && cf->stats[STAT_HEALTH] > lf->stats[STAT_HEALTH] && lf->stats[STAT_ITEMS] & IT_SUPERHEALTH)
            cf->megahealth_count++;

          if (cf->teamkill_flag)
            {
              for (x = 0;x<32;x++)
                {
                  if (!players[x].spectator && players[x].name && !strcmp(players[x].team,cf->team) && lf_players[x].stats[STAT_HEALTH] && players[x].stats[STAT_HEALTH] <= 0)
                    {
                      //printf("found the fragged %s\n",players[x].name);
                      fragstats[cf->pnum].tkills[x]++;
                      fragstats[x].tdeaths[cf->pnum]++;
                      cf->teamkill_flag = false;
                      break;
                    }
                }

            }

        }


    }

  double distance,t_dist;
  int p,z;


  if (frame_info.jumpcount)
    {

      for (x=0;x<frame_info.jumpcount;x++)
        {

          for ( i=0,distance = 10000000 ; i<32 ; i++ )
            {

              p=0;
              if (!players[i].spectator && players[i].userid && players[i].name )//&& players[i].name[0])
                {

                  cf = &players[i];
                  lf = &lf_players[i];
                  vec3_t  dv;
                  VectorSubtract(frame_info.jumpinfo[x],cf->origin,dv);
                  t_dist = sqrt(pow(dv[0],2) + pow(dv[1],2) + pow(dv[2],2));
                  if (distance > t_dist)
                    {
                      distance = t_dist;
                      //printf("%f\n",distance);
                      p = i;
                    }
                }
            }

          players[p].jump_count++;
        }

    }

  if (frame_info.healthcount)
    {

      for (x=0;x<frame_info.healthcount;x++)
        {

          for ( i=0,distance = 10000000 ; i<32 ; i++ )
            {

              if (!players[i].spectator  && players[i].name)
                {


                  cf = &players[i];
                  lf = &lf_players[i];
                  vec3_t  dv;
                  VectorSubtract(frame_info.healthinfo[x].origin,cf->origin,dv);
                  t_dist = sqrt(pow(dv[0],2) + pow(dv[1],2) + pow(dv[2],2));
                  if (distance > t_dist)
                    {
                      distance = t_dist;
                      //printf("%f\n",distance);
                      p = i;
                    }
                }
            }
          switch (frame_info.healthinfo[x].type)
            {
            case 1:
              players[p].health_count[0]++;
              log_event(p,1,"small_health");
              if ((z=lf_players[p].stats[STAT_HEALTH] + 15 - 100) >0)
                players[p].health_wasted+=z;
              break;
            case 2:
              players[p].health_count[1]++;
              log_event(p,1,"big_health");
              if ((z=lf_players[p].stats[STAT_HEALTH] + 25 - 100) >0)
                players[p].health_wasted+=z;
              break;
            case 3:
              players[p].health_count[2]++;
              log_event(p,1,"mega_health");
              if ((z=lf_players[p].stats[STAT_HEALTH] + 100 - 255) >0)
                players[p].health_wasted+=z;
              break;

            }
        }
    }

  for ( i=0 ; i<32 ; i++ )
    {

#ifdef __CONSISTENCY_CHECK__
      if (!players[i].spectator && players[i].userid && players[i].name[0])
#else
      if (!players[i].spectator && players[i].userid && players[i].name)
#endif

        {

          cf = &players[i];
          lf = &lf_players[i];

          if (lf->armor_count[0] < cf->armor_count[0])
            {
              log_event(i,1,"ga");
            }
          else if (lf->armor_count[1] < cf->armor_count[1])
            {
              log_event(i,1,"ya");
            }
          else if (lf->armor_count[2] < cf->armor_count[2])
            {
              log_event(i,1,"ra");
            }

          if (lf->pent_count < cf->pent_count)
            log_event(i,1,"pent");
          if (lf->quad_count < cf->quad_count)
            log_event(i,1,"quad");
          if (lf->ring_count < cf->ring_count)
            log_event(i,1,"ring");

          if (lf->weapon_count[0] < cf->weapon_count[0])
            log_event(i,1,"ssg");
          if (lf->weapon_count[1] < cf->weapon_count[1])
            log_event(i,1,"ng");
          if (lf->weapon_count[2] < cf->weapon_count[2])
            log_event(i,1,"sng");
          if (lf->weapon_count[3] < cf->weapon_count[3])
            log_event(i,1,"gl");
          if (lf->weapon_count[4] < cf->weapon_count[4])
            log_event(i,1,"rl");
          if (lf->weapon_count[5] < cf->weapon_count[5])
            log_event(i,1,"lg");


          if ( lf->stats[STAT_HEALTH] > 0 )
            {
              vec3_t dv;
              VectorSubtract(cf->origin,lf->origin,dv);
              distance = sqrt(pow(dv[0],2) + pow(dv[1],2) + pow(dv[2],2));
              distance = distance / (demotime-oldtime);
              if (distance < 1500 && distance > 0)
                {
                  cf->acc_average_speed += distance;
                  cf->speed_frame_count++;
                  if (distance > cf->speed_highest)
                    cf->speed_highest = distance;
                }
            }
        }

    }



}




#define CHECK_ITEM (a,b,c)  (a & c && !(b & c))

bool check_stat(int item, int player_stat, int value )
{

  if (value & item && !(player_stat & item))
    return true;

  return false;

}

void SetStat(int stat, int value)
{
  players_t *cp,*lf_cp;
  cp = &players[lastto];
  lf_cp = &lf_players[lastto];
  if (serverinfo.match_started)
    {
      if (cp->stats[stat] > value)
        {
          if (stat == STAT_SHELLS)
            {
              if (cp->stats[STAT_ACTIVEWEAPON] == IT_SHOTGUN)
                cp->weapon_shots[1] += cp->stats[STAT_SHELLS] - value;
              if (cp->stats[STAT_ACTIVEWEAPON] == IT_SUPER_SHOTGUN)
                cp->weapon_shots[2] += cp->stats[STAT_SHELLS] - value;
            }
          if (stat == STAT_NAILS)
            {
              if (cp->stats[STAT_ACTIVEWEAPON] == IT_NAILGUN)
                cp->weapon_shots[3] += cp->stats[STAT_NAILS] - value;
              if (cp->stats[STAT_ACTIVEWEAPON] == IT_SUPER_NAILGUN)
                cp->weapon_shots[4] += cp->stats[STAT_NAILS] - value;
            }
          if (stat == STAT_ROCKETS)
            {
              if (cp->stats[STAT_ACTIVEWEAPON] == IT_GRENADE_LAUNCHER)
                cp->weapon_shots[5] += cp->stats[STAT_ROCKETS] - value;
              if (cp->stats[STAT_ACTIVEWEAPON] == IT_ROCKET_LAUNCHER)
                cp->weapon_shots[6] += cp->stats[STAT_ROCKETS] - value;
            }
          if (stat == STAT_CELLS)
            {
              if (cp->stats[STAT_ACTIVEWEAPON] == IT_LIGHTNING)
                cp->weapon_shots[7] += cp->stats[STAT_CELLS] - value;
            }
        }

      if (stat == STAT_ITEMS)
        {
          if (check_stat(IT_ARMOR1,cp->stats[stat],value))
            cp->armor_count[0]++;
          if (check_stat(IT_ARMOR2,cp->stats[stat],value))
            cp->armor_count[1]++;
          if (check_stat(IT_ARMOR3,cp->stats[stat],value))
            {
              cp->armor_count[2]++;
            }

          if (check_stat(IT_INVISIBILITY,cp->stats[stat],value))
            cp->ring_count++;
          if (check_stat(IT_QUAD,cp->stats[stat],value))
            cp->quad_count++;
          if (check_stat(IT_INVULNERABILITY,cp->stats[stat],value))
            cp->pent_count++;

          if (check_stat(IT_SUPER_SHOTGUN,cp->stats[stat],value))
            cp->weapon_count[0]++;
          if (check_stat(IT_NAILGUN,cp->stats[stat],value))
            cp->weapon_count[1]++;
          if (check_stat(IT_SUPER_NAILGUN,cp->stats[stat],value))
            cp->weapon_count[2]++;
          if (check_stat(IT_GRENADE_LAUNCHER,cp->stats[stat],value))
            cp->weapon_count[3]++;
          if (check_stat(IT_ROCKET_LAUNCHER,cp->stats[stat],value))
            cp->weapon_count[4]++;
          if (check_stat(IT_LIGHTNING,cp->stats[stat],value))
            cp->weapon_count[5]++;

          if (check_stat(IT_SUPERHEALTH,cp->stats[stat],value))
            cp->megahealth_count++;
        }

      if (stat == STAT_HEALTH)
        {
          if (value <= 0 )
            {
              if (cp->stats[STAT_ACTIVEWEAPON] & IT_LIGHTNING)
                {
                  cp->weapon_drops[5]++;
                  log_event(lastto,2,"lg");
                }
              if (cp->stats[STAT_ACTIVEWEAPON] & IT_ROCKET_LAUNCHER)
                {
                  cp->weapon_drops[4]++;
                  log_event(lastto,2,"rl");
                }
              if (cp->stats[STAT_ACTIVEWEAPON] & IT_GRENADE_LAUNCHER)
                {
                  cp->weapon_drops[3]++;
                  log_event(lastto,2,"gl");
                }
              if (cp->stats[STAT_ACTIVEWEAPON] & IT_SUPER_NAILGUN)
                {
                  cp->weapon_drops[2]++;
                  log_event(lastto,2,"sng");
                }
              if (cp->stats[STAT_ACTIVEWEAPON] & IT_NAILGUN)
                {
                  cp->weapon_drops[1]++;
                  log_event(lastto,2,"ng");
                }
              if (cp->stats[STAT_ACTIVEWEAPON] & IT_SUPER_SHOTGUN)
                {
                  cp->weapon_drops[0]++;
                  log_event(lastto,2,"ssg");
                }
            }
          if (cp->stats[stat] > value)
            if (cp->stats[STAT_ITEMS] & IT_ARMOR1)
              cp->damage_health[0] += cp->stats[stat] - value;
            else if (cp->stats[STAT_ITEMS] & IT_ARMOR2)
              cp->damage_health[1] += cp->stats[stat] - value;
            else if (cp->stats[STAT_ITEMS] & IT_ARMOR3)
              cp->damage_health[2] += cp->stats[stat] - value;
            else if (!(cp->stats[STAT_ITEMS] & IT_ARMOR3)&&!(cp->stats[STAT_ITEMS] & IT_ARMOR2)&&!(cp->stats[STAT_ITEMS] & IT_ARMOR1))
              cp->damage_health[3] += cp->stats[stat] - value;
        }

      if (stat == STAT_ARMOR)
        {
          if (cp->stats[stat] > value)
            if (cp->stats[STAT_ITEMS] & IT_ARMOR1)
              cp->damage_armor[0] += cp->stats[stat] - value;
            else if (cp->stats[STAT_ITEMS] & IT_ARMOR2)
              cp->damage_armor[1] += cp->stats[stat] - value;
            else if (cp->stats[STAT_ITEMS] & IT_ARMOR3)
              cp->damage_armor[2] += cp->stats[stat] - value;

        }
    }



  players[lastto].stats[stat] = value;


}

char *Get_Userinfo_Value_By_Key(char *key, char *userinfo)
{
  char buf[128];
  char *index = NULL;
  char *index_org = NULL;
  int _size = 0;


  sprintf(buf,"\\%s\\",key);
  index =	strstr(userinfo,buf);
  //printf("Getuserinfo: %s in %s\n",key,userinfo);
  //printf("%i\n",index);
  if (index == NULL)
    return NULL;
  index += strlen(buf);
  index_org = index;
  while (*index != '\\' && *index != 0)
    {
      _size++;
      index++;
    }

  return strndup(index_org,_size);

}


double DoubleTime (void)
{
  struct timeval tp;
  struct timezone tzp;
  static int secbase;

  gettimeofday(&tp, &tzp);

  if (!secbase)
    {
      secbase = tp.tv_sec;
      return tp.tv_usec/1000000.0;
    }

  return (tp.tv_sec - secbase) + tp.tv_usec / 1000000.0;

}

void Parse_Serverinfo(char *key, char *value)
{
  if (!strcmp(key,"status"))
    {
      if (strcmp(value,"Countdown"))
        {
          serverinfo.match_started = true;
        }
    }
}


void Process_Stufftext(char *stufftext)
{

  if (strstr(stufftext,"fullserverinfo"))
    {
      l_printf("fullserverinfo recieved\n %s \n",stufftext);
      serverinfo.serverinfo = strdup(stufftext);
    }

}


void MVD_Read(void *buf, int size)
{
  memcpy(buf,demo,size);
  demo += size;
}

bool MVD_Frame(char *buf)
{
  static int x = 0;
  int cursize;
  int i;


  if (prevdemotime < nextdemotime)
    prevdemotime = nextdemotime;

  if (demotime + 1.0 < nextdemotime - 1.0)
    demotime = nextdemotime - 1.0;


  if (lasttime != demotime)
    {
      l_printf("MVD Frame %i: %f\n",x++,demotime);
      l_printf("memory needed : %f\n",((x-1) * sizeof(players) * 32 )/1000.0);
      oldtime = lasttime;
      lasttime = demotime;

    }

readnext:
  MVD_Read(&newtime,SIZEOF_DEMOTIME);

  demotime = prevdemotime + newtime *0.001;
  if (demotime - nextdemotime > 0.0001 && nextdemotime != demotime)
    nextdemotime = demotime;

  byte c;
  MVD_Read(&c,sizeof(c));

  switch ((c & 7))
    {
      // user sent input
    case dem_cmd:
      l_printf("User sent input\n");
      demo += sizeof(usercmd_t);
      demo += 12;

      goto readnext;


      // get the next message

    case dem_read:
readit:
      MVD_Read(&cursize,4);
      cursize = LittleLong(cursize);
      net_message.cursize = cursize;
      net_message.data = (byte*)malloc(cursize);
      MVD_Read(net_message.data,cursize);
      switch (lasttype)
        {
        case dem_multiple:
          goto readnext;
          break;
          //goto readnext;

        case dem_single:
          break;
        }
      return true;



    case dem_set:
      MVD_Read(&i,sizeof(i));
      os = LittleLong(i);
      MVD_Read(&i,sizeof(i));
      is = LittleLong(i);
      goto readnext;


    case dem_multiple:
      MVD_Read(&i,sizeof(i));
      lastto = LittleLong(i);
      lasttype = dem_multiple;
      goto readit;

    case dem_single:
      lastto = c >> 3;
      lasttype = dem_single;
      goto readit;

    case dem_stats:
      lastto = c >> 3;
      lasttype = dem_stats;
      goto readit;

    case dem_all:
      lastto = 0;
      lasttype = dem_all;
      goto readit;

    default:
      printf("error parsing file\n");
      exit(1);




    }

}


void Parse_Damage(void)
{
  int armor, blood, i;
  vec3_t from;//, forward, right;
  //float side, count, fraction;


  armor = MSG_ReadByte ();
  blood = MSG_ReadByte ();
  for (i = 0; i < 3; i++)
    from[i] = MSG_ReadCoord ();
}

void ParseServerData(void)
{
  int protover = MSG_ReadLong();
  int servercount = MSG_ReadLong();
  char *gamedir = MSG_ReadString();
  float demotime = MSG_ReadFloat();
  char *levelname = MSG_ReadString();


  l_printf("Server data Package\n");
  l_printf("protocol Version: %i\n",protover);
  l_printf("servercount     : %i\n",servercount);
  l_printf("gamedir		: %s\n",gamedir);
  l_printf("demotime	: %f\n",demotime);
  l_printf("levelname	: %s\n",levelname);
  for (int i = 0;i <10;i++)
    l_printf ("movevar %i	: %f\n",i,MSG_ReadFloat());


}

void ParsePlayerinfo(void)
{
  int num = MSG_ReadByte ();
  int i;
  if (num >= 32)
    {
      l_printf("only 32 players allowed !\n");
      free(data);
      exit(1);
    }

  int flags ;
  flags = MSG_ReadShort();
  players[num].frame = MSG_ReadByte();
  players[num].pnum = num;
  int iflags;
  iflags = MVD_TranslateFlags(flags);

  for (i = 0; i<3;i++)
    {
      if (flags & (DF_ORIGIN << i))
        {
          players[num].origin[i] = MSG_ReadCoord();
          //l_printf("origin %i: %f\n",i,);
        }
    }

  for (i = 0; i<3;i++)
    {
      if (flags & (DF_ANGLES << i))
        l_printf("angles %i: %f\n",i,MSG_ReadAngle16());
    }

  if (flags & DF_MODEL)
    MSG_ReadByte(); // Modelindex


  if (flags & DF_SKINNUM)
    MSG_ReadByte(); // skinnum

  if (flags & DF_EFFECTS)
    MSG_ReadByte(); // Modelindex

  if (flags & DF_WEAPONFRAME)
    players[num].weaponframe = MSG_ReadByte(); // Modelindex

}

void MVD_Parse_Data(void *data)
{
  int cmd;
  int pnum;
  int level;
  int i;
  char *s,*t;
  int channel;
  int type;
  int j,k;




  while (1)
    {
      if (msg_badread)
        {
          l_printf("demo_error cmd: %i\n",cmd);
          free(net_message.data);
          exit(1);
          return;
        }


      cmd = MSG_ReadByte();

      if (cmd == -1)
        {

          msg_readcount++;
          break;
        }
      l_printf ("cmd: %s\n",svc_strings[cmd]);

      switch (cmd)
        {
        default:
          l_printf("error! %i\n",cmd);
          free(net_message.data);
//          exit(1);
          return;


        case svc_nop:
          break;

        case svc_disconnect:
          l_printf("disconnect\n");
          //exit(0);
          //return;
          break;

        case nq_svc_time:
          MSG_ReadFloat ();
          break;

        case svc_print:
          level = MSG_ReadByte();
          s = MSG_ReadString();
          //printf("%i\n",level);
          if (level == 1 || level == 2)
            {
              strcat(print_text,s);
              //printf("%s\n",print_text);
              if (print_text[strlen(print_text)-1] == '\n')
                {
                  static double _cltime;
                  double _ltime = DoubleTime();
                  l_printf("before the parser: %s\n",s);
                  Frag_Parser::Parse(print_text);
                  l_printf("%f\n",DoubleTime() - _ltime);
                  _cltime += DoubleTime() - _ltime;
                  l_printf("%f\n",_cltime);
                  memset(&print_text,0,sizeof(print_text));
                }

            }

          char *p;
          for (p=s ; *p ; p++ )
            {
              if (*p <0)
                {
                  *p +=128;
                }
            }
          l_printf("%i %s\n",level,s);
          break;

        case svc_centerprint:
          s = MSG_ReadString();

          l_printf("%s\n",s);
          break;

        case svc_stufftext:
          s = MSG_ReadString ();
          Process_Stufftext(s);
          l_printf("stufftext : %s",s);
          break;

        case svc_damage:
          Parse_Damage();
          break;


        case svc_serverdata:
          ParseServerData ();
          break;

        case svc_cdtrack:
          l_printf("CD Track: %i\n", MSG_ReadByte ());
          break;

        case svc_playerinfo:
          ParsePlayerinfo();
          break;

        case svc_modellist:
          MSG_ReadByte(); // number of models
          while (1)
            {
              s = MSG_ReadString();
              //printf("YES %s\n",s);
              if (!s[0])
                break;
            }
          MSG_ReadByte();
          break;

        case svc_soundlist:
          //number of sounds
          sndcount = MSG_ReadByte();
          l_printf("svc_soundlist %i:\n",sndcount);
          while (1)
            {
              s = MSG_ReadString();
              l_printf("%s\n",s);

              if (!s[0])
                break;
              sndcount++;
              sndlist[sndcount] = strdup(s);
            }
          MSG_ReadByte();
          break;

        case svc_spawnstaticsound:
          for (i=0;i<3;i++)
            MSG_ReadCoord();	// location
          MSG_ReadByte();			// number
          MSG_ReadByte();			// vol
          MSG_ReadByte();			// atten
          break;

        case svc_spawnbaseline:
          MSG_ReadShort(); // entity
          MSG_ReadByte();	// modelindex
          MSG_ReadByte();	// frame
          MSG_ReadByte();	// colormap
          MSG_ReadByte();	// skinnum

          for (i=0;i<3;i++)
            {
              MSG_ReadCoord();	//origin
              MSG_ReadAngle();	//angles
            }
          break;

        case svc_updatefrags:
          pnum = MSG_ReadByte(); //player
          players[pnum].frags = MSG_ReadShort(); // frags
          break;

        case svc_updateping:
          pnum = MSG_ReadByte();
          players[pnum].ping = MSG_ReadShort();; //player
          players[pnum].ping_average += players[pnum].ping;
          players[pnum].ping_count++;

          if (players[pnum].ping > players[pnum].ping_highest)
            players[pnum].ping_highest = players[pnum].ping;

          if (players[pnum].ping < players[pnum].ping_lowest)
            players[pnum].ping_lowest = players[pnum].ping;
          break;

        case svc_updatepl:
          pnum = MSG_ReadByte();
          players[pnum].pl = MSG_ReadByte();
          players[pnum].pl_average += players[pnum].pl;
          players[pnum].pl_count++;

          if (players[pnum].pl > players[pnum].pl_highest)
            players[pnum].pl_highest = players[pnum].pl;

          if (players[pnum].pl < players[pnum].pl_lowest)
            players[pnum].pl_lowest = players[pnum].pl;
          break;

        case svc_updateentertime:
          MSG_ReadByte();
          MSG_ReadFloat();
          break;


        case svc_updateuserinfo:
          pnum = MSG_ReadByte (); // player
          players[pnum].userid = MSG_ReadLong (); // userid

          s = strdup(MSG_ReadString());

          if (!strlen(s))
            break;

#ifdef __CONSISTENCY_CHECK__
          strcpy(players[pnum].userinfo, s);//userinfo
          free(s);
#else

          players[pnum].userinfo = s;


#endif

          //printf("%s\n",players[pnum].userinfo);

          //players[pnum].name = strcpy(Get_Userinfo_Value_By_Key("name",players[pnum].userinfo);
#ifdef __CONSISTENCY_CHECK__
          if (Get_Userinfo_Value_By_Key("name",players[pnum].userinfo))
            strcpy(players[pnum].name, Get_Userinfo_Value_By_Key("name",players[pnum].userinfo));
#else

          players[pnum].name = Get_Userinfo_Value_By_Key("name",players[pnum].userinfo);
          //printf("%s\n",players[pnum].name);
#endif

          //printf("test %s\n",players[pnum].userinfo);
          //players[pnum].team = Get_Userinfo_Value_By_Key("team",players[pnum].userinfo);
#ifdef __CONSISTENCY_CHECK__
          if (Get_Userinfo_Value_By_Key("team",players[pnum].userinfo))
            strcpy(players[pnum].team, Get_Userinfo_Value_By_Key("team",players[pnum].userinfo));
#else
          players[pnum].team = Get_Userinfo_Value_By_Key("team",players[pnum].userinfo);
#endif



          s = Get_Userinfo_Value_By_Key("*spectator",players[pnum].userinfo);
          if (s == NULL)
            {

              players[pnum].spectator = 0;
            }
          else
            {

              players[pnum].spectator = atoi(s);
              //free(s);
              s = NULL;
            }
          //l_printf("%s\n",s);
          break;

        case svc_lightstyle:
          MSG_ReadByte();
          MSG_ReadString();
          break;

        case svc_bad:
          l_printf("bad packet ?\n");
          break;

        case svc_serverinfo:
          s = strdup(MSG_ReadString());
          t = strdup(MSG_ReadString());
          Parse_Serverinfo(s,t);

          free(s);
          free(t);
          break;


        case svc_packetentities:

          while (1)
            {
              int word = (unsigned short)MSG_ReadShort (); // no clue :P
              if (msg_badread)
                {
                  l_printf("packet ents errpr\n");
                  msg_badread = false;
                  break;
                }

              if (!word)
                break;
              word &= ~511;
              int bits = word;
              if (bits & U_MOREBITS)
                {
                  i = MSG_ReadByte();
                  bits |= i;
                }

              if (bits & U_MODEL)
                MSG_ReadByte();
              if (bits & U_FRAME)
                MSG_ReadByte();
              if (bits & U_COLORMAP)
                MSG_ReadByte();
              if (bits & U_SKIN)
                MSG_ReadByte();
              if (bits & U_EFFECTS)
                MSG_ReadByte();
              if (bits & U_ORIGIN1)
                MSG_ReadCoord();
              if (bits & U_ORIGIN2)
                MSG_ReadCoord();
              if (bits & U_ORIGIN3)
                MSG_ReadCoord();
              if (bits & U_ANGLE1)
                MSG_ReadAngle();
              if (bits & U_ANGLE2)
                MSG_ReadAngle();
              if (bits & U_ANGLE3)
                MSG_ReadAngle();

            }
          break;

        case svc_updatestatlong:
          j = MSG_ReadByte();
          k = MSG_ReadLong();
          SetStat(j,k);
          break;

        case svc_updatestat:
          j = MSG_ReadByte();
          k = MSG_ReadByte();
          SetStat(j,k);
          break;

        case svc_deltapacketentities:
          MSG_ReadByte();//from
          if (os - is >= UPDATE_BACKUP -1)
            break;

          if ((os - is -1) >= UPDATE_BACKUP -1)
            break;


          while (1)
            {
              int word = (unsigned short)MSG_ReadShort (); // no clue :P
              if (msg_badread)
                {
                  l_printf("delta ents error\n");
                  break;
                }

              if (!word)
                break;
              word &= ~511;
              int bits = word;
              if (bits & U_MOREBITS)
                {
                  i = MSG_ReadByte();
                  bits |= i;
                }

              if (bits & U_MODEL)
                MSG_ReadByte();
              if (bits & U_FRAME)
                MSG_ReadByte();
              if (bits & U_COLORMAP)
                MSG_ReadByte();
              if (bits & U_SKIN)
                MSG_ReadByte();
              if (bits & U_EFFECTS)
                MSG_ReadByte();
              if (bits & U_ORIGIN1)
                MSG_ReadCoord();
              if (bits & U_ORIGIN2)
                MSG_ReadCoord();
              if (bits & U_ORIGIN3)
                MSG_ReadCoord();
              if (bits & U_ANGLE1)
                MSG_ReadAngle();
              if (bits & U_ANGLE2)
                MSG_ReadAngle();
              if (bits & U_ANGLE3)
                MSG_ReadAngle();
            }
          break;


        case svc_sound:
          channel = MSG_ReadShort();//Channel
          if (channel & SND_VOLUME)
            MSG_ReadByte();
          if (channel & SND_ATTENUATION)
            MSG_ReadByte();
          l_printf("soundplayed:\n");
          i = MSG_ReadByte();
          vec3_t  loc;
          for (j=0;j<3;j++)
            loc[j]= MSG_ReadCoord();

          if (!strcmp("items/r_item1.wav",sndlist[i]))
            {
              frame_info.healthinfo[frame_info.healthcount].type = 1;
              VectorCopy(loc,frame_info.healthinfo[frame_info.healthcount].origin);
              frame_info.healthcount++;
            }
          if (!strcmp("items/health1.wav",sndlist[i]))
            {
              frame_info.healthinfo[frame_info.healthcount].type = 2;
              VectorCopy(loc,frame_info.healthinfo[frame_info.healthcount].origin);
              frame_info.healthcount++;
            }
          if (!strcmp("items/r_item2.wav",sndlist[i]))
            {
              frame_info.healthinfo[frame_info.healthcount].type = 3;
              VectorCopy(loc,frame_info.healthinfo[frame_info.healthcount].origin);
              frame_info.healthcount++;
            }
          if (!strcmp("player/plyrjmp8.wav",sndlist[i]))
            {
              VectorCopy(loc,frame_info.jumpinfo[frame_info.jumpcount]);
              frame_info.jumpcount++;
            }

          l_printf("%-22s ",sndlist[i]);

          l_printf("@ x: %12f - y: %12f - z: %12f\n",loc[0],loc[1],loc[2]);
          break;

        case svc_temp_entity:
          type = MSG_ReadByte();

          if (type == TE_GUNSHOT || type == TE_BLOOD)
            MSG_ReadByte ();

          if (type == TE_LIGHTNING1 || type == TE_LIGHTNING2 || type ==  TE_LIGHTNING3)
            {
              MSG_ReadShort();
              MSG_ReadCoord();
              MSG_ReadCoord();
              MSG_ReadCoord();

            }

          MSG_ReadCoord();
          MSG_ReadCoord();
          MSG_ReadCoord();


          break;


        case svc_setangle:
          MSG_ReadByte();
          MSG_ReadAngle();
          MSG_ReadAngle();
          MSG_ReadAngle();
          break;

        case svc_setinfo:
          i = MSG_ReadByte();
          s = strdup(MSG_ReadString());
          t = strdup(MSG_ReadString());
          if (!strcmp(s,"name"))
            {
              free(players[i].name);
              players[i].name=strdup(t);
              l_printf("renamed !: %s\n",t);
            }
          l_printf ("client %i: %s %s\n",i,s,t);
          free(s);
          free(t);
          break;

        case svc_muzzleflash:
          MSG_ReadShort();
          break;

        case svc_smallkick:
          break;

        case svc_bigkick:
          break;

        case svc_intermission:
          MSG_ReadCoord ();
          MSG_ReadCoord ();
          MSG_ReadCoord ();
          MSG_ReadAngle ();
          MSG_ReadAngle ();
          MSG_ReadAngle ();
          break;

        case svc_chokecount:
          MSG_ReadByte ();
          break;

        case svc_spawnstatic:
          MSG_ReadByte();
          MSG_ReadByte();
          MSG_ReadByte();
          MSG_ReadByte();
          MSG_ReadCoord();
          MSG_ReadAngle();
          MSG_ReadCoord();
          MSG_ReadAngle();
          MSG_ReadCoord();
          MSG_ReadAngle();
          break;

        case svc_foundsecret:
          break;

        case svc_maxspeed:
          MSG_ReadFloat();
          break;

        case svc_nails2:
          int x = MSG_ReadByte();
          for (i = 0;i<x;i++)
            {
              MSG_ReadByte();

              MSG_ReadByte();
              MSG_ReadByte();
              MSG_ReadByte();
              MSG_ReadByte();
              MSG_ReadByte();
              MSG_ReadByte();


            }
          break;

        }




    }

}



extern int print_player_info;

namespace Parser
  {
    static int cnt = 0;
    static double _time;
    void MVD (char *buf,int len)
    {
      std::vector<char *>::iterator current;
      _time = DoubleTime();
      demo = buf;
      memset(&players,0,sizeof(players_t)*32);
      memset(&lf_players,0,sizeof(players_t)*32);
      memset(&serverinfo,0,sizeof(server_t));
      memset(&sndlist,0,sizeof(char *)*1024);
      for (int x = 0;x<32;x++)
        {
          players[x].ping_lowest = 999;
          players[x].pl_lowest = 999;
          players[x].spectator = 1;
        }
      while (demo - buf < len-17)
        {

          l_printf("demosizes: %i %i\n",demo-buf,len);
          memset(&frame_info,0,sizeof(frame_info_t));
          MSG_BeginReading();
          MVD_Frame(demo);

          if (net_message.data)
            {
              //printf("%s\n",net_message.data);
              MVD_Parse_Data(net_message.data);
              if (net_message.data)
                free(net_message.data);
              net_message.data = NULL;
            }
          l_printf("Framecount: %i\n",cnt);
          cnt++;

          if (serverinfo.match_started)
            {
              Stats_Gather();
            }


          memcpy(lf_players,players,sizeof(players_t) * 32);


        }

      _time = DoubleTime() - _time;
      //if (!print_player_info)
      //return;

#ifdef __CONSISTENCY_CHECK__
      if (gb_testrun_count == 0 )
        {
          memcpy(ltr_players,players,sizeof(players_t) * 32);
        }
      else
        {
          if (!memcmp(&players,&ltr_players,sizeof(players_t)*32))
            printf("memory check was ok\n");
          else
            printf("memory check failed\n");
          memcpy(ltr_players,players,sizeof(players_t) * 32);
        }
#endif


      if (print_player_info == 1 )
        {
          for (int i = 0 ; i<32  ;i++)
            if (players[i].userid && !players[i].spectator && players[i].name)
              {

                printf("%s :\n",players[i].name);
                printf("team  : %s\n",players[i].team);
                printf("frags : %i\n",players[i].frags);
                printf("deaths: %i\n",players[i].death_count);
                printf("health: %i\n",players[i].stats[STAT_HEALTH]);
                printf("armor : %i\n",players[i].stats[STAT_ARMOR]);
                printf("ping  : average: %-10f - highest: %-10f - lowest: %-10f\n",players[i].ping_average/players[i].ping_count,players[i].ping_highest,players[i].ping_lowest);
                printf("pl    : average: %-10f - highest: %-10f - lowest: %-10f\n",players[i].pl_average/players[i].pl_count,players[i].pl_highest,players[i].pl_lowest);
                printf("health: took  : sh:%4i bh:%4i mh:%4i\n",players[i].health_count[0],players[i].health_count[1],players[i].health_count[2]);
                printf("health: wasted: %4i\n",players[i].health_wasted);
                printf("armors: took  : ga:%4i ya:%4i ra:%4i\n",players[i].armor_count[0],players[i].armor_count[1],players[i].armor_count[2]);
                printf("armors: wasted: ga:%4i ya:%4i ra:%4i\n",players[i].armor_wasted[0],players[i].armor_wasted[1],players[i].armor_wasted[2]);
                printf("mh    : %i\n",players[i].megahealth_count);
                printf("pups  : r:%i - q:%i - p:%i \n",players[i].ring_count,players[i].quad_count,players[i].pent_count);
                printf("sg    : tooks:%3i  - drops:%3i  - fired:%5i\n",0,0,players[i].weapon_shots[1]);
                printf("ssg   : tooks:%3i  - drops:%3i  - fired:%5i\n",players[i].weapon_count[0],players[i].weapon_drops[0],players[i].weapon_shots[2]);
                printf("ng    : tooks:%3i  - drops:%3i  - fired:%5i\n",players[i].weapon_count[1],players[i].weapon_drops[1],players[i].weapon_shots[3]);
                printf("sng   : tooks:%3i  - drops:%3i  - fired:%5i\n",players[i].weapon_count[2],players[i].weapon_drops[2],players[i].weapon_shots[4]);
                printf("gl    : tooks:%3i  - drops:%3i  - fired:%5i\n",players[i].weapon_count[3],players[i].weapon_drops[3],players[i].weapon_shots[5]);
                printf("rl    : tooks:%3i  - drops:%3i  - fired:%5i\n",players[i].weapon_count[4],players[i].weapon_drops[4],players[i].weapon_shots[6]);
                printf("lg    : tooks:%3i  - drops:%3i  - fired:%5i\n",players[i].weapon_count[5],players[i].weapon_drops[5],players[i].weapon_shots[7]);
                printf("jumps : %i\n",players[i].jump_count);
                printf("damage taken:\n");
                printf("armor : ga:%4i ya:%4i ra:%4i\n",players[i].damage_armor[0],players[i].damage_armor[1],players[i].damage_armor[2]);
                printf("health: ga:%4i ya:%4i ra:%4i na:%4i\n",players[i].damage_health[0],players[i].damage_health[1],players[i].damage_health[2],players[i].damage_health[3]);
                printf("speed : average: %f - highest: %f\n",(float)players[i].acc_average_speed/players[i].speed_frame_count,players[i].speed_highest);
                printf("kills:\n");
                for (int z =0;z<32;z++)
                  {
                    if (players[z].name && !players[z].spectator)
                      if (strcmp(players[z].name,players[i].name))
                        if (strcmp(players[i].team,players[z].team))
                          {
                            printf("%10s : ",players[z].name);
                            for (int y = 0;y<64;y++)
                              {
                                if (fragstats[i].kills[z][y] == 0)
                                  continue;
                                printf("%s:%i ",weapon_classes[y].shortname,fragstats[i].kills[z][y]);
                              }
                            printf("\n");
                          }


                  }
                printf("frags: total: %i\n",fragstats[i].total_frags);
                printf("flags:\n");
                printf("touched :  %i\n",fragstats[i].flag_touches);
                printf("dropped :  %i\n",fragstats[i].flag_dropped);
                printf("captured:  %i\n",fragstats[i].flag_captured);
                //printf("events:\n");

                current = players_events[i].begin();
                /*while (current != players_events[i].end()){
                  printf("%s\n",*current);
                  current++;
                }*/

                printf("\n\n");
              }

          printf("Serverinfo:\n");
          printf("Hostname    :   %s\n",Get_Userinfo_Value_By_Key("hostname",serverinfo.serverinfo));
          printf("Map         :   %s\n",Get_Userinfo_Value_By_Key("map",serverinfo.serverinfo));
          printf("Location    :   %s\n",Get_Userinfo_Value_By_Key("location",serverinfo.serverinfo));
          printf("Admin       :   %s\n",Get_Userinfo_Value_By_Key("*admin",serverinfo.serverinfo));
          printf("Teamplay    :   %s\n",Get_Userinfo_Value_By_Key("teamplay",serverinfo.serverinfo));
          printf("Timelimit   :   %s\n",Get_Userinfo_Value_By_Key("timelimit",serverinfo.serverinfo));
          printf("Maxclients  :   %s\n",Get_Userinfo_Value_By_Key("maxclients",serverinfo.serverinfo));


          int grac =0;
          int gyac =0;
          int ggac = 0;

          for (int i = 0; i<32;i++)
            if (players[i].userid && !players[i].spectator )
              {
                ggac += players[i].armor_count[0];
                gyac += players[i].armor_count[1];
                grac += players[i].armor_count[2];
              }

          printf("\nOverallinfo:\n");
          printf("armor count:  ga: %i - ya: %i - ra: %i\n",ggac,gyac,grac);
          printf("runtime: %f\n",_time);
        }



      //MySql::Init();
      char lbuf[1024];
      char **sqlr;
      int _team_id;
      int _team_id_1  = -1;
      int _team_id_2  = -1;

      MySql::Init();
      MySql::Connect(Config::Get_Variable_Value("mysql_ip",true),\
                     Config::Get_Variable_Value("mysql_user",true),\
                     Config::Get_Variable_Value("mysql_password",true),\
                     Config::Get_Variable_Value("mysql_db",true),\
                     Config::Get_Variable_IValue("mysql_port",true));

      for (int i = 0; i<32;i++)
        if (!players[i].spectator && players[i].name )
          {
            // checking the team
            sqlr = NULL;
            sprintf(lbuf,"SELECT `Id` FROM `Team` where `Name` = '%s';",players[i].team);
            MySql::Query(lbuf);
            MySql::Store_Result();
            sqlr = MySql::Get_Result();
            if (!sqlr)
              {
                MySql::Free_Result();
                sprintf(lbuf,"INSERT INTO `Team` (`Name`) VALUES ('%s');",players[i].team);
                MySql::Query(lbuf);
                //printf("%s\n",lbuf);
                MySql::Store_Result();
                sqlr = MySql::Get_Result();
                if (sqlr)
                  {

                    //printf("%s\n",*sqlr);
                  }
                MySql::Free_Result();
                sprintf(lbuf,"SELECT `Id` FROM `Team` where `Name` = '%s';",players[i].team);
                MySql::Query(lbuf);
                MySql::Store_Result();
                sqlr = NULL;
                sqlr = MySql::Get_Result();
              }
            if (sqlr)
              {

                //printf("%s\n",*sqlr);
                _team_id = atoi(*sqlr);
                if (_team_id_1 == -1)
                  _team_id_1 = _team_id;
                if (_team_id_1 != _team_id && _team_id_2 == -1)
                  _team_id_2 = _team_id;

              }

            MySql::Free_Result();

            // Adding the player to the db
            sqlr = NULL;
            sprintf(lbuf,"SELECT `Id` FROM `Player` where `Nick` = '%s';",players[i].name);
            MySql::Query(lbuf);
            MySql::Store_Result();
            sqlr = MySql::Get_Result();
            if (!sqlr)
              {
                MySql::Free_Result();
                sprintf(lbuf,"INSERT INTO `Player` (`Nick`, `TeamId`) VALUES ('%s', %i);",players[i].name,_team_id);
                MySql::Query(lbuf);
                //printf("%s\n",lbuf);
                MySql::Store_Result();
                sqlr = MySql::Get_Result();
                if (sqlr)
                  {
                  }
              }
            MySql::Free_Result();
          }

      //printf("%i %i\n",_team_id_1,_team_id_2);
      // setting up gameid
      int _game_id;
      sqlr = NULL;
      sprintf(lbuf,"SELECT `Id` FROM `Game` where `DemoName` = '%s';",current_demo_name);
      MySql::Query(lbuf);
      MySql::Store_Result();
      sqlr = MySql::Get_Result();
      if (!sqlr)
        {
          MySql::Free_Result();
          sprintf(lbuf,"INSERT INTO `Game` (`DemoName`, `TeamA`, `TeamB`) VALUES ('%s', %i, %i);",current_demo_name,_team_id_1,_team_id_2);
          MySql::Query(lbuf);
          MySql::Store_Result();
          sqlr = MySql::Get_Result();
          if (sqlr)
            {

              //printf("%s\n",*sqlr);
            }
          MySql::Free_Result();
          sprintf(lbuf,"SELECT `Id` FROM `Game` where `DemoName` = '%s';",current_demo_name);
          MySql::Query(lbuf);
          MySql::Store_Result();
          sqlr = NULL;
          sqlr = MySql::Get_Result();

        }
      if (sqlr)
        {
          _game_id = atoi(*sqlr);
        }

      MySql::Free_Result();
      //printf("Game ID: %i\n",_game_id);


      //add kills into db
      for (int y = 0; y<32;y++)
        if (players[y].name && !players[y].spectator)
          {
            sqlr = NULL;
            sprintf(lbuf,"SELECT `Id` FROM `Player` where `Nick` = '%s';",players[y].name);
            MySql::Query(lbuf);
            MySql::Store_Result();
            sqlr = MySql::Get_Result();
            if (sqlr)
              {
                int _current_player_id = atoi(*sqlr);
                players[y].mysql_id = _current_player_id;
              }
            MySql::Free_Result();
          }

      //add kills per weapon with killed
      for (int y=0;y<32;y++)
        if (players[y].name && !players[y].spectator)
          {

            for (int x = 0;x<32;x++)
              {
                for (int z = 0; z<64;z++)
                  if (fragstats[y].kills[x][z] > 0)
                    {
                      sprintf(lbuf,"INSERT INTO `Fragcount_vp` (`GameId`, `PlayerId`, `KilledId`, `WeaponId`, `Count`) VALUES (%i, %i, %i, %i, %i);",_game_id,players[y].mysql_id,players[x].mysql_id,z,fragstats[y].kills[x][z]);
                      MySql::Query(lbuf);
                      MySql::Store_Result();
                      MySql::Get_Result();
                      MySql::Free_Result();
                    }


              }

            if (fragstats[y].suicides > 0)
              {
                sprintf(lbuf,"INSERT INTO `Suicides` (`GameId`, `PlayerId`, `Count`) VALUES (%i, %i, %i);",_game_id,players[y].mysql_id,fragstats[y].suicides);
                MySql::Query(lbuf);
                MySql::Store_Result();
                MySql::Get_Result();
                MySql::Free_Result();
              }
            for (int x=0;x<6;x++)
              if (players[y].weapon_count[x+1] > 0)
                {
                  sprintf(lbuf,"INSERT INTO `Itemcount` (`GameId`, `PlayerId`, `ItemId`, `Count`) VALUES (%i, %i, %i, %i);",_game_id,players[y].mysql_id,x,players[y].weapon_count[x+2]);
                  MySql::Query(lbuf);
                  MySql::Store_Result();
                  MySql::Get_Result();
                  MySql::Free_Result();
                }
            for (int x=0;x<3;x++)
              if (players[y].armor_count[x] > 0)
                {
                  sprintf(lbuf,"INSERT INTO `Itemcount` (`GameId`, `PlayerId`, `ItemId`, `Count`) VALUES (%i, %i, %i, %i);",_game_id,players[y].mysql_id,x+6,players[y].armor_count[x]);
                  MySql::Query(lbuf);
                  MySql::Store_Result();
                  MySql::Get_Result();
                  MySql::Free_Result();
                }

            if (players[y].ring_count > 0)
              {
                sprintf(lbuf,"INSERT INTO `Itemcount` (`GameId`, `PlayerId`, `ItemId`, `Count`) VALUES (%i, %i, %i, %i);",_game_id,players[y].mysql_id,9,players[y].ring_count);
                MySql::Query(lbuf);
                MySql::Store_Result();
                MySql::Get_Result();
                MySql::Free_Result();
              }
            if (players[y].quad_count > 0)
              {
                sprintf(lbuf,"INSERT INTO `Itemcount` (`GameId`, `PlayerId`, `ItemId`, `Count`) VALUES (%i, %i, %i, %i);",_game_id,players[y].mysql_id,10,players[y].quad_count);
                MySql::Query(lbuf);
                MySql::Store_Result();
                MySql::Get_Result();
                MySql::Free_Result();
              }
            if (players[y].pent_count > 0)
              {
                sprintf(lbuf,"INSERT INTO `Itemcount` (`GameId`, `PlayerId`, `ItemId`, `Count`) VALUES (%i, %i, %i, %i);",_game_id,players[y].mysql_id,11,players[y].pent_count);
                MySql::Query(lbuf);
                MySql::Store_Result();
                MySql::Get_Result();
                MySql::Free_Result();
              }

            for (int x=0;x<3;x++)
              if (players[y].health_count[x] > 0)
                {
                  sprintf(lbuf,"INSERT INTO `Itemcount` (`GameId`, `PlayerId`, `ItemId`, `Count`) VALUES (%i, %i, %i, %i);",_game_id,players[y].mysql_id,x+12,players[y].health_count[x]);
                  MySql::Query(lbuf);
                  MySql::Store_Result();
                  MySql::Get_Result();
                  MySql::Free_Result();
                }

            for (int x=0;x<32;x++)
              if (fragstats[y].tkills[x] > 0)
                {
                  sprintf(lbuf,"INSERT INTO `Teamkills` (`GameId`, `PlayerId`, `KilledId`, `Count`) VALUES (%i, %i, %i, %i);",_game_id,players[y].mysql_id,players[x].mysql_id,fragstats[y].tkills[x]);
                  MySql::Query(lbuf);
                  MySql::Store_Result();
                  MySql::Get_Result();
                  MySql::Free_Result();
                }
          }



      // Getting Team

      MySql::Close_Connect();
      // printf("%i %i\n",_team_id_1,_team_id_2);

      /*
      FILE *f;

      f = fopen ("output.xml","w");
      fprintf(f,"<demo>\n");
      for (int i = 0; i<32;i++)
        if (players[i].userid && !players[i].spectator && players[i].name )
          {
            //printf("%i\n",i);
            int event_count = 0;
            fprintf(f,"<player name=\"%s\" team=\"%s\" id=\"%i\">\n",players[i].name,players[i].team,i);
            current = players_events[i].begin();
            while (current != players_events[i].end())
              {
                fprintf(f,"<event id=\"%i\">\n%s</event>\n",event_count++,*current);
                current++;
              }
            fprintf(f,"</player>");
          }


      fprintf(f,"</demo>\n");
      fclose(f);
      */




    }




  }

