/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Package;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Configuration {
    private static final String CONFIGHEADER = "Quake Injector alpha01-130-g592d93d config file";
    public final EnginePath EnginePath = new EnginePath();
    public final EngineExecutable EngineExecutable = new EngineExecutable();
    public final DownloadPath DownloadPath = new DownloadPath();
    public final EngineCommandLine EngineCommandLine = new EngineCommandLine();
    public final RepositoryDatabasePath RepositoryDatabasePath = new RepositoryDatabasePath();
    public final ZipContentsDatabaseUrl ZipContentsDatabaseUrl = new ZipContentsDatabaseUrl();
    public final RogueInstalled RogueInstalled = new RogueInstalled();
    public final HipnoticInstalled HipnoticInstalled = new HipnoticInstalled();
    public final MainWindowPositionX MainWindowPositionX = new MainWindowPositionX();
    public final MainWindowPositionY MainWindowPositionY = new MainWindowPositionY();
    public final MainWindowWidth MainWindowWidth = new MainWindowWidth();
    public final MainWindowHeight MainWindowHeight = new MainWindowHeight();
    public final RepositoryBasePath RepositoryBasePath = new RepositoryBasePath();
    public final Map<String, Value<?>> All = new HashMap();
    private File configFile = new File("config.properties");

    public Configuration() {
        Field[] fields;
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            if (!Value.class.isAssignableFrom(f.getType())) continue;
            try {
                this.All.put(f.getName(), (Value)f.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.init();
    }

    private void set(Configuration c) {
        for (Map.Entry<String, Value<?>> e : c.All.entrySet()) {
            String key = e.getKey();
            Value<?> v = e.getValue();
            if (v.equals(this.getValue(key))) continue;
            this.getValue(key).set(v.get());
        }
    }

    private Value getValue(String key) {
        return this.All.get(key);
    }

    public void init() {
        this.read();
    }

    private void read() {
        System.out.print("Reading configuration...");
        Properties properties = new Properties(this.defaults());
        if (this.configFile.canRead()) {
            try {
                FileInputStream in = new FileInputStream(this.configFile);
                properties.load(in);
                in.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("Can't read config file even though i just checked if i can read it. Using defaults...");
            }
            catch (IOException e) {
                System.out.println("Couldn't read config file. Using defaults...");
            }
        }
        this.set(properties);
        System.out.println("done.");
    }

    public void set(Properties p) {
        for (String key : this.All.keySet()) {
            String s = p.getProperty(key);
            if (s == null) continue;
            Value<?> v = this.All.get(key);
            v.set(v.stringToValue(s));
        }
    }

    public void get(Properties p) {
        for (String key : this.All.keySet()) {
            Value<?> v = this.All.get(key);
            if (v.exists()) {
                System.out.println("Writing " + key + " to " + v.toString() + " from " + v.getClass() + ": " + v);
                p.setProperty(key, v.toString());
                continue;
            }
            if (p.getProperty(key) == null) continue;
            p.remove(key);
        }
    }

    public void write() {
        System.out.print("Writing configuration...");
        try {
            Properties properties = new Properties(this.defaults());
            this.get(properties);
            FileOutputStream out = new FileOutputStream(this.configFile);
            properties.store(out, CONFIGHEADER);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't write config file");
        }
        catch (IOException e) {
            System.out.println("Couldn't write config file.");
        }
        System.out.println("done.");
    }

    private Properties defaults() {
        Properties defaults = new Properties();
        for (String key : this.All.keySet()) {
            Value<?> v = this.All.get(key);
            Object value = v.defaultValue();
            if (value == null) continue;
            defaults.setProperty(v.key(), v.toString());
        }
        return defaults;
    }

    private abstract class IntegerValue
    extends AbstractValue<Integer> {
        protected IntegerValue(String key, Integer defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public Integer stringToValue(String v) {
            if (v == null) {
                return null;
            }
            try {
                return Integer.valueOf(v);
            }
            catch (NumberFormatException e) {
                System.err.println(e);
                e.printStackTrace();
                return null;
            }
        }
    }

    private abstract class BooleanValue
    extends AbstractValue<Boolean> {
        protected BooleanValue(String key, boolean defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public Boolean stringToValue(String v) {
            return Boolean.valueOf(v);
        }
    }

    private abstract class FileValue
    extends AbstractValue<File> {
        protected FileValue(String key, File defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public File stringToValue(String v) {
            return new File(v);
        }
    }

    private abstract class StringValue
    extends AbstractValue<String> {
        protected StringValue(String key, String defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public String stringToValue(String v) {
            return v;
        }

        @Override
        public String toString() {
            return (String)this.get();
        }
    }

    private abstract class AbstractValue<T>
    implements Value<T> {
        private String key;
        private T defaultValue;
        private T value;

        protected AbstractValue(String key, T defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public abstract T stringToValue(String var1);

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public T defaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean existsOrDefault() {
            return this.exists() || this.defaultValue != null;
        }

        @Override
        public T get() {
            if (this.value == null) {
                return this.defaultValue;
            }
            return this.value;
        }

        @Override
        public void set(T v) {
            if (v == null || v.equals(this.defaultValue())) {
                System.out.println(this.getClass() + ": Setting to null or default");
                this.value = null;
                return;
            }
            this.value = v;
        }

        @Override
        public boolean exists() {
            return this.value != null;
        }

        public String toString() {
            return this.existsOrDefault() ? this.get().toString() : null;
        }
    }

    public static interface Value<T> {
        public T get();

        public void set(T var1);

        public String key();

        public T defaultValue();

        public T stringToValue(String var1);

        public boolean exists();

        public boolean existsOrDefault();
    }

    public class RepositoryBasePath
    extends StringValue {
        private static final String onlineRepositoryExtension = ".zip";

        private RepositoryBasePath() {
            super("repositoryBase", "http://www.quaddicted.com/filebase/");
        }

        public String getRepositoryUrl(String mapid) {
            return (String)this.get() + mapid + onlineRepositoryExtension;
        }
    }

    public class MainWindowHeight
    extends IntegerValue {
        private MainWindowHeight() {
            super("mainWindowHeight", null);
        }
    }

    public class MainWindowWidth
    extends IntegerValue {
        private MainWindowWidth() {
            super("mainWindowWidth", null);
        }
    }

    public class MainWindowPositionY
    extends IntegerValue {
        private MainWindowPositionY() {
            super("mainWindowPositionY", null);
        }
    }

    public class MainWindowPositionX
    extends IntegerValue {
        private MainWindowPositionX() {
            super("mainWindowPositionX", null);
        }
    }

    public class HipnoticInstalled
    extends BooleanValue {
        private HipnoticInstalled() {
            super("hipnoticInstalled", false);
        }
    }

    public class RogueInstalled
    extends BooleanValue {
        private RogueInstalled() {
            super("rogueInstalled", false);
        }
    }

    public class ZipContentsDatabaseUrl
    extends StringValue {
        private ZipContentsDatabaseUrl() {
            super("ZipContentsDatabaseUrl", "http://haukerehfeld.de/projects/quakeinjector/temp/zipContents.xml");
        }
    }

    public class RepositoryDatabasePath
    extends StringValue {
        private RepositoryDatabasePath() {
            super("repositoryDatabase", "http://www.quaddicted.com/reviews/quaddicted_database.xml");
        }
    }

    public class EngineCommandLine
    extends StringValue {
        private EngineCommandLine() {
            super("engineCommandline", "");
        }
    }

    public class DownloadPath
    extends FileValue {
        private DownloadPath() {
            super("downloadPath", null);
        }

        @Override
        public File get() {
            File result = (File)super.get();
            if (result == null) {
                System.out.println("downloadpath null, returning default");
                return this.defaultPath();
            }
            return result;
        }

        private File defaultPath() {
            if (Configuration.this.EnginePath.get() == null) {
                return null;
            }
            return new File(Configuration.this.EnginePath.get() + File.separator + "downloads");
        }

        @Override
        public void set(File v) {
            System.out.println("Setting downloadpath: " + v);
            if (v.equals(this.defaultPath()) || v.equals(new File(""))) {
                System.out.println(this.getClass() + " Setting downloadpath to null");
                super.set(null);
                return;
            }
            super.set(v);
        }
    }

    public class EngineExecutable
    extends FileValue {
        private EngineExecutable() {
            super("engineExecutable", new File(""));
        }
    }

    public class EnginePath
    extends FileValue {
        private EnginePath() {
            super("enginePath", null);
        }

        public File getUnzipDir(Package map) {
            String relativedir = map.getRelativeBaseDir();
            String unzipdir = ((File)this.get()).getAbsolutePath();
            if (relativedir != null) {
                unzipdir = unzipdir + File.separator + relativedir;
            }
            return new File(unzipdir);
        }
    }
}

