/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.EngineConfigDialog;
import de.haukerehfeld.quakeinjector.gui.ErrorEvent;
import de.haukerehfeld.quakeinjector.gui.ErrorListener;
import de.haukerehfeld.quakeinjector.gui.JPathPanel;
import de.haukerehfeld.quakeinjector.gui.LookAndFeelDefaults;
import de.haukerehfeld.quakeinjector.gui.OkayCancelApplyPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EngineConfigDialog
extends JDialog {
    private static final String windowTitle = "Engine Configuration";
    private final ChangeListenerList listeners = new ChangeListenerList();
    private final JPathPanel enginePath;
    private final JPathPanel engineExecutable;
    private final JTextField engineCommandline;
    private final JPathPanel downloadPath;
    private final JCheckBox rogue;
    private final JCheckBox hipnotic;

    public EngineConfigDialog(JFrame frame, Configuration.EnginePath enginePathDefault, Configuration.EngineExecutable engineExeDefault, Configuration.DownloadPath downloadPathDefault, Configuration.EngineCommandLine cmdlineDefault, boolean rogueInstalled, boolean hipnoticInstalled) {
        super(frame, windowTitle, true);
        JPanel configPanel = new JPanel();
        configPanel.setBorder(LookAndFeelDefaults.PADDINGBORDER);
        configPanel.setLayout(new GridBagLayout());
        JLabel description = new JLabel("Configure engine specific settings");
        description.setLabelFor(this);
        description.setBorder(LookAndFeelDefaults.DIALOGDESCRIPTIONBORDER);
        configPanel.add((Component)description, new GridBagConstraints());
        final JButton okay = new JButton("Okay");
        JButton cancel = new JButton("Cancel");
        final JButton apply = new JButton("Apply");
        int row = 1;
        Border leftBorder = BorderFactory.createEmptyBorder(0, 0, 0, 7);
        JLabel cmdlineLabel = new JLabel("Quake commandline options");
        cmdlineLabel.setBorder(leftBorder);
        this.engineCommandline = new JTextField((String)cmdlineDefault.get(), 40);
        final int row_ = row++;
        class LabelConstraints
        extends GridBagConstraints {
            final /* synthetic */ EngineConfigDialog this$0;

            LabelConstraints(EngineConfigDialog engineConfigDialog) {
                this.this$0 = engineConfigDialog;
                this.anchor = 21;
                this.fill = 0;
                this.gridx = 0;
                this.gridwidth = 1;
                this.gridheight = 1;
                this.weightx = 0.0;
                this.weighty = 0.0;
            }
        }
        configPanel.add((Component)cmdlineLabel, new LabelConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_;
            }
        });
        class InputConstraints
        extends GridBagConstraints {
            final /* synthetic */ EngineConfigDialog this$0;

            InputConstraints(EngineConfigDialog engineConfigDialog) {
                this.this$0 = engineConfigDialog;
                this.anchor = 22;
                this.fill = 2;
                this.gridx = 1;
                this.gridwidth = 2;
                this.gridheight = 1;
                this.weightx = 1.0;
                this.weighty = 0.0;
            }
        }
        configPanel.add((Component)this.engineCommandline, new InputConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_;
            }
        });
        JLabel enginePathLabel = new JLabel("Quake Directory");
        enginePathLabel.setBorder(leftBorder);
        this.enginePath = new JPathPanel(new JPathPanel.WritableDirectoryVerifier(), (File)enginePathDefault.get(), 1);
        row_ = row++;
        configPanel.add((Component)enginePathLabel, new LabelConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_;
            }
        });
        configPanel.add((Component)this.enginePath, new InputConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_;
            }
        });
        JLabel engineExeLabel = new JLabel("Quake Executable");
        engineExeLabel.setBorder(leftBorder);
        this.engineExecutable = new JPathPanel(new JPathPanel.Verifier(){

            @Override
            public boolean verify(File exe) {
                return exe.exists() && !exe.isDirectory() && exe.canRead() && exe.canExecute();
            }

            @Override
            public String errorMessage(File f) {
                if (!f.exists()) {
                    return "Doesn't exist!";
                }
                if (f.isDirectory()) {
                    return "Must be an executable file!";
                }
                if (!f.canExecute()) {
                    return "Cannot be executed!";
                }
                return null;
            }
        }, (File)engineExeDefault.get(), (File)enginePathDefault.get(), 0);
        row_ = row++;
        configPanel.add((Component)engineExeLabel, new LabelConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_;
            }
        });
        configPanel.add((Component)this.engineExecutable, new InputConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_;
            }
        });
        this.enginePath.verify();
        this.engineExecutable.verify();
        JLabel downloadLabel = new JLabel("Download Directory");
        downloadLabel.setBorder(leftBorder);
        this.downloadPath = new JPathPanel(new JPathPanel.WritableDirectoryVerifier(), downloadPathDefault.get(), 1);
        this.downloadPath.verify();
        final int row_2 = row++;
        configPanel.add((Component)downloadLabel, new LabelConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_2;
            }
        });
        configPanel.add((Component)this.downloadPath, new InputConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_2;
            }
        });
        JLabel expansionsInstalled = new JLabel("Expansion packs installed");
        expansionsInstalled.setBorder(leftBorder);
        this.rogue = new JCheckBox("rogue");
        this.rogue.setMnemonic(82);
        this.rogue.setSelected(rogueInstalled);
        this.hipnotic = new JCheckBox("hipnotic");
        this.hipnotic.setMnemonic(72);
        this.hipnotic.setSelected(hipnoticInstalled);
        row_2 = row;
        configPanel.add((Component)expansionsInstalled, new LabelConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_2;
            }
        });
        configPanel.add((Component)this.rogue, new InputConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_2;
                this.gridwidth = 1;
            }
        });
        configPanel.add((Component)this.hipnotic, new InputConstraints(){
            {
                super(EngineConfigDialog.this);
                this.gridy = row_2;
                this.gridx = 2;
                this.gridwidth = 1;
            }
        });
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(LookAndFeelDefaults.PADDINGBORDER);
        tabbedPane.addTab("Engine Specifics", null, configPanel, "Configure Engine Specifics");
        tabbedPane.setMnemonicAt(0, 49);
        this.add((Component)tabbedPane, "Center");
        class EnableOkay
        implements ChangeListener,
        DocumentListener {
            EnableOkay() {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.check();
            }

            private void check() {
                if (EngineConfigDialog.this.enginePath.verifies() && EngineConfigDialog.this.engineExecutable.verifies()) {
                    okay.setEnabled(true);
                    apply.setEnabled(true);
                }
            }
        }
        EnableOkay enableOkay = new EnableOkay();
        this.engineCommandline.getDocument().addDocumentListener(enableOkay);
        this.enginePath.addErrorListener(new ErrorListener(){

            @Override
            public void errorOccured(ErrorEvent e) {
                okay.setEnabled(false);
                apply.setEnabled(false);
            }
        });
        this.enginePath.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EngineConfigDialog.this.engineExecutable.setBasePath(EngineConfigDialog.this.enginePath.getPath());
            }
        });
        this.enginePath.addChangeListener(enableOkay);
        this.engineExecutable.addErrorListener(new ErrorListener(){

            @Override
            public void errorOccured(ErrorEvent e) {
                okay.setEnabled(false);
                apply.setEnabled(false);
            }
        });
        this.engineExecutable.addChangeListener(enableOkay);
        this.downloadPath.addChangeListener(enableOkay);
        this.rogue.addChangeListener(enableOkay);
        this.hipnotic.addChangeListener(enableOkay);
        ActionListener save = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineConfigDialog.this.listeners.notifyChangeListeners(this);
                apply.setEnabled(false);
            }
        };
        okay.addActionListener(save);
        apply.addActionListener(save);
        ActionListener close = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineConfigDialog.this.setVisible(false);
                EngineConfigDialog.this.dispose();
            }
        };
        okay.addActionListener(close);
        cancel.addActionListener(close);
        OkayCancelApplyPanel okayCancelPanel = new OkayCancelApplyPanel(okay, cancel, apply, true);
        this.add((Component)okayCancelPanel, "Last");
    }

    public File getEnginePath() {
        return this.enginePath.getPath();
    }

    public File getEngineExecutable() {
        return this.engineExecutable.getPath();
    }

    public String getCommandline() {
        return this.engineCommandline.getText();
    }

    public boolean getHipnoticInstalled() {
        return this.hipnotic.isSelected();
    }

    public boolean getRogueInstalled() {
        return this.rogue.isSelected();
    }

    public File getDownloadPath() {
        return this.downloadPath.getPath();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }
}

