/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.gui.OkayCancelApplyPanel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;

public class EngineOutputDialog
extends JDialog {
    private static final String windowTitle = "Engine Output";
    private final InputStream engineOut;
    private final JTextArea output;

    public EngineOutputDialog(JFrame parent, final InputStream engineOut) {
        super(parent, windowTitle, true);
        this.engineOut = engineOut;
        this.output = new JTextArea(30, 80);
        this.output.setLineWrap(true);
        JScrollPane panelScroll = new JScrollPane(this.output);
        panelScroll.setVerticalScrollBarPolicy(22);
        panelScroll.getViewport().setBackground(UIManager.getColor("TextPane.background"));
        this.add((Component)panelScroll, "Center");
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineOutputDialog.this.setVisible(false);
                EngineOutputDialog.this.dispose();
            }
        });
        this.add((Component)new OkayCancelApplyPanel(close, null, null, false), "Last");
        new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    String line;
                    InputStreamReader in = new InputStreamReader(engineOut);
                    BufferedReader b = new BufferedReader(in);
                    EngineOutputDialog.this.output.append("Starting engine...\n");
                    int lineCount = 0;
                    while ((line = b.readLine()) != null) {
                        EngineOutputDialog.this.output.append(line.trim() + "\n");
                        ++lineCount;
                        SwingUtilities.invokeLater(new SwingWorker<Void, Void>(){

                            @Override
                            public Void doInBackground() {
                                EngineOutputDialog.this.output.scrollRectToVisible(new Rectangle(0, EngineOutputDialog.this.output.getHeight(), 0, 10));
                                return null;
                            }
                        });
                    }
                    if (lineCount == 0) {
                        EngineOutputDialog.this.output.append("Done with no output.\n");
                    } else {
                        EngineOutputDialog.this.output.append("Done.\n");
                    }
                }
                catch (IOException e) {
                    EngineOutputDialog.this.output.append("Error: Couldn't read engine output from stream");
                }
                return null;
            }

            @Override
            public void done() {
            }
        }.execute();
    }
}

