/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class EngineStarter {
    private File quakeDir;
    private File quakeExe;
    private String quakeCmdline;

    public EngineStarter(File quakeDir, File quakeExe, Configuration.EngineCommandLine quakeCmdline) {
        this.quakeDir = quakeDir;
        this.quakeExe = quakeExe;
        this.quakeCmdline = (String)quakeCmdline.get();
    }

    public Process start(String mapCmdline, String startmap) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>(5);
        cmd.add(this.quakeExe.getAbsolutePath());
        if (this.quakeCmdline != null) {
            for (String s : this.quakeCmdline.split(" ")) {
                cmd.add(s);
            }
        }
        if (mapCmdline != null) {
            for (String s : mapCmdline.split(" ")) {
                cmd.add(s);
            }
        }
        cmd.add("+map");
        cmd.add(startmap);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(this.quakeDir);
        pb.redirectErrorStream(true);
        System.out.println(cmd);
        Process p = pb.start();
        return p;
    }

    public void setQuakeDirectory(File dir) {
        this.quakeDir = dir;
    }

    public void setQuakeExecutable(File exe) {
        this.quakeExe = exe;
    }

    public void setQuakeCommandline(Configuration.EngineCommandLine cmdline) {
        this.quakeCmdline = (String)cmdline.get();
    }

    public boolean checkPaths() {
        return this.quakeExe.exists() && !this.quakeExe.isDirectory() && this.quakeExe.canRead() && this.quakeExe.canExecute();
    }
}

