/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.gui.ProgressPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Scrollable;

public class InstallQueuePanel
extends JPanel
implements Scrollable {
    private static final int size = 5;
    private static final int rowHeight = 20;
    private static final int MARGIN = 3;
    private GridBagLayout layout = new GridBagLayout();
    private Queue<Job> jobs = new ArrayDeque<Job>();

    public InstallQueuePanel() {
        this.setLayout(this.layout);
    }

    public Job addJob(String description, ActionListener cancelAction) {
        Job progressListener = new Job(cancelAction, description);
        this.jobs.offer(progressListener);
        this.layoutComponents();
        this.scrollRectToVisible(new Rectangle(0, this.getHeight(), 0, 100));
        return progressListener;
    }

    private void layoutComponents() {
        int row = 0;
        for (Job j : this.jobs) {
            this.remove(j.progressBar);
            this.remove(j.cancelButton);
            this.remove(j.finishedLabel);
            final int row_ = row;
            if (!j.finished) {
                this.add((Component)j.progressBar, new ProgressBarConstraints(){
                    {
                        this.gridy = row_;
                    }
                });
                this.add((Component)j.cancelButton, new CancelButtonConstraints(){
                    {
                        this.gridy = row_;
                    }
                });
            } else {
                this.add((Component)j.finishedLabel, new FinishedLabelConstraints(){
                    {
                        this.gridy = row_;
                    }
                });
            }
            ++row;
        }
        this.revalidate();
        this.repaint();
    }

    public void finished(Job j, String message) {
        j.finish(message);
        this.layoutComponents();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public static class Job
    implements PropertyChangeListener {
        private JProgressBar progressBar;
        private JButton cancelButton;
        private JLabel finishedLabel;
        private String description;
        private boolean finished = false;

        public Job(ActionListener cancelAction, String description) {
            this.description = description;
            this.progressBar = new JProgressBar();
            this.progressBar.setString(ProgressPopup.progressString(description, 0));
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(cancelAction);
            this.finishedLabel = new JLabel(description);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress" == evt.getPropertyName()) {
                int p = (Integer)evt.getNewValue();
                this.setProgress(p);
            }
        }

        public void setProgress(int progress) {
            this.progressBar.setString(ProgressPopup.progressString(this.description, progress));
            this.progressBar.setValue(progress);
        }

        private void finish(String message) {
            this.finished = true;
            this.progressBar.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.finishedLabel.setText(ProgressPopup.progressString(this.description, message));
            this.finishedLabel.setPreferredSize(new Dimension((int)this.finishedLabel.getPreferredSize().getWidth(), (int)this.cancelButton.getSize().getHeight()));
        }
    }

    private class FinishedLabelConstraints
    extends RowConstraints {
        private FinishedLabelConstraints() {
            this.weightx = 1.0;
            this.gridwidth = 2;
        }
    }

    private class CancelButtonConstraints
    extends RowConstraints {
        private CancelButtonConstraints() {
            this.gridx = 1;
        }
    }

    private class ProgressBarConstraints
    extends RowConstraints {
        private ProgressBarConstraints() {
            this.weightx = 1.0;
            this.weighty = 1.0;
        }
    }

    private class RowConstraints
    extends GridBagConstraints {
        private RowConstraints() {
            this.anchor = 10;
            this.fill = 2;
            this.insets = new Insets(3, 3, 3, 3);
        }
    }
}

