/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Cancelable;
import de.haukerehfeld.quakeinjector.CheckCanceledProgressListener;
import de.haukerehfeld.quakeinjector.CompressedProgressListener;
import de.haukerehfeld.quakeinjector.FileInfo;
import de.haukerehfeld.quakeinjector.FileNotWritableException;
import de.haukerehfeld.quakeinjector.Installer;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.PercentageProgressListener;
import de.haukerehfeld.quakeinjector.ProgressListener;
import de.haukerehfeld.quakeinjector.RelativePath;
import de.haukerehfeld.quakeinjector.SumProgressListener;
import de.haukerehfeld.quakeinjector.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.SwingWorker;

public class InstallWorker
extends SwingWorker<PackageFileList, Void>
implements ProgressListener,
Cancelable {
    private static final int BUFFERSIZE = 1024;
    private File baseDirectory;
    private String unzipDirectory;
    private Package map;
    private InputStream input;
    private List<File> overwrites;
    private long downloadSize = 0L;
    private PackageFileList files;

    public InstallWorker(InputStream input, long inputSize, Package map, File baseDirectory, String unzipDirectory, List<File> overwrites) {
        this.map = map;
        this.input = input;
        this.downloadSize = inputSize;
        this.baseDirectory = baseDirectory;
        this.unzipDirectory = unzipDirectory;
        this.files = new PackageFileList(map.getId());
        this.overwrites = overwrites;
    }

    @Override
    public PackageFileList doInBackground() throws IOException, FileNotFoundException, Installer.CancelledException {
        System.out.println("Installing " + this.map.getId());
        this.unzip(this.input, this.baseDirectory, this.unzipDirectory, this.map.getId(), this.overwrites);
        this.map.setInstalled(true);
        return this.files;
    }

    public void unzip(InputStream in, File basedir, String unzipdir, String mapid, List<File> overwrites) throws IOException, FileNotFoundException, Installer.CancelledException {
        ZipEntry entry;
        SumProgressListener progress = new SumProgressListener(new PercentageProgressListener(this.downloadSize, new CheckCanceledProgressListener(this, this)));
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(in));
        boolean extracted = false;
        while ((entry = zis.getNextEntry()) != null) {
            long crc;
            File f = new File(unzipdir + File.separator + entry.getName());
            String filename = RelativePath.getRelativePath(basedir, f).toString();
            if (overwrites != null && overwrites.indexOf(f) < 0) {
                System.out.println("Skipping " + filename + ", because it isn't supposed to be overwritten.");
                continue;
            }
            List<File> createdDirs = Utils.mkdirs(f);
            if (entry.isDirectory()) continue;
            File original = f;
            if (f.exists()) {
                f = File.createTempFile("quakeinjector", ".tmp", f.getParentFile());
                System.out.println("create Temp file " + f);
            }
            System.out.println("Writing " + filename + " (" + entry.getCompressedSize() + "b)");
            try {
                crc = Utils.writeFile(zis, f, new CompressedProgressListener((double)entry.getCompressedSize() / (double)entry.getSize(), progress));
            }
            catch (FileNotFoundException e) {
                throw new FileNotWritableException(e.getMessage());
            }
            if (crc != entry.getCrc()) {
                System.err.println("Crc32 didn't match on extraction of " + original + ", removing...");
                f.delete();
                continue;
            }
            FileInfo info = new FileInfo(filename, crc);
            this.files.add(info);
            for (File dirname : createdDirs) {
                this.files.add(new FileInfo(RelativePath.getRelativePath(basedir, dirname).toString(), 0L));
            }
            if (!f.equals(original)) {
                original.delete();
                System.out.println("moving Temp file to " + original);
                f.renameTo(original);
            }
            extracted = true;
        }
        if (!extracted) {
            throw new ZipException("No files extracted from zip, is it an empty file?");
        }
        zis.close();
    }

    @Override
    public void publish(long progress) {
        if (progress <= 100L) {
            this.setProgress((int)progress);
        }
    }

    @Override
    public void checkCancelled() throws Installer.CancelledException {
        if (this.isCancelled()) {
            System.out.println("canceling...");
            throw new Installer.CancelledException();
        }
    }

    public PackageFileList getInstalledFiles() {
        return this.files;
    }
}

