/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.FileInfo;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Requirement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InstalledPackageList {
    private static final String ROOTNODE = "maps";

    public void write(OutputStream out, Iterable<? extends Requirement> list) throws IOException {
        HashMap<String, Iterable<FileInfo>> files = new HashMap<String, Iterable<FileInfo>>();
        for (Requirement requirement : list) {
            if (!requirement.isInstalled()) continue;
            Iterable<FileInfo> l = requirement.getFileList();
            if (l == null) {
                l = Collections.emptyList();
            }
            files.put(requirement.getId(), l);
        }
        if (files.isEmpty()) {
            System.out.println("WARNING: writing empty maplist");
        }
        this.write(out, files);
    }

    public void write(OutputStream out, Map<String, Iterable<FileInfo>> files) throws IOException {
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Couldn't instantiate Document Builder: " + e);
            e.printStackTrace();
        }
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement(ROOTNODE);
        doc.appendChild(root);
        for (Map.Entry<String, Iterable<FileInfo>> e : files.entrySet()) {
            String id = e.getKey();
            Iterable<FileInfo> fileIterable = e.getValue();
            Element mapNode = doc.createElement("map");
            mapNode.setAttribute("id", id);
            root.appendChild(mapNode);
            for (FileInfo file : fileIterable) {
                Element fileNode = doc.createElement("file");
                fileNode.setAttribute("name", file.getName());
                long crc = file.getChecksum();
                if (crc != 0L) {
                    fileNode.setAttribute("crc", Long.toString(crc));
                }
                if (!file.getEssential()) {
                    fileNode.setAttribute("essential", Boolean.toString(false));
                }
                mapNode.appendChild(fileNode);
            }
        }
        Transformer trans = null;
        try {
            trans = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(doc);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            // empty catch block
        }
    }

    public List<PackageFileList> read(InputStream in) throws IOException {
        Document document;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Couldn't parse installed package list: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("Couldn't parse Installed Package List: " + e.getMessage());
        }
        Element root = document.getDocumentElement();
        NodeList installedMaps = root.getChildNodes();
        ArrayList<PackageFileList> files = new ArrayList<PackageFileList>(installedMaps.getLength());
        for (int i = 0; i < installedMaps.getLength(); ++i) {
            Node map = installedMaps.item(i);
            if (map.getNodeType() != 1) continue;
            PackageFileList l = this.parseMapFileList((Element)map);
            files.add(l);
        }
        return files;
    }

    private PackageFileList parseMapFileList(Element map) {
        String id = map.getAttribute("id");
        PackageFileList fileList = new PackageFileList(id);
        NodeList files = map.getChildNodes();
        for (int i = 0; i < files.getLength(); ++i) {
            Node file = files.item(i);
            if (file.getNodeType() != 1) continue;
            Element e = (Element)file;
            String name = e.getAttribute("name");
            long crc = 0L;
            if (e.hasAttribute("crc")) {
                crc = Long.parseLong(e.getAttribute("crc"));
            }
            boolean essential = true;
            if (e.hasAttribute("essential") && e.getAttribute("essential").equals(Boolean.toString(false))) {
                essential = false;
            }
            fileList.add(new FileInfo(name, crc, essential));
        }
        return fileList;
    }
}

