/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.InstalledPackageList;
import de.haukerehfeld.quakeinjector.PackageFileList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingWorker;

public class InstalledPackages {
    private Future<List<PackageFileList>> installedPackages;

    public void parse(File installedPackagesXml) {
        ParseInstalledPackagesWorker parseInstalled = new ParseInstalledPackagesWorker(installedPackagesXml);
        parseInstalled.execute();
        this.installedPackages = parseInstalled;
    }

    public List<PackageFileList> get() throws InterruptedException, ExecutionException {
        try {
            return this.installedPackages.get();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PackageFileList> getDefaultErrorHandling() {
        try {
            List<PackageFileList> list = this.get();
            return list;
        }
        catch (InterruptedException e) {
            System.err.println("Error: couldn't set installedPackages, interrupted!" + e);
            e.printStackTrace();
        }
        catch (ExecutionException err) {
            try {
                throw err.getCause();
            }
            catch (FileNotFoundException e) {
                System.out.println("Notice: installed packages file doesn't exist yet, no packages installed? " + e);
            }
            catch (IOException e) {
                System.err.println("Error: installed packages file couldn't be loaded: " + e);
                e.printStackTrace();
            }
        }
        finally {
            return Collections.emptyList();
        }
    }

    private List<PackageFileList> parseInstalledPackagesFile(File installedPackagesFile) throws NoInstalledPackagesFileException, FileNotFoundException, IOException {
        if (!installedPackagesFile.exists()) {
            throw new NoInstalledPackagesFileException("No Installed packages file (" + installedPackagesFile + ")" + ", no packages installed?");
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(installedPackagesFile));
        List<PackageFileList> result = new InstalledPackageList().read(in);
        IOException error = null;
        try {
            ((InputStream)in).close();
        }
        catch (FileNotFoundException e) {
            error = e;
        }
        catch (IOException e) {
            error = e;
        }
        if (error != null) {
            System.err.println("Error: couldn't close filestream " + installedPackagesFile + ": " + error);
        }
        return result;
    }

    public static class NoInstalledPackagesFileException
    extends FileNotFoundException {
        public NoInstalledPackagesFileException(String msg) {
            super(msg);
        }

        public NoInstalledPackagesFileException() {
        }
    }

    class ParseInstalledPackagesWorker
    extends SwingWorker<List<PackageFileList>, Void> {
        public final File xml;

        public ParseInstalledPackagesWorker(File xml) {
            this.xml = xml;
        }

        @Override
        public List<PackageFileList> doInBackground() throws FileNotFoundException, IOException {
            return InstalledPackages.this.parseInstalledPackagesFile(this.xml);
        }
    }
}

