/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.SortableRequirement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeListener;

public class Package
extends SortableRequirement
implements Requirement {
    private ChangeListenerList listeners = new ChangeListenerList();
    private String author;
    private String title;
    private Rating rating;
    private String description;
    private int size;
    private Date date;
    private String relativeBaseDir;
    private String commandline;
    private List<String> startmaps;
    private List<Requirement> requirements;
    private PackageFileList fileList;
    private PackageFileList supposedFileList;

    public Package(String id, String author, String title, int size, Date date, boolean isInstalled, Rating rating, String description) {
        this(id, author, title, size, date, isInstalled, rating, description, null, null, null, null);
    }

    public Package(String id, String author, String title, int size, Date date, boolean isInstalled, Rating rating, String description, String relativeBaseDir, String commandline, List<String> startmaps, List<Requirement> requirements) {
        super(id);
        this.author = author;
        this.title = title;
        this.size = size;
        this.date = date;
        super.setInstalled(isInstalled);
        this.rating = rating;
        this.description = description;
        this.relativeBaseDir = relativeBaseDir;
        this.commandline = commandline;
        this.startmaps = startmaps;
        this.requirements = requirements;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public Date getDate() {
        return this.date;
    }

    public Rating getRating() {
        return this.rating;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRelativeBaseDir() {
        return this.relativeBaseDir;
    }

    public String getCommandline() {
        return this.commandline;
    }

    public List<String> getStartmaps() {
        return this.startmaps;
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public List<Package> getAvailableRequirements() {
        ArrayList<Package> avails = new ArrayList<Package>();
        for (Requirement r : this.requirements) {
            if (!(r instanceof Package)) continue;
            avails.add((Package)r);
        }
        return avails;
    }

    public List<Requirement> getUnavailableRequirements() {
        ArrayList<Requirement> unavails = new ArrayList<Requirement>();
        for (Requirement r : this.requirements) {
            if (r.isInstalled() || r instanceof Package) continue;
            unavails.add(r);
        }
        return unavails;
    }

    public List<Requirement> getUnmetRequirements() {
        ArrayList<Requirement> unmet = new ArrayList<Requirement>();
        for (Requirement requirement : this.requirements) {
            if (requirement.isInstalled()) continue;
            unmet.add(requirement);
        }
        return unmet;
    }

    @Override
    protected void notifyChangeListeners() {
        this.listeners.notifyChangeListeners(this);
    }

    @Override
    public String toString() {
        return this.getId() + " (" + this.isInstalled() + ")";
    }

    @Override
    public PackageFileList getFileList() {
        return this.fileList;
    }

    public void setFileList(PackageFileList fileList) {
        this.fileList = fileList;
    }

    public PackageFileList getSupposedFileList() {
        return this.supposedFileList;
    }

    public void setSupposedFileList(PackageFileList supposedFileList) {
        this.supposedFileList = supposedFileList;
    }

    public static enum Rating {
        Unrated(0),
        Crap(1),
        Poor(2),
        Average(3),
        Nice(4),
        Excellent(5);

        private int rating;

        private Rating(int rating) {
            this.rating = rating;
        }

        public int getRating() {
            return this.rating;
        }
    }
}

