/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.UnavailableRequirement;
import de.haukerehfeld.quakeinjector.XmlUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PackageDatabaseParser
implements Serializable {
    private static final Package.Rating[] ratingTable = new Package.Rating[]{Package.Rating.Unrated, Package.Rating.Crap, Package.Rating.Poor, Package.Rating.Average, Package.Rating.Nice, Package.Rating.Excellent};

    public List<Requirement> parse(Document document) throws IOException, SAXException {
        HashMap<String, Requirement> packages = new HashMap<String, Requirement>();
        HashMap<Package, List<String>> unresolvedRequirements = new HashMap<Package, List<String>>();
        Element files = document.getDocumentElement();
        for (Node file : XmlUtils.iterate(files.getChildNodes())) {
            if (!XmlUtils.isElement(file)) continue;
            Package currentPackage = this.parsePackage((Element)file, unresolvedRequirements);
            packages.put(currentPackage.getId(), currentPackage);
        }
        this.resolveRequirements(unresolvedRequirements, packages);
        ArrayList<Requirement> packageList = new ArrayList<Requirement>(packages.values());
        return packageList;
    }

    private void resolveRequirements(Map<Package, List<String>> unresolvedRequirements, Map<String, Requirement> packages) {
        for (Map.Entry<Package, List<String>> entry : unresolvedRequirements.entrySet()) {
            Package current = entry.getKey();
            List<String> reqs = entry.getValue();
            ArrayList<Requirement> resolvedRequirements = new ArrayList<Requirement>(reqs.size());
            for (String id : reqs) {
                Requirement resolved = packages.get(id);
                if (resolved == null) {
                    resolved = new UnavailableRequirement(id);
                    packages.put(id, resolved);
                }
                resolvedRequirements.add(resolved);
            }
            current.setRequirements(resolvedRequirements);
        }
    }

    private Package parsePackage(Element file, Map<Package, List<String>> reqResolve) {
        int size;
        String id = file.getAttribute("id");
        String ratingString = file.getAttribute("rating");
        int ratingNumber = 0;
        if (!ratingString.equals("")) {
            try {
                ratingNumber = Integer.parseInt(ratingString);
                if (ratingNumber < 0 || ratingNumber > 5) {
                    System.out.println("Rating of " + id + " is broken");
                    ratingNumber = 0;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Rating of " + id + " is broken");
            }
        }
        Package.Rating rating = ratingTable[ratingNumber];
        String title = XmlUtils.getFirstElement(file, "title").getTextContent().trim();
        String author = XmlUtils.getFirstElement(file, "author").getTextContent().trim();
        try {
            size = Integer.parseInt(XmlUtils.getFirstElement(file, "size").getTextContent().trim());
        }
        catch (NumberFormatException e) {
            System.out.println("XML Parsing Error: malformed <size> tag on record \"" + id + "\"");
            size = 0;
        }
        String date = XmlUtils.getFirstElement(file, "date").getTextContent().trim();
        String description = XmlUtils.getTextForNode(XmlUtils.getFirstElement(file, "description")).trim();
        String relativeBaseDir = null;
        String cmdline = null;
        ArrayList<String> startmaps = new ArrayList<String>();
        ArrayList<String> requirements = new ArrayList<String>();
        Element techinfo = XmlUtils.getFirstElement(file, "techinfo");
        if (techinfo != null) {
            for (Node node : XmlUtils.iterate(techinfo.getChildNodes())) {
                if (!XmlUtils.isElement(node)) continue;
                Element info = (Element)node;
                if (info.getTagName().equals("zipbasedir")) {
                    relativeBaseDir = info.getTextContent();
                    continue;
                }
                if (info.getTagName().equals("commandline")) {
                    cmdline = info.getTextContent();
                    continue;
                }
                if (info.getTagName().equals("startmap")) {
                    startmaps.add(info.getTextContent());
                    continue;
                }
                if (!info.getTagName().equals("requirements")) continue;
                for (Node reqFile : XmlUtils.iterate(info.getChildNodes())) {
                    if (!XmlUtils.isElement(reqFile)) continue;
                    String r = ((Element)reqFile).getAttribute("id");
                    requirements.add(r);
                }
            }
        }
        if (startmaps.isEmpty()) {
            startmaps.add(id);
        }
        Package result = new Package(id, author, title, size, PackageDatabaseParser.parseDate(date), false, rating, description, relativeBaseDir, cmdline, startmaps, null);
        reqResolve.put(result, requirements);
        return result;
    }

    public static Date parseDate(String date) {
        String[] components = date.split("\\.");
        if (components.length < 3) {
            throw new RuntimeException("Xml Parsing error: date malformed");
        }
        int day = Integer.parseInt(components[0]);
        int month = Integer.parseInt(components[1]) - 1;
        int year = Integer.parseInt(components[2]);
        year = year < 60 ? (year += 2000) : (year += 1900);
        return new GregorianCalendar(year, month, day).getTime();
    }
}

