/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Download;
import de.haukerehfeld.quakeinjector.PackageDatabaseParser;
import de.haukerehfeld.quakeinjector.PercentageProgressListener;
import de.haukerehfeld.quakeinjector.ProgressListener;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.SumProgressListener;
import de.haukerehfeld.quakeinjector.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.SwingWorker;
import org.xml.sax.SAXException;

public class PackageDatabaseParserWorker
extends SwingWorker<List<Requirement>, Void>
implements ProgressListener {
    private final String databaseUrl;

    public PackageDatabaseParserWorker(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    @Override
    public List<Requirement> doInBackground() throws IOException, SAXException {
        InputStream dl = this.getDownloadStream(this.databaseUrl);
        PackageDatabaseParser parser = new PackageDatabaseParser();
        List<Requirement> all = parser.parse(XmlUtils.getDocument(dl));
        return all;
    }

    @Override
    public void done() {
    }

    private InputStream getDownloadStream(String databaseUrl) throws IOException {
        InputStream dl;
        Download d = Download.create(databaseUrl);
        d.connect();
        int size = d.getSize();
        if (size > 0) {
            SumProgressListener progress = new SumProgressListener(new PercentageProgressListener(size, this));
            dl = d.getStream(progress);
        } else {
            dl = d.getStream(null);
        }
        return dl;
    }

    @Override
    public void publish(long progress) {
        if (progress <= 100L) {
            this.setProgress((int)progress);
        }
    }
}

