/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageListSelectionHandler;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.Utils;
import de.haukerehfeld.quakeinjector.gui.ScrollablePanel;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Style;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class PackageDetailPanel
extends JPanel
implements ChangeListener,
PackageListSelectionHandler.SelectionListener {
    private static final Dimension DEFAULTIMAGESIZE = new Dimension(200, 150);
    private static final Dimension NOIMAGESIZE = new Dimension(100, 500);
    private Package current = null;
    private JLabel title;
    private JLabel size;
    private JLabel date;
    private ScrollablePanel content;
    private JLabel image;
    private boolean imageDisplayed = false;
    private JPanel imagePanel;
    private JEditorPane description;
    private BrowserLauncher launcher = null;
    private String supposedImageUrl = null;

    private ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public PackageDetailPanel() {
        super(new GridBagLayout());
        try {
            this.launcher = new BrowserLauncher();
        }
        catch (Exception e) {
            System.err.println("Couldn't init browserlauncher: " + e.getMessage());
            e.printStackTrace();
        }
        this.content = new ScrollablePanel(50, 50){
            {
                this.setLayout(new GridBagLayout());
            }
        };
        this.content.setOpaque(false);
        this.title = new JLabel();
        this.title.setHorizontalAlignment(0);
        this.title.setOpaque(true);
        this.content.add((Component)this.title, new GridBagConstraints(){
            {
                this.weightx = 1.0;
                this.weighty = 0.0;
                this.fill = 1;
                this.anchor = 19;
                this.ipadx = 5;
                this.ipady = 20;
            }
        });
        this.imagePanel = new JPanel();
        this.imagePanel.setLayout(new FlowLayout(1, 0, 0));
        this.imagePanel.setOpaque(true);
        this.imagePanel.setBackground(Color.DARK_GRAY);
        this.imagePanel.setPreferredSize(DEFAULTIMAGESIZE);
        this.imagePanel.setMinimumSize(DEFAULTIMAGESIZE);
        this.image = new JLabel();
        EmptyBorder border = new EmptyBorder(0, 0, 0, 0);
        this.image.setBorder(border);
        this.image.setHorizontalAlignment(0);
        this.imagePanel.add(this.image);
        this.description = new JEditorPane("text/html", "");
        this.description.setEditable(false);
        this.description.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (PackageDetailPanel.this.launcher != null && e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    URL url = e.getURL();
                    if (url != null) {
                        PackageDetailPanel.this.launcher.openURLinBrowser(url.toString());
                    } else {
                        System.err.println("Weird hyperlink with null URL: " + e.getDescription());
                        String link = "http://www.quaddicted.com/reviews/" + e.getDescription();
                        PackageDetailPanel.this.launcher.openURLinBrowser(link);
                    }
                }
            }
        });
        this.content.add((Component)this.description, new GridBagConstraints(){
            {
                this.gridy = 2;
                this.weightx = 1.0;
                this.weighty = 0.0;
                this.fill = 1;
                this.anchor = 19;
            }
        });
        HTMLEditorKit doc = (HTMLEditorKit)this.description.getEditorKit();
        StyleSheet styles = doc.getStyleSheet();
        Enumeration<?> rules = styles.getStyleNames();
        while (rules.hasMoreElements()) {
            String name = (String)rules.nextElement();
            Style rule = styles.getStyle(name);
        }
        JScrollPane descriptionScroll = new JScrollPane(this.content);
        descriptionScroll.getViewport().setBackground(UIManager.getColor("TextPane.background"));
        descriptionScroll.setVerticalScrollBarPolicy(22);
        this.add((Component)descriptionScroll, new GridBagConstraints(){
            {
                this.gridy = 0;
                this.gridwidth = 2;
                this.weightx = 1.0;
                this.weighty = 1.0;
                this.fill = 1;
                this.anchor = 19;
            }
        });
        int detailHeight = 20;
        this.date = new JLabel();
        this.date.setHorizontalAlignment(0);
        this.add((Component)this.date, new GridBagConstraints(){
            {
                this.gridy = 1;
                this.gridx = 0;
                this.weightx = 1.0;
                this.weighty = 0.0;
                this.fill = 0;
                this.anchor = 10;
                this.ipadx = 5;
                this.ipady = 3;
            }
        });
        this.size = new JLabel();
        this.size.setHorizontalAlignment(0);
        this.add((Component)this.size, new GridBagConstraints(){
            {
                this.gridy = 1;
                this.gridx = 1;
                this.weightx = 1.0;
                this.weighty = 0.0;
                this.fill = 0;
                this.anchor = 10;
                this.ipadx = 5;
                this.ipady = 3;
            }
        });
    }

    private void addImage() {
        this.content.add((Component)this.imagePanel, new GridBagConstraints(){
            {
                this.gridy = 1;
                this.weightx = 1.0;
                this.weighty = 1.0;
                this.fill = 0;
                this.anchor = 10;
            }
        });
        this.imageDisplayed = true;
    }

    private void removeImage() {
        this.content.remove(this.imagePanel);
        this.imageDisplayed = false;
    }

    private void refreshUi() {
        this.title.setText(this.current.getTitle());
        this.date.setText(this.toString(this.current.getDate()));
        this.size.setText((float)this.current.getSize() / 1000.0f + "mb");
        if (!this.imageDisplayed) {
            this.addImage();
        }
        this.image.setIcon(null);
        this.supposedImageUrl = "http://www.quaddicted.com/reviews/screenshots/" + this.current.getId() + "_injector.jpg";
        new SwingWorker<ImageIcon, Void>(){
            private final String url;
            {
                this.url = PackageDetailPanel.this.supposedImageUrl;
            }

            @Override
            public ImageIcon doInBackground() {
                try {
                    return new ImageIcon(new URL(this.url), PackageDetailPanel.this.current.getId());
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }

            @Override
            public void done() {
                ImageIcon icon;
                if (this.isCancelled() || !PackageDetailPanel.this.supposedImageUrl.equals(this.url)) {
                    return;
                }
                try {
                    icon = (ImageIcon)this.get();
                }
                catch (InterruptedException e) {
                    icon = null;
                }
                catch (ExecutionException e) {
                    icon = null;
                }
                if (icon == null || icon.getImageLoadStatus() != 8) {
                    PackageDetailPanel.this.removeImage();
                    System.err.println("Couldn't load image " + PackageDetailPanel.this.current.getId());
                } else {
                    PackageDetailPanel.this.image.setIcon(icon);
                    PackageDetailPanel.this.imagePanel.setMinimumSize(DEFAULTIMAGESIZE);
                }
                PackageDetailPanel.this.revalidate();
                PackageDetailPanel.this.repaint();
            }
        }.execute();
        this.description.getEditorKit().createDefaultDocument();
        this.description.setText(this.current.getDescription() + this.toString(this.current.getRequirements()) + "<p></p>");
        this.description.setCaretPosition(0);
        this.revalidate();
        this.repaint();
    }

    private String toString(Date date) {
        SimpleDateFormat dfm = new SimpleDateFormat("MMM d, yyyy");
        dfm.setTimeZone(TimeZone.getTimeZone("Europe/Berlin"));
        return dfm.format(date);
    }

    private String toString(List<Requirement> requirements) {
        if (requirements.isEmpty()) {
            return "";
        }
        ArrayList<String> links = new ArrayList<String>(requirements.size());
        for (Requirement r : requirements) {
            links.add("<a href=\"" + r.getId() + ".html\">" + r.getId() + "</a>");
        }
        return "<p>Requires: " + Utils.join(links, ", ") + ".</p>";
    }

    @Override
    public void selectionChanged(Package map) {
        this.current = map;
        this.refreshUi();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        System.out.println("StateChanged()");
        this.refreshUi();
    }
}

