/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.EngineOutputDialog;
import de.haukerehfeld.quakeinjector.EngineStarter;
import de.haukerehfeld.quakeinjector.FileNotWritableException;
import de.haukerehfeld.quakeinjector.InstallQueuePanel;
import de.haukerehfeld.quakeinjector.Installer;
import de.haukerehfeld.quakeinjector.OnlineFileNotFoundException;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.PackageListSelectionHandler;
import de.haukerehfeld.quakeinjector.PackageOverwriteDialog;
import de.haukerehfeld.quakeinjector.QuakeInjector;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.RequirementList;
import de.haukerehfeld.quakeinjector.SaveInstalled;
import de.haukerehfeld.quakeinjector.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PackageInteractionPanel
extends JPanel
implements ChangeListener,
PackageListSelectionHandler.SelectionListener {
    private static final String uninstallText = "Uninstall";
    private static final String installText = "Install";
    private static final String playText = "Play";
    private QuakeInjector main;
    private EngineStarter starter;
    private Configuration.RepositoryBasePath paths;
    private RequirementList requirements;
    private InstallQueuePanel installQueue;
    private JButton uninstallButton;
    private JButton installButton;
    private JButton playButton;
    private JComboBox startmaps;
    private boolean ready = false;
    private Package selectedMap = null;
    private Installer installer;
    private SaveInstalled installedMaps;

    public PackageInteractionPanel(QuakeInjector main, InstallQueuePanel installQueue) {
        super(new GridBagLayout());
        this.main = main;
        this.installQueue = installQueue;
        this.uninstallButton = new JButton(uninstallText);
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageInteractionPanel.this.uninstall();
            }
        });
        this.add((Component)this.uninstallButton, new GridBagConstraints(){
            {
                this.fill = 1;
            }
        });
        this.installButton = new JButton(installText);
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageInteractionPanel.this.install();
            }
        });
        this.add((Component)this.installButton, new GridBagConstraints(){
            {
                this.gridx = 1;
                this.gridy = 0;
                this.fill = 1;
            }
        });
        this.playButton = new JButton(playText);
        this.playButton.setEnabled(false);
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageInteractionPanel.this.start();
            }
        });
        this.add((Component)this.playButton, new GridBagConstraints(){
            {
                this.gridx = 0;
                this.gridy = 1;
                this.fill = 1;
            }
        });
        this.startmaps = new JComboBox();
        this.add((Component)this.startmaps, new GridBagConstraints(){
            {
                this.gridx = 1;
                this.gridy = 1;
                this.fill = 1;
                this.weightx = 1.0;
            }
        });
        this.disableUI();
        this.refreshUi();
    }

    public void init(Installer installer, Configuration.RepositoryBasePath paths, RequirementList requirements, EngineStarter starter, SaveInstalled installedMaps) {
        this.paths = paths;
        this.requirements = requirements;
        this.starter = starter;
        this.installedMaps = installedMaps;
        this.installer = installer;
        this.ready = true;
        this.refreshUi();
    }

    public void installRequirements(Package map) {
        for (Package requirement : map.getAvailableRequirements()) {
            String id = requirement.getId();
            if (requirement.isInstalled()) {
                System.out.print("Required package " + id + " already installed.");
                continue;
            }
            System.out.print("Required package " + id + " not installed. Installing...");
            this.install(requirement, true);
        }
    }

    private boolean hasCurrentPackage() {
        return this.selectedMap != null;
    }

    public void install() {
        if (!this.hasCurrentPackage()) {
            return;
        }
        this.install(this.selectedMap, false);
    }

    private boolean checkInstallRequirements(Package selectedMap) {
        List<Requirement> unmet = selectedMap.getUnavailableRequirements();
        if (!unmet.isEmpty()) {
            String msg = "The following prerequisites to play " + selectedMap.getId() + " can't be installed automatically:\n" + Utils.join(unmet, ",\n") + ".\n";
            Object[] options = new Object[]{"Install anyways", "Cancel Install"};
            int install = JOptionPane.showOptionDialog(this, msg, "Prerequisites not available for automatic install", 0, 2, null, options, options[1]);
            if (install != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPlayRequirements(Package selectedMap) {
        if (!selectedMap.isInstalled()) {
            String msg = selectedMap.getId() + " doesn't seem to be installed.";
            Object[] options = new Object[]{installText, "Cancel Start"};
            int install = JOptionPane.showOptionDialog(this, msg, "Map not installed", 0, 2, null, options, options[1]);
            if (install == 0) {
                this.install(selectedMap, false);
            }
            return false;
        }
        List<Requirement> unmet = selectedMap.getUnmetRequirements();
        if (!unmet.isEmpty()) {
            String msg = "The following prerequisites to play " + selectedMap.getId() + " don't seem to be installed: \n" + Utils.join(unmet, ",\n ") + ".\nYou probably can't play this package.";
            Object[] options = new Object[]{"Start anyways", "Cancel Start"};
            int install = JOptionPane.showOptionDialog(this, msg, "Prerequisites not installed", 0, 2, null, options, options[1]);
            if (install != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkInstallDirectory() {
        while (!this.installer.checkInstallDirectory()) {
            if (this.main.enginePathNotSetDialogue()) continue;
            return false;
        }
        return true;
    }

    public void install(final Package selectedMap, boolean becauseRequired) {
        if (!this.checkInstallDirectory() || this.installer.alreadyQueued(selectedMap) || !this.checkInstallRequirements(selectedMap)) {
            return;
        }
        this.installRequirements(selectedMap);
        String description = "Installing ";
        if (becauseRequired) {
            description = description + "prerequisite ";
        }
        description = description + selectedMap.getId();
        final InstallQueuePanel.Job progressListener = this.installQueue.addJob(description, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageInteractionPanel.this.installer.cancel(selectedMap);
            }
        });
        this.installer.install(selectedMap, this.paths.getRepositoryUrl(selectedMap.getId()), new Installer.InstallErrorHandler(){

            @Override
            public void handle(OnlineFileNotFoundException error) {
                PackageInteractionPanel.this.installQueue.finished(progressListener, "File not found");
                PackageInteractionPanel.this.refreshUi();
                String msg = "The file couldn't be found in the online repository";
                JOptionPane.showMessageDialog(PackageInteractionPanel.this, msg, "File not found (404)", 2);
            }

            @Override
            public List<File> overwrite(Map<String, File> files) {
                PackageOverwriteDialog overwrite = new PackageOverwriteDialog(PackageInteractionPanel.this.main);
                for (Map.Entry<String, File> e : files.entrySet()) {
                    String name = e.getKey();
                    File f = e.getValue();
                    overwrite.addFile(name, f.exists());
                }
                overwrite.packAndShow();
                ArrayList<File> overwriteFiles = new ArrayList<File>();
                if (overwrite.isCanceled()) {
                    return overwriteFiles;
                }
                for (String name : overwrite.getOverwritten()) {
                    overwriteFiles.add(files.get(name));
                }
                return overwriteFiles;
            }

            @Override
            public void success(PackageFileList installedFiles) {
                Requirement r = PackageInteractionPanel.this.requirements.get(installedFiles.getId());
                r.setInstalled(true);
                if (!(r instanceof Package)) {
                    System.err.println(r + " isn't a Package!");
                } else {
                    ((Package)r).setFileList(installedFiles);
                }
                try {
                    PackageInteractionPanel.this.installedMaps.write(PackageInteractionPanel.this.requirements);
                }
                catch (IOException e) {
                    System.out.println("Couldn't write installed Maps file!" + e.getMessage());
                }
                progressListener.setProgress(100);
                PackageInteractionPanel.this.installQueue.finished(progressListener, "Success");
                PackageInteractionPanel.this.refreshUi();
            }

            @Override
            public void handle(FileNotWritableException error, PackageFileList alreadyInstalledFiles) {
                this.cleanup(alreadyInstalledFiles, "Couldn't write");
                String msg = "Couldn't write to harddisk! " + error.getMessage();
                JOptionPane.showMessageDialog(PackageInteractionPanel.this, msg, "Couldn't write to harddisk", 0);
            }

            @Override
            public void handle(IOException error, PackageFileList alreadyInstalledFiles) {
                this.cleanup(alreadyInstalledFiles, "File Error");
                String msg = "Couldn't open file! " + error.getMessage();
                JOptionPane.showMessageDialog(PackageInteractionPanel.this, msg, "Couldn't open file!", 0);
            }

            @Override
            public void handle(SocketException error, PackageFileList alreadyInstalledFiles) {
                this.cleanup(alreadyInstalledFiles, "Network Error");
                String msg = "Download failed! " + error.getMessage();
                JOptionPane.showMessageDialog(PackageInteractionPanel.this, msg, "Download failed!", 0);
            }

            @Override
            public void handle(Installer.CancelledException error, PackageFileList alreadyInstalledFiles) {
                this.cleanup(alreadyInstalledFiles, "Canceled");
            }

            private void cleanup(PackageFileList alreadyInstalledFiles, String message) {
                System.out.println("Cleaning up...");
                PackageInteractionPanel.this.uninstall(selectedMap, alreadyInstalledFiles);
                PackageInteractionPanel.this.installQueue.finished(progressListener, message);
                PackageInteractionPanel.this.refreshUi();
            }
        }, progressListener);
        this.installButton.setEnabled(false);
    }

    public void uninstall() {
        if (!this.checkInstallDirectory()) {
            return;
        }
        if (!this.hasCurrentPackage()) {
            return;
        }
        this.uninstall(this.selectedMap, this.selectedMap.getFileList());
        this.uninstallButton.setEnabled(false);
    }

    private void uninstall(final Package map, PackageFileList files) {
        String description = "Uninstalling " + files.getId();
        final InstallQueuePanel.Job progressListener = this.installQueue.addJob(description, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.installer.uninstall(files, new Installer.UninstallErrorHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void success() {
                PackageInteractionPanel.this.installQueue.finished(progressListener, "success");
                Package package_ = map;
                synchronized (package_) {
                    map.setInstalled(false);
                }
                SwingWorker<Void, Void> saveInstalled = new SwingWorker<Void, Void>(){

                    @Override
                    public Void doInBackground() {
                        try {
                            PackageInteractionPanel.this.installedMaps.write(PackageInteractionPanel.this.requirements);
                        }
                        catch (IOException e) {
                            System.out.println("Couldn't write installed Maps file!" + e.getMessage());
                        }
                        return null;
                    }
                };
                saveInstalled.execute();
                PackageInteractionPanel.this.refreshUi();
            }

            @Override
            public void error(Exception e) {
                PackageInteractionPanel.this.refreshUi();
                PackageInteractionPanel.this.installQueue.finished(progressListener, "fail");
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }, progressListener);
    }

    public void start() {
        if (!this.hasCurrentPackage()) {
            return;
        }
        if (!this.starter.checkPaths()) {
            JOptionPane.showMessageDialog(this.main, "Quake engine paths aren't set correctly, can't start.", "Quake engine paths not configured", 0);
            return;
        }
        if (!this.checkPlayRequirements(this.selectedMap)) {
            return;
        }
        String startmap = (String)this.startmaps.getSelectedItem();
        try {
            Process p = this.starter.start(this.selectedMap.getCommandline(), startmap);
            EngineOutputDialog e = new EngineOutputDialog(this.main, p.getInputStream());
            e.pack();
            e.setLocationRelativeTo(this.main);
            e.show();
        }
        catch (IOException e) {
            System.out.println("Couldn't start quake engine: " + e.getMessage());
        }
    }

    public void setSelection(Package map) {
        this.selectedMap = map;
        this.refreshUi();
    }

    private void refreshUi() {
        if (!this.ready || !this.hasCurrentPackage()) {
            this.installButton.setText(installText);
            this.disableUI();
            return;
        }
        this.installButton.setText("Install " + this.selectedMap.getId());
        List<String> maps = this.selectedMap.getStartmaps();
        this.startmaps.removeAllItems();
        for (String startmap : maps) {
            this.startmaps.addItem(startmap);
        }
        if (this.selectedMap.isInstalled()) {
            this.installButton.setEnabled(false);
            this.uninstallButton.setEnabled(true);
            this.playButton.setEnabled(true);
            boolean enableList = false;
            if (maps.size() > 1) {
                enableList = true;
            }
            this.startmaps.setEnabled(enableList);
        } else {
            if (this.installer.alreadyQueued(this.selectedMap)) {
                this.installButton.setEnabled(false);
            } else {
                this.installButton.setEnabled(true);
            }
            this.playButton.setEnabled(false);
            this.uninstallButton.setEnabled(false);
            this.startmaps.setEnabled(false);
        }
        this.revalidate();
        this.repaint();
    }

    private void disableUI() {
        this.uninstallButton.setEnabled(false);
        this.playButton.setEnabled(false);
        this.installButton.setEnabled(false);
        this.startmaps.setEnabled(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshUi();
    }

    @Override
    public void selectionChanged(Package s) {
        this.setSelection(s);
    }
}

