/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.RequirementList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PackageList
implements Iterable<Package>,
ChangeListener {
    private List<Package> packages = new ArrayList<Package>();
    private RequirementList requirements;
    private ChangeListenerList listeners = new ChangeListenerList();

    public PackageList(RequirementList requirements) {
        this.requirements = requirements;
        this.setRequirements(requirements);
    }

    private void setRequirements(RequirementList requirements) {
        this.packages.clear();
        for (Requirement r : requirements) {
            if (!(r instanceof Package)) continue;
            this.packages.add((Package)r);
        }
        this.requirements = requirements;
        this.requirements.addChangeListener(this);
        this.notifyChangeListeners();
    }

    public void sort() {
        Collections.sort(this.packages);
    }

    public Package get(int i) {
        return this.packages.get(i);
    }

    public Package get(String id) {
        Requirement r = this.requirements.get(id);
        if (!(r instanceof Package)) {
            return null;
        }
        return (Package)r;
    }

    @Override
    public Iterator<Package> iterator() {
        return this.packages.iterator();
    }

    public int size() {
        return this.packages.size();
    }

    public int indexOf(Package r) {
        return this.packages.indexOf(r);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    private void notifyChangeListeners() {
        this.listeners.notifyChangeListeners(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!(e.getSource() instanceof RequirementList)) {
            throw new RuntimeException("getting change events with source not a RequirementList");
        }
        this.setRequirements((RequirementList)e.getSource());
    }
}

